/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.alicebot.ab.AIMLMap;
import org.alicebot.ab.AIMLProcessorExtension;
import org.alicebot.ab.Category;
import org.alicebot.ab.Chat;
import org.alicebot.ab.Clause;
import org.alicebot.ab.History;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicNumbers;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Nodemapper;
import org.alicebot.ab.ParseState;
import org.alicebot.ab.Sraix;
import org.alicebot.ab.TripleStore;
import org.alicebot.ab.Tuple;
import org.alicebot.ab.Utilities;
import org.alicebot.ab.utils.CalendarUtils;
import org.alicebot.ab.utils.DomUtils;
import org.alicebot.ab.utils.IOUtils;
import org.alicebot.ab.utils.IntervalUtils;
import org.alicebot.ab.utils.JapaneseUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AIMLProcessor {
    private static final Logger log = LoggerFactory.getLogger(AIMLProcessor.class);
    public static AIMLProcessorExtension extension;
    private static int sraiCount;

    private static void categoryProcessor(Node n, ArrayList<Category> categories, String topic, String aimlFile, String language) {
        NodeList children = n.getChildNodes();
        String pattern = "*";
        String that = "*";
        String template = "";
        block14: for (int j = 0; j < children.getLength(); ++j) {
            String mName;
            if (log.isDebugEnabled()) {
                log.debug("CHILD: {}", (Object)children.item(j).getNodeName());
            }
            Node m = children.item(j);
            switch (mName = m.getNodeName()) {
                case "#text": {
                    continue block14;
                }
                case "pattern": {
                    pattern = DomUtils.nodeToString(m);
                    continue block14;
                }
                case "that": {
                    that = DomUtils.nodeToString(m);
                    continue block14;
                }
                case "topic": {
                    topic = DomUtils.nodeToString(m);
                    continue block14;
                }
                case "template": {
                    template = DomUtils.nodeToString(m);
                    continue block14;
                }
                default: {
                    log.warn("categoryProcessor: unexpected {} in {}", (Object)mName, (Object)DomUtils.nodeToString(m));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("categoryProcessor: pattern={}", (Object)pattern);
        }
        pattern = AIMLProcessor.trimTag(pattern, "pattern");
        that = AIMLProcessor.trimTag(that, "that");
        topic = AIMLProcessor.trimTag(topic, "topic");
        pattern = AIMLProcessor.cleanPattern(pattern);
        that = AIMLProcessor.cleanPattern(that);
        topic = AIMLProcessor.cleanPattern(topic);
        template = AIMLProcessor.trimTag(template, "template");
        if (MagicBooleans.jp_tokenize) {
            pattern = JapaneseUtils.tokenizeSentence(pattern);
            that = JapaneseUtils.tokenizeSentence(that);
            topic = JapaneseUtils.tokenizeSentence(topic);
        }
        Category c = new Category(0, pattern, that, topic, template, aimlFile);
        if (StringUtils.isEmpty((CharSequence)template)) {
            log.info("Category {} discarded due to blank or missing <template>.", (Object)c.inputThatTopic());
        } else {
            categories.add(c);
        }
    }

    private static String cleanPattern(String pattern) {
        pattern = pattern.replaceAll("(\r\n|\n\r|\r|\n)", " ");
        pattern = pattern.replaceAll("  ", " ");
        return pattern.trim();
    }

    public static String trimTag(String s, String tagName) {
        String stag = "<" + tagName + ">";
        String etag = "</" + tagName + ">";
        if (s.startsWith(stag) && s.endsWith(etag)) {
            s = s.substring(stag.length());
            s = s.substring(0, s.length() - etag.length());
        }
        return s.trim();
    }

    public static ArrayList<Category> AIMLToCategories(String directory, String aimlFile) {
        try {
            int i;
            ArrayList<Category> categories = new ArrayList<Category>();
            Node root = DomUtils.parseFile(directory + "/" + aimlFile);
            String language = MagicStrings.default_language;
            if (root.hasAttributes()) {
                NamedNodeMap XMLAttributes = root.getAttributes();
                for (i = 0; i < XMLAttributes.getLength(); ++i) {
                    if (!"language".equals(XMLAttributes.item(i).getNodeName())) continue;
                    language = XMLAttributes.item(i).getNodeValue();
                }
            }
            NodeList nodelist = root.getChildNodes();
            for (i = 0; i < nodelist.getLength(); ++i) {
                Node n = nodelist.item(i);
                if (log.isTraceEnabled()) {
                    log.trace("AIML child: {}", (Object)n.getNodeName());
                }
                if ("category".equals(n.getNodeName())) {
                    AIMLProcessor.categoryProcessor(n, categories, "*", aimlFile, language);
                    continue;
                }
                if (!"topic".equals(n.getNodeName())) continue;
                String topic = n.getAttributes().getNamedItem("name").getTextContent();
                if (log.isTraceEnabled()) {
                    log.trace("topic: {}", (Object)topic);
                }
                NodeList children = n.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node m = children.item(j);
                    if (log.isTraceEnabled()) {
                        log.trace("Topic child: {}", (Object)m.getNodeName());
                    }
                    if (!"category".equals(m.getNodeName())) continue;
                    AIMLProcessor.categoryProcessor(m, categories, topic, aimlFile, language);
                }
            }
            return categories;
        }
        catch (Exception e) {
            log.error("AIMLToCategories Error:", (Throwable)e);
            return null;
        }
    }

    public static String respond(String input, String that, String topic, Chat chatSession) {
        return AIMLProcessor.respond(input, that, topic, chatSession, 0);
    }

    public static String respond(String input, String that, String topic, Chat chatSession, int srCnt) {
        if (log.isTraceEnabled()) {
            log.trace("input: {}, that: {}, topic: {}, chatSession: {}, srCnt: {}", new Object[]{input, that, topic, chatSession, srCnt});
        }
        if (input == null || input.length() == 0) {
            input = MagicStrings.null_input;
        }
        sraiCount = srCnt;
        String response = MagicStrings.default_bot_response;
        try {
            Nodemapper leaf = chatSession.getBot().getBrain().match(input, that, topic);
            if (leaf == null) {
                return response;
            }
            ParseState ps = new ParseState(0, chatSession, input, that, topic, leaf);
            String template = leaf.getCategory().getTemplate();
            response = AIMLProcessor.evalTemplate(template, ps);
            if (log.isTraceEnabled()) {
                log.trace("in AIMLProcessor.respond(), template={}, trat={}", (Object)template, (Object)that);
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return response;
    }

    private static String capitalizeString(String string) {
        char[] chars = string.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i])) continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    private static String explode(String input) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            builder.append(" ").append(input.charAt(i));
        }
        String result = builder.toString();
        while (result.contains("  ")) {
            result = result.replace("  ", " ");
        }
        return result.trim();
    }

    public static String evalTagContent(Node node, ParseState ps, Set<String> ignoreAttributes) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.evalTagContent(node: {}, ps: {}, ignoreAttributes: {}", new Object[]{node, ps, ignoreAttributes});
            log.trace("in AIMLProcessor.evalTagContent, node string: {}", (Object)DomUtils.nodeToString(node));
        }
        StringBuilder result = new StringBuilder();
        try {
            NodeList childList = node.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                if (log.isTraceEnabled()) {
                    log.trace("in AIMLProcessor.evalTagContent(), child: {}", (Object)child);
                }
                if (ignoreAttributes == null || !ignoreAttributes.contains(child.getNodeName())) {
                    result.append(AIMLProcessor.recursEval(child, ps));
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("in AIMLProcessor.evalTagContent(), result: ", (Object)result);
            }
        }
        catch (Exception e) {
            log.error("Something went wrong with evalTagContent", (Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.evalTagContent() returning: {}", (Object)result);
        }
        return result.toString();
    }

    public static String genericXML(Node node, ParseState ps) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.genericXML(node: {}, ps: {}", (Object)node, (Object)ps);
        }
        String evalResult = AIMLProcessor.evalTagContent(node, ps, null);
        String result = AIMLProcessor.unevaluatedXML(evalResult, node, ps);
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.genericXML(), returning: {}", (Object)result);
        }
        return result;
    }

    private static String unevaluatedXML(String resultIn, Node node, ParseState ps) {
        String nodeName = node.getNodeName();
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.unevaluatedXML(resultIn: {}, node: {}, nodeName: {}, ps: {}", new Object[]{resultIn, node, nodeName, ps});
        }
        StringBuilder attributes = new StringBuilder();
        if (node.hasAttributes()) {
            NamedNodeMap XMLAttributes = node.getAttributes();
            for (int i = 0; i < XMLAttributes.getLength(); ++i) {
                attributes.append(" ").append(XMLAttributes.item(i).getNodeName()).append("=\"").append(XMLAttributes.item(i).getNodeValue()).append("\"");
            }
        }
        String result = "<" + nodeName + attributes + "/>";
        if (!"".equals(resultIn)) {
            result = "<" + nodeName + attributes + ">" + resultIn + "</" + nodeName + ">";
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.unevaluatedXML() returning: {}", (Object)result);
        }
        return result;
    }

    private static String srai(Node node, ParseState ps) {
        String result;
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.srai(node: {}, ps: {}", (Object)node, (Object)ps);
        }
        if (++sraiCount > MagicNumbers.max_recursion_count || ps.getDepth() > MagicNumbers.max_recursion_depth) {
            return MagicStrings.too_much_recursion;
        }
        String response = MagicStrings.default_bot_response;
        try {
            Nodemapper leaf;
            result = AIMLProcessor.evalTagContent(node, ps, null);
            result = result.trim();
            result = result.replaceAll("(\r\n|\n\r|\r|\n)", " ");
            result = ps.getChatSession().getBot().getPreProcessor().normalize(result);
            result = JapaneseUtils.tokenizeSentence(result);
            String topic = ps.getChatSession().getPredicates().get("topic");
            if (log.isTraceEnabled()) {
                log.trace("<srai>{}</srai> from {} topic={}", new Object[]{result, ps.getLeaf().getCategory().inputThatTopic(), topic});
            }
            if ((leaf = ps.getChatSession().getBot().getBrain().match(result, ps.getThat(), topic)) == null) {
                return response;
            }
            if (log.isTraceEnabled()) {
                log.trace("Srai returned {}:{}, that=", (Object)leaf.getCategory().inputThatTopic(), (Object)leaf.getCategory().getTemplate());
            }
            response = AIMLProcessor.evalTemplate(leaf.getCategory().getTemplate(), new ParseState(ps.getDepth() + 1, ps.getChatSession(), ps.getInput(), ps.getThat(), topic, leaf));
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        result = response.trim();
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.srai(), returning: {}", (Object)result);
        }
        return result;
    }

    private static String getAttributeOrTagValue(Node node, ParseState ps, String attributeName) {
        String result;
        Node m;
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.getAttributeOrTagValue (node: {}, attributeName: {})", (Object)node, (Object)attributeName);
        }
        if ((m = node.getAttributes().getNamedItem(attributeName)) == null) {
            NodeList childList = node.getChildNodes();
            result = null;
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                if (log.isTraceEnabled()) {
                    log.trace("getAttributeOrTagValue child = {}", (Object)child.getNodeName());
                }
                if (!child.getNodeName().equals(attributeName)) continue;
                result = AIMLProcessor.evalTagContent(child, ps, null);
                if (!log.isTraceEnabled()) continue;
                log.trace("getAttributeOrTagValue result from child = {}", (Object)result);
            }
        } else {
            result = m.getNodeValue();
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.getAttributeOrTagValue (), returning: {}", (Object)result);
        }
        return result;
    }

    private static String sraix(Node node, ParseState ps) {
        Set<String> attributeNames = Utilities.stringSet("botid", "host");
        String host = AIMLProcessor.getAttributeOrTagValue(node, ps, "host");
        String botid = AIMLProcessor.getAttributeOrTagValue(node, ps, "botid");
        String hint = AIMLProcessor.getAttributeOrTagValue(node, ps, "hint");
        String limit = AIMLProcessor.getAttributeOrTagValue(node, ps, "limit");
        String defaultResponse = AIMLProcessor.getAttributeOrTagValue(node, ps, "default");
        String evalResult = AIMLProcessor.evalTagContent(node, ps, attributeNames);
        return Sraix.sraix(ps.getChatSession(), evalResult, defaultResponse, hint, host, botid, null, limit);
    }

    private static String map(Node node, ParseState ps) {
        String result = MagicStrings.default_map;
        Set<String> attributeNames = Utilities.stringSet("name");
        String mapName = AIMLProcessor.getAttributeOrTagValue(node, ps, "name");
        String contents = AIMLProcessor.evalTagContent(node, ps, attributeNames);
        contents = contents.trim();
        if (mapName == null) {
            result = "<map>" + contents + "</map>";
        } else {
            AIMLMap map = ps.getChatSession().getBot().getMapMap().get(mapName);
            if (map != null) {
                result = map.get(contents.toUpperCase());
            }
            if (log.isTraceEnabled()) {
                log.trace("AIMLProcessor map {} ", (Object)result);
            }
            if (result == null) {
                result = MagicStrings.default_map;
            }
            result = result.trim();
        }
        return result;
    }

    private static String set(Node node, ParseState ps) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.set(node: {}, ps: {})", (Object)node, (Object)ps);
        }
        Set<String> attributeNames = Utilities.stringSet("name", "var");
        String predicateName = AIMLProcessor.getAttributeOrTagValue(node, ps, "name");
        String varName = AIMLProcessor.getAttributeOrTagValue(node, ps, "var");
        String result = AIMLProcessor.evalTagContent(node, ps, attributeNames).trim();
        result = result.replaceAll("(\r\n|\n\r|\r|\n)", " ");
        String value = result.trim();
        if (predicateName != null) {
            ps.getChatSession().getPredicates().put(predicateName, result);
            if (log.isTraceEnabled()) {
                log.trace("Set predicate {} to {} in {}", new Object[]{predicateName, result, ps.getLeaf().getCategory().inputThatTopic()});
            }
        }
        if (varName != null) {
            ps.getVars().put(varName, result);
            if (log.isTraceEnabled()) {
                log.trace("Set var {} to {} in {}", new Object[]{varName, value, ps.getLeaf().getCategory().inputThatTopic()});
            }
        }
        if (ps.getChatSession().getBot().getPronounSet().contains(predicateName)) {
            result = predicateName;
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.set, returning: {}", (Object)result);
        }
        return result;
    }

    private static String get(Node node, ParseState ps) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.get(node: {}, ps: {})", (Object)node, (Object)ps);
        }
        String result = MagicStrings.default_get;
        String predicateName = AIMLProcessor.getAttributeOrTagValue(node, ps, "name");
        String varName = AIMLProcessor.getAttributeOrTagValue(node, ps, "var");
        String tupleName = AIMLProcessor.getAttributeOrTagValue(node, ps, "tuple");
        if (predicateName != null) {
            result = ps.getChatSession().getPredicates().get(predicateName).trim();
        } else if (varName != null && tupleName != null) {
            result = AIMLProcessor.tupleGet(tupleName, varName);
        } else if (varName != null) {
            result = ps.getVars().get(varName).trim();
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.get, returning: {}", (Object)result);
        }
        return result;
    }

    private static String tupleGet(String tupleName, String varName) {
        Tuple tuple = Tuple.tupleMap.get(tupleName);
        return tuple == null ? MagicStrings.default_get : tuple.getValue(varName);
    }

    private static String bot(Node node, ParseState ps) {
        String result = MagicStrings.default_property;
        String propertyName = AIMLProcessor.getAttributeOrTagValue(node, ps, "name");
        if (propertyName != null) {
            result = ps.getChatSession().getBot().getProperties().get(propertyName).trim();
        }
        return result;
    }

    private static String date(Node node, ParseState ps) {
        String jformat = AIMLProcessor.getAttributeOrTagValue(node, ps, "jformat");
        String locale = AIMLProcessor.getAttributeOrTagValue(node, ps, "locale");
        String timezone = AIMLProcessor.getAttributeOrTagValue(node, ps, "timezone");
        return CalendarUtils.date(jformat, locale, timezone);
    }

    private static String interval(Node node, ParseState ps) {
        String style = AIMLProcessor.getAttributeOrTagValue(node, ps, "style");
        String jformat = AIMLProcessor.getAttributeOrTagValue(node, ps, "jformat");
        String from = AIMLProcessor.getAttributeOrTagValue(node, ps, "from");
        String to = AIMLProcessor.getAttributeOrTagValue(node, ps, "to");
        if (style == null) {
            style = "years";
        }
        if (jformat == null) {
            jformat = "MMMMMMMMM dd, yyyy";
        }
        if (from == null) {
            from = "January 1, 1970";
        }
        if (to == null) {
            to = CalendarUtils.date(jformat, null, null);
        }
        String result = "unknown";
        if ("years".equals(style)) {
            result = "" + IntervalUtils.getYearsBetween(from, to, jformat);
        }
        if ("months".equals(style)) {
            result = "" + IntervalUtils.getMonthsBetween(from, to, jformat);
        }
        if ("days".equals(style)) {
            result = "" + IntervalUtils.getDaysBetween(from, to, jformat);
        }
        if ("hours".equals(style)) {
            result = "" + IntervalUtils.getHoursBetween(from, to, jformat);
        }
        return result;
    }

    private static int getIndexValue(Node node, ParseState ps) {
        String value = AIMLProcessor.getAttributeOrTagValue(node, ps, "index");
        if (value != null) {
            try {
                return Integer.parseInt(value) - 1;
            }
            catch (Exception e) {
                log.error("Error: ", (Throwable)e);
            }
        }
        return 0;
    }

    private static String inputStar(Node node, ParseState ps) {
        int index = AIMLProcessor.getIndexValue(node, ps);
        if (ps.getStarBindings().getInputStars().star(index) == null) {
            return "";
        }
        return ps.getStarBindings().getInputStars().star(index).trim();
    }

    private static String thatStar(Node node, ParseState ps) {
        int index = AIMLProcessor.getIndexValue(node, ps);
        if (ps.getStarBindings().getThatStars().star(index) == null) {
            return "";
        }
        return ps.getStarBindings().getThatStars().star(index).trim();
    }

    private static String topicStar(Node node, ParseState ps) {
        int index = AIMLProcessor.getIndexValue(node, ps);
        if (ps.getStarBindings().getTopicStars().star(index) == null) {
            return "";
        }
        return ps.getStarBindings().getTopicStars().star(index).trim();
    }

    private static String id(ParseState ps) {
        return ps.getChatSession().getCustomerId();
    }

    private static String size(ParseState ps) {
        int size = ps.getChatSession().getBot().getBrain().getCategories().size();
        return String.valueOf(size);
    }

    private static String vocabulary(ParseState ps) {
        int size = ps.getChatSession().getBot().getBrain().getVocabulary().size();
        return String.valueOf(size);
    }

    private static String program() {
        return MagicStrings.program_name_version;
    }

    private static String that(Node node, ParseState ps) {
        int index = 0;
        int jndex = 0;
        String value = AIMLProcessor.getAttributeOrTagValue(node, ps, "index");
        if (value != null) {
            try {
                String[] spair = value.split(",");
                index = Integer.parseInt(spair[0]) - 1;
                jndex = Integer.parseInt(spair[1]) - 1;
                log.debug("That index={},{}", (Object)index, (Object)jndex);
            }
            catch (Exception e) {
                log.error("Error: ", (Throwable)e);
            }
        }
        String that = MagicStrings.unknown_history_item;
        History hist = ps.getChatSession().getThatHistory().get(index);
        if (hist != null) {
            that = (String)hist.get(jndex);
        }
        return that.trim();
    }

    private static String input(Node node, ParseState ps) {
        int index = AIMLProcessor.getIndexValue(node, ps);
        return ps.getChatSession().getInputHistory().getString(index);
    }

    private static String request(Node node, ParseState ps) {
        int index = AIMLProcessor.getIndexValue(node, ps);
        return ps.getChatSession().getRequestHistory().getString(index).trim();
    }

    private static String response(Node node, ParseState ps) {
        int index = AIMLProcessor.getIndexValue(node, ps);
        return ps.getChatSession().getResponseHistory().getString(index).trim();
    }

    private static String system(Node node, ParseState ps) {
        Set<String> attributeNames = Utilities.stringSet("timeout");
        String evaluatedContents = AIMLProcessor.evalTagContent(node, ps, attributeNames);
        return IOUtils.system(evaluatedContents, MagicStrings.system_failed);
    }

    private static String think(Node node, ParseState ps) {
        AIMLProcessor.evalTagContent(node, ps, null);
        return "";
    }

    private static String explode(Node node, ParseState ps) {
        String result = AIMLProcessor.evalTagContent(node, ps, null);
        return AIMLProcessor.explode(result);
    }

    private static String normalize(Node node, ParseState ps) {
        String result = AIMLProcessor.evalTagContent(node, ps, null);
        return ps.getChatSession().getBot().getPreProcessor().normalize(result);
    }

    private static String denormalize(Node node, ParseState ps) {
        String result = AIMLProcessor.evalTagContent(node, ps, null);
        return ps.getChatSession().getBot().getPreProcessor().denormalize(result);
    }

    private static String uppercase(Node node, ParseState ps) {
        String result = AIMLProcessor.evalTagContent(node, ps, null);
        return result.toUpperCase();
    }

    private static String lowercase(Node node, ParseState ps) {
        String result = AIMLProcessor.evalTagContent(node, ps, null);
        return result.toLowerCase();
    }

    private static String formal(Node node, ParseState ps) {
        String result = AIMLProcessor.evalTagContent(node, ps, null);
        return AIMLProcessor.capitalizeString(result);
    }

    private static String sentence(Node node, ParseState ps) {
        String result = AIMLProcessor.evalTagContent(node, ps, null);
        if (result.length() > 1) {
            return result.substring(0, 1).toUpperCase() + result.substring(1, result.length());
        }
        return "";
    }

    private static String person(Node node, ParseState ps) {
        String result = node.hasChildNodes() ? AIMLProcessor.evalTagContent(node, ps, null) : ps.getStarBindings().getInputStars().star(0);
        result = " " + result + " ";
        result = ps.getChatSession().getBot().getPreProcessor().person(result);
        return result.trim();
    }

    private static String person2(Node node, ParseState ps) {
        String result = node.hasChildNodes() ? AIMLProcessor.evalTagContent(node, ps, null) : ps.getStarBindings().getInputStars().star(0);
        result = " " + result + " ";
        result = ps.getChatSession().getBot().getPreProcessor().person2(result);
        return result.trim();
    }

    private static String gender(Node node, ParseState ps) {
        String result = AIMLProcessor.evalTagContent(node, ps, null);
        result = " " + result + " ";
        result = ps.getChatSession().getBot().getPreProcessor().gender(result);
        return result.trim();
    }

    private static String random(Node node, ParseState ps) {
        NodeList childList = node.getChildNodes();
        ArrayList<Node> liList = new ArrayList<Node>();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!childList.item(i).getNodeName().equals("li")) continue;
            liList.add(childList.item(i));
        }
        int index = (int)(Math.random() * (double)liList.size());
        if (MagicBooleans.qa_test_mode) {
            index = 0;
        }
        return AIMLProcessor.evalTagContent((Node)liList.get(index), ps, null);
    }

    private static String unevaluatedAIML(Node node, ParseState ps) {
        String result = AIMLProcessor.learnEvalTagContent(node, ps);
        return AIMLProcessor.unevaluatedXML(result, node, ps);
    }

    private static String recursLearn(Node node, ParseState ps) {
        String nodeName = node.getNodeName();
        if ("#text".equals(nodeName)) {
            return node.getNodeValue();
        }
        if ("eval".equals(nodeName)) {
            return AIMLProcessor.evalTagContent(node, ps, null);
        }
        return AIMLProcessor.unevaluatedAIML(node, ps);
    }

    private static String learnEvalTagContent(Node node, ParseState ps) {
        NodeList childList = node.getChildNodes();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            result.append(AIMLProcessor.recursLearn(child, ps));
        }
        return result.toString();
    }

    private static String learn(Node node, ParseState ps) {
        NodeList childList = node.getChildNodes();
        String pattern = "";
        String that = "*";
        String template = "";
        for (int i = 0; i < childList.getLength(); ++i) {
            Category c;
            if (!childList.item(i).getNodeName().equals("category")) continue;
            NodeList grandChildList = childList.item(i).getChildNodes();
            for (int j = 0; j < grandChildList.getLength(); ++j) {
                if (grandChildList.item(j).getNodeName().equals("pattern")) {
                    pattern = AIMLProcessor.recursLearn(grandChildList.item(j), ps);
                    continue;
                }
                if (grandChildList.item(j).getNodeName().equals("that")) {
                    that = AIMLProcessor.recursLearn(grandChildList.item(j), ps);
                    continue;
                }
                if (!grandChildList.item(j).getNodeName().equals("template")) continue;
                template = AIMLProcessor.recursLearn(grandChildList.item(j), ps);
            }
            pattern = pattern.substring("<pattern>".length(), pattern.length() - "</pattern>".length());
            if (log.isTraceEnabled()) {
                log.trace("Learn Pattern = {}", (Object)pattern);
            }
            if (template.length() >= "<template></template>".length()) {
                template = template.substring("<template>".length(), template.length() - "</template>".length());
            }
            if (that.length() >= "<that></that>".length()) {
                that = that.substring("<that>".length(), that.length() - "</that>".length());
            }
            pattern = pattern.toUpperCase();
            pattern = pattern.replaceAll("\n", " ");
            pattern = pattern.replaceAll("[ ]+", " ");
            that = that.toUpperCase();
            that = that.replaceAll("\n", " ");
            that = that.replaceAll("[ ]+", " ");
            if (log.isTraceEnabled()) {
                log.trace("Learn Pattern = {}", (Object)pattern);
                log.trace("Learn That = {}", (Object)that);
                log.trace("Learn Template = {}", (Object)template);
            }
            if (node.getNodeName().equals("learn")) {
                c = new Category(0, pattern, that, "*", template, MagicStrings.null_aiml_file);
                ps.getChatSession().getBot().getLearnGraph().addCategory(c);
            } else {
                c = new Category(0, pattern, that, "*", template, MagicStrings.learnf_aiml_file);
                ps.getChatSession().getBot().getLearnfGraph().addCategory(c);
            }
            ps.getChatSession().getBot().getBrain().addCategory(c);
        }
        return "";
    }

    private static String loopCondition(Node node, ParseState ps) {
        boolean loop = true;
        StringBuilder result = new StringBuilder();
        int loopCnt = 0;
        while (loop && loopCnt < MagicNumbers.max_loops) {
            String loopResult = AIMLProcessor.condition(node, ps);
            if (loopResult.trim().equals(MagicStrings.too_much_recursion)) {
                return MagicStrings.too_much_recursion;
            }
            if (loopResult.contains("<loop/>")) {
                loopResult = loopResult.replace("<loop/>", "");
                loop = true;
            } else {
                loop = false;
            }
            result.append(loopResult);
        }
        return loopCnt >= MagicNumbers.max_loops ? MagicStrings.too_much_looping : result.toString();
    }

    private static String condition(Node node, ParseState ps) {
        String value;
        NodeList childList = node.getChildNodes();
        ArrayList<Node> liList = new ArrayList<Node>();
        Set<String> attributeNames = Utilities.stringSet("name", "var", "value");
        String predicate = AIMLProcessor.getAttributeOrTagValue(node, ps, "name");
        String varName = AIMLProcessor.getAttributeOrTagValue(node, ps, "var");
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!childList.item(i).getNodeName().equals("li")) continue;
            liList.add(childList.item(i));
        }
        if (liList.size() == 0 && (value = AIMLProcessor.getAttributeOrTagValue(node, ps, "value")) != null && predicate != null && ps.getChatSession().getPredicates().get(predicate).equalsIgnoreCase(value)) {
            return AIMLProcessor.evalTagContent(node, ps, attributeNames);
        }
        if (liList.size() == 0 && (value = AIMLProcessor.getAttributeOrTagValue(node, ps, "value")) != null && varName != null && ps.getVars().get(varName).equalsIgnoreCase(value)) {
            return AIMLProcessor.evalTagContent(node, ps, attributeNames);
        }
        for (Node n : liList) {
            String liPredicate = predicate;
            String liVarName = varName;
            if (liPredicate == null) {
                liPredicate = AIMLProcessor.getAttributeOrTagValue(n, ps, "name");
            }
            if (liVarName == null) {
                liVarName = AIMLProcessor.getAttributeOrTagValue(n, ps, "var");
            }
            if ((value = AIMLProcessor.getAttributeOrTagValue(n, ps, "value")) != null) {
                if (liPredicate != null && (ps.getChatSession().getPredicates().get(liPredicate).equalsIgnoreCase(value) || ps.getChatSession().getPredicates().containsKey(liPredicate) && value.equals("*"))) {
                    return AIMLProcessor.evalTagContent(n, ps, attributeNames);
                }
                if (liVarName == null || !ps.getVars().get(liVarName).equalsIgnoreCase(value) && (!ps.getVars().containsKey(liPredicate) || !value.equals("*"))) continue;
                return AIMLProcessor.evalTagContent(n, ps, attributeNames);
            }
            return AIMLProcessor.evalTagContent(n, ps, attributeNames);
        }
        return "";
    }

    public static boolean evalTagForLoop(Node node) {
        NodeList childList = node.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            if (!childList.item(i).getNodeName().equals("loop")) continue;
            return true;
        }
        return false;
    }

    private static String deleteTriple(Node node, ParseState ps) {
        String subject = AIMLProcessor.getAttributeOrTagValue(node, ps, "subj");
        String predicate = AIMLProcessor.getAttributeOrTagValue(node, ps, "pred");
        String object = AIMLProcessor.getAttributeOrTagValue(node, ps, "obj");
        return ps.getChatSession().getTripleStore().deleteTriple(subject, predicate, object);
    }

    private static String addTriple(Node node, ParseState ps) {
        String subject = AIMLProcessor.getAttributeOrTagValue(node, ps, "subj");
        String predicate = AIMLProcessor.getAttributeOrTagValue(node, ps, "pred");
        String object = AIMLProcessor.getAttributeOrTagValue(node, ps, "obj");
        return ps.getChatSession().getTripleStore().addTriple(subject, predicate, object);
    }

    private static String uniq(Node node, ParseState ps) {
        HashSet<String> vars = new HashSet<String>();
        HashSet<String> visibleVars = new HashSet<String>();
        String subj = "?subject";
        String pred = "?predicate";
        String obj = "?object";
        NodeList childList = node.getChildNodes();
        for (int j = 0; j < childList.getLength(); ++j) {
            Node childNode = childList.item(j);
            String contents = AIMLProcessor.evalTagContent(childNode, ps, null);
            if (childNode.getNodeName().equals("subj")) {
                subj = contents;
            } else if (childNode.getNodeName().equals("pred")) {
                pred = contents;
            } else if (childNode.getNodeName().equals("obj")) {
                obj = contents;
            }
            if (!contents.startsWith("?")) continue;
            visibleVars.add(contents);
            vars.add(contents);
        }
        Tuple partial = new Tuple(vars, visibleVars);
        Clause clause = new Clause(subj, pred, obj);
        Set<Tuple> tuples = ps.getChatSession().getTripleStore().selectFromSingleClause(partial, clause, true);
        String tupleList = tuples.stream().map(Tuple::getName).collect(Collectors.joining(" "));
        if (tupleList.length() == 0) {
            tupleList = "NIL";
        }
        String var = "";
        Iterator<String> iterator = visibleVars.iterator();
        while (iterator.hasNext()) {
            String x;
            var = x = iterator.next();
        }
        String firstTuple = AIMLProcessor.firstWord(tupleList);
        return AIMLProcessor.tupleGet(firstTuple, var);
    }

    public static String select(Node node, ParseState ps) {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        NodeList childList = node.getChildNodes();
        HashSet<String> vars = new HashSet<String>();
        HashSet<String> visibleVars = new HashSet<String>();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node childNode = childList.item(i);
            if (childNode.getNodeName().equals("vars")) {
                String[] splitVars;
                String contents = AIMLProcessor.evalTagContent(childNode, ps, null);
                for (String var : splitVars = contents.split(" ")) {
                    if ((var = var.trim()).length() <= 0) continue;
                    visibleVars.add(var);
                }
                continue;
            }
            if (!childNode.getNodeName().equals("q") && !childNode.getNodeName().equals("notq")) continue;
            Boolean affirm = !childNode.getNodeName().equals("notq");
            NodeList grandChildList = childNode.getChildNodes();
            String subj = null;
            String pred = null;
            String obj = null;
            for (int j = 0; j < grandChildList.getLength(); ++j) {
                Node grandChildNode = grandChildList.item(j);
                String contents = AIMLProcessor.evalTagContent(grandChildNode, ps, null);
                if (grandChildNode.getNodeName().equals("subj")) {
                    subj = contents;
                } else if (grandChildNode.getNodeName().equals("pred")) {
                    pred = contents;
                } else if (grandChildNode.getNodeName().equals("obj")) {
                    obj = contents;
                }
                if (!contents.startsWith("?")) continue;
                vars.add(contents);
            }
            clauses.add(new Clause(subj, pred, obj, affirm));
        }
        Set<Tuple> tuples = ps.getChatSession().getTripleStore().select(vars, visibleVars, clauses);
        String result = tuples.stream().map(Tuple::getName).collect(Collectors.joining(" "));
        if (result.length() == 0) {
            result = "NIL";
        }
        return result;
    }

    public static String subject(Node node, ParseState ps) {
        String id = AIMLProcessor.evalTagContent(node, ps, null);
        TripleStore ts = ps.getChatSession().getTripleStore();
        String subject = "unknown";
        if (ts.getIdTriple().containsKey(id)) {
            subject = ts.getIdTriple().get(id).getSubject();
        }
        return subject;
    }

    public static String predicate(Node node, ParseState ps) {
        String id = AIMLProcessor.evalTagContent(node, ps, null);
        TripleStore ts = ps.getChatSession().getTripleStore();
        if (ts.getIdTriple().containsKey(id)) {
            return ts.getIdTriple().get(id).getPredicate();
        }
        return "unknown";
    }

    public static String object(Node node, ParseState ps) {
        String id = AIMLProcessor.evalTagContent(node, ps, null);
        TripleStore ts = ps.getChatSession().getTripleStore();
        if (ts.getIdTriple().containsKey(id)) {
            return ts.getIdTriple().get(id).getObject();
        }
        return "unknown";
    }

    public static String javascript(Node node, ParseState ps) {
        String result = MagicStrings.bad_javascript;
        String script = AIMLProcessor.evalTagContent(node, ps, null);
        try {
            result = IOUtils.evalScript("JavaScript", script);
        }
        catch (Exception e) {
            log.error("JavaScript error:", (Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.trace("in AIMLProcessor.javascript, returning result: {}", (Object)result);
        }
        return result;
    }

    private static String firstWord(String sentence) {
        String content = sentence == null ? "" : sentence;
        if ((content = content.trim()).contains(" ")) {
            return content.substring(0, content.indexOf(" "));
        }
        if (content.length() > 0) {
            return content;
        }
        return MagicStrings.default_list_item;
    }

    private static String restWords(String sentence) {
        String content = sentence == null ? "" : sentence;
        if ((content = content.trim()).contains(" ")) {
            return content.substring(content.indexOf(" ") + 1, content.length());
        }
        return MagicStrings.default_list_item;
    }

    public static String first(Node node, ParseState ps) {
        String content = AIMLProcessor.evalTagContent(node, ps, null);
        return AIMLProcessor.firstWord(content);
    }

    public static String rest(Node node, ParseState ps) {
        String content = AIMLProcessor.evalTagContent(node, ps, null);
        content = ps.getChatSession().getBot().getPreProcessor().normalize(content);
        return AIMLProcessor.restWords(content);
    }

    private static String resetlearnf(ParseState ps) {
        ps.getChatSession().getBot().deleteLearnfCategories();
        return "Deleted Learnf Categories";
    }

    private static String resetlearn(ParseState ps) {
        ps.getChatSession().getBot().deleteLearnCategories();
        return "Deleted Learn Categories";
    }

    private static String recursEval(Node node, ParseState ps) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.recursEval(node: {}, ps: {})", (Object)node, (Object)ps);
        }
        try {
            String nodeName;
            switch (nodeName = node.getNodeName()) {
                case "#text": {
                    return node.getNodeValue();
                }
                case "#comment": {
                    return "";
                }
                case "template": {
                    return AIMLProcessor.evalTagContent(node, ps, null);
                }
                case "random": {
                    return AIMLProcessor.random(node, ps);
                }
                case "condition": {
                    return AIMLProcessor.loopCondition(node, ps);
                }
                case "srai": {
                    return AIMLProcessor.srai(node, ps);
                }
                case "sr": {
                    return AIMLProcessor.respond(ps.getStarBindings().getInputStars().star(0), ps.getThat(), ps.getTopic(), ps.getChatSession(), sraiCount);
                }
                case "sraix": {
                    return AIMLProcessor.sraix(node, ps);
                }
                case "set": {
                    return AIMLProcessor.set(node, ps);
                }
                case "get": {
                    return AIMLProcessor.get(node, ps);
                }
                case "map": {
                    return AIMLProcessor.map(node, ps);
                }
                case "bot": {
                    return AIMLProcessor.bot(node, ps);
                }
                case "id": {
                    return AIMLProcessor.id(ps);
                }
                case "size": {
                    return AIMLProcessor.size(ps);
                }
                case "vocabulary": {
                    return AIMLProcessor.vocabulary(ps);
                }
                case "program": {
                    return AIMLProcessor.program();
                }
                case "date": {
                    return AIMLProcessor.date(node, ps);
                }
                case "interval": {
                    return AIMLProcessor.interval(node, ps);
                }
                case "think": {
                    return AIMLProcessor.think(node, ps);
                }
                case "system": {
                    return AIMLProcessor.system(node, ps);
                }
                case "explode": {
                    return AIMLProcessor.explode(node, ps);
                }
                case "normalize": {
                    return AIMLProcessor.normalize(node, ps);
                }
                case "denormalize": {
                    return AIMLProcessor.denormalize(node, ps);
                }
                case "uppercase": {
                    return AIMLProcessor.uppercase(node, ps);
                }
                case "lowercase": {
                    return AIMLProcessor.lowercase(node, ps);
                }
                case "formal": {
                    return AIMLProcessor.formal(node, ps);
                }
                case "sentence": {
                    return AIMLProcessor.sentence(node, ps);
                }
                case "person": {
                    return AIMLProcessor.person(node, ps);
                }
                case "person2": {
                    return AIMLProcessor.person2(node, ps);
                }
                case "gender": {
                    return AIMLProcessor.gender(node, ps);
                }
                case "star": {
                    return AIMLProcessor.inputStar(node, ps);
                }
                case "thatstar": {
                    return AIMLProcessor.thatStar(node, ps);
                }
                case "topicstar": {
                    return AIMLProcessor.topicStar(node, ps);
                }
                case "that": {
                    return AIMLProcessor.that(node, ps);
                }
                case "input": {
                    return AIMLProcessor.input(node, ps);
                }
                case "request": {
                    return AIMLProcessor.request(node, ps);
                }
                case "response": {
                    return AIMLProcessor.response(node, ps);
                }
                case "learn": 
                case "learnf": {
                    return AIMLProcessor.learn(node, ps);
                }
                case "addtriple": {
                    return AIMLProcessor.addTriple(node, ps);
                }
                case "deletetriple": {
                    return AIMLProcessor.deleteTriple(node, ps);
                }
                case "javascript": {
                    return AIMLProcessor.javascript(node, ps);
                }
                case "select": {
                    return AIMLProcessor.select(node, ps);
                }
                case "uniq": {
                    return AIMLProcessor.uniq(node, ps);
                }
                case "first": {
                    return AIMLProcessor.first(node, ps);
                }
                case "rest": {
                    return AIMLProcessor.rest(node, ps);
                }
                case "resetlearnf": {
                    return AIMLProcessor.resetlearnf(ps);
                }
                case "resetlearn": {
                    return AIMLProcessor.resetlearn(ps);
                }
            }
            if (extension != null && extension.extensionTagSet().contains(nodeName)) {
                return extension.recursEval(node, ps);
            }
            return AIMLProcessor.genericXML(node, ps);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return "";
        }
    }

    private static String evalTemplate(String template, ParseState ps) {
        try {
            template = "<template>" + template + "</template>";
            Node root = DomUtils.parseString(template);
            return AIMLProcessor.recursEval(root, ps);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return MagicStrings.template_failed;
        }
    }

    public static boolean validTemplate(String template) {
        if (log.isTraceEnabled()) {
            log.trace("AIMLProcessor.validTemplate(template: {})", (Object)template);
        }
        try {
            template = "<template>" + template + "</template>";
            DomUtils.parseString(template);
            return true;
        }
        catch (Exception e) {
            log.error("Invalid Template {}", (Object)template, (Object)e);
            return false;
        }
    }

    static {
        sraiCount = 0;
    }
}

