/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.alicebot.ab.AB;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Inflector;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Sraix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIMLMap
extends HashMap<String, String> {
    private static final Logger log = LoggerFactory.getLogger(AB.class);
    private String mapName;
    private String host;
    private String botId;
    private boolean isExternal = false;
    private Bot bot;

    public AIMLMap(String name, Bot bot) {
        this.bot = bot;
        this.mapName = name;
    }

    public String get(String key) {
        String value;
        if (this.mapName.equals(MagicStrings.map_successor)) {
            try {
                int number = Integer.parseInt(key);
                return String.valueOf(number + 1);
            }
            catch (Exception e) {
                return MagicStrings.default_map;
            }
        }
        if (this.mapName.equals(MagicStrings.map_predecessor)) {
            try {
                int number = Integer.parseInt(key);
                return String.valueOf(number - 1);
            }
            catch (Exception e) {
                return MagicStrings.default_map;
            }
        }
        if (this.mapName.equals("singular")) {
            return Inflector.getInstance().singularize(key).toLowerCase();
        }
        if (this.mapName.equals("plural")) {
            return Inflector.getInstance().pluralize(key).toLowerCase();
        }
        if (this.isExternal && MagicBooleans.enable_external_sets) {
            String query = this.mapName.toUpperCase() + " " + key;
            String response = Sraix.sraix(null, query, MagicStrings.default_map, null, this.host, this.botId, null, "0");
            log.info("External {}({})={}" + response, new Object[]{this.mapName, key, response});
            value = response;
        } else {
            value = (String)super.get(key);
        }
        if (value == null) {
            value = MagicStrings.default_map;
        }
        if (log.isDebugEnabled()) {
            log.debug("AIMLMap get {}={}", (Object)key, (Object)value);
        }
        return value;
    }

    @Override
    public String put(String key, String value) {
        if (log.isDebugEnabled()) {
            log.debug("AIMLMap put {}={}", (Object)key, (Object)value);
        }
        return super.put(key, value);
    }

    public void writeAIMLMap() {
        log.info("Writing AIML Map {}", (Object)this.mapName);
        try (FileWriter stream = new FileWriter(this.bot.getMapsPath() + "/" + this.mapName + ".txt");
             BufferedWriter out = new BufferedWriter(stream);){
            for (String p : this.keySet()) {
                p = p.trim();
                if (log.isDebugEnabled()) {
                    log.debug("{}-->{}", (Object)p, (Object)this.get(p));
                }
                out.write(p + ":" + this.get(p).trim());
                out.newLine();
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
    }

    private int readAIMLMapFromInputStream(InputStream in, Bot bot) {
        int count = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String strLine;
            while ((strLine = reader.readLine()) != null && strLine.length() > 0) {
                String[] splitLine = strLine.split(":");
                if (log.isDebugEnabled()) {
                    log.debug("AIMLMap line={}", (Object)strLine);
                }
                if (splitLine.length < 2) continue;
                ++count;
                if (strLine.startsWith(MagicStrings.remote_map_key)) {
                    if (splitLine.length < 3) continue;
                    this.host = splitLine[1];
                    this.botId = splitLine[2];
                    this.isExternal = true;
                    log.info("Created external map at [host={}, botId={}]", (Object)this.host, (Object)this.botId);
                    continue;
                }
                String key = splitLine[0].toUpperCase();
                String value = splitLine[1];
                this.put(key, value);
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return count;
    }

    public int readAIMLMap(Bot bot) {
        int count;
        block16: {
            count = 0;
            String fileName = bot.getMapsPath() + "/" + this.mapName + ".txt";
            if (log.isTraceEnabled()) {
                log.trace("Reading AIML Map {}", (Object)fileName);
            }
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    try (FileInputStream stream = new FileInputStream(file);){
                        count = this.readAIMLMapFromInputStream(stream, bot);
                        break block16;
                    }
                }
                log.warn("{} not found", (Object)fileName);
            }
            catch (Exception e) {
                log.error("Error: ", (Throwable)e);
            }
        }
        return count;
    }
}

