/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot.ab;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import org.alicebot.ab.AIMLSet;
import org.alicebot.ab.Bot;
import org.alicebot.ab.Category;
import org.alicebot.ab.Graphmaster;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicNumbers;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.Nodemapper;
import org.alicebot.ab.NodemapperOperator;
import org.alicebot.ab.Timer;
import org.alicebot.ab.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AB {
    private static final Logger log = LoggerFactory.getLogger(AB.class);
    private boolean shuffleMode = true;
    private boolean sortMode = !this.shuffleMode;
    private boolean filterAtomicMode = false;
    private boolean filterWildMode = false;
    private boolean offerAliceResponses = true;
    private String logfile = MagicStrings.root_path + "/data/" + MagicStrings.ab_sample_file;
    private int runCompletedCnt;
    public Bot bot;
    public Bot alice;
    private AIMLSet passed;
    private AIMLSet testSet;
    private final Graphmaster inputGraph;
    private final Graphmaster patternGraph;
    private final Graphmaster deletedGraph;
    private ArrayList<Category> suggestedCategories;
    public static int limit = 500000;
    private static int leafPatternCnt = 0;
    private static int starPatternCnt = 0;

    public AB(Bot bot, String sampleFile) {
        MagicStrings.ab_sample_file = sampleFile;
        this.logfile = MagicStrings.root_path + "/data/" + MagicStrings.ab_sample_file;
        log.info("AB with sample file {}", (Object)this.logfile);
        this.bot = bot;
        this.inputGraph = new Graphmaster(bot, "input");
        this.deletedGraph = new Graphmaster(bot, "deleted");
        this.patternGraph = new Graphmaster(bot, "pattern");
        for (Category c : bot.getBrain().getCategories()) {
            this.patternGraph.addCategory(c);
        }
        this.suggestedCategories = new ArrayList();
        this.passed = new AIMLSet("passed", bot);
        this.testSet = new AIMLSet("1000", bot);
        this.readDeletedIFCategories();
    }

    private void productivity(int runCompletedCnt, Timer timer) {
        float time = timer.elapsedTimeMins();
        log.info("Completed {} in {} min. Productivity {} cat/min", new Object[]{runCompletedCnt, Float.valueOf(time), Float.valueOf((float)runCompletedCnt / time)});
    }

    private void readDeletedIFCategories() {
        this.bot.readCertainIFCategories(this.deletedGraph, MagicStrings.deleted_aiml_file);
        if (log.isTraceEnabled()) {
            log.trace("--- DELETED CATEGORIES -- read {} deleted categories", (Object)this.deletedGraph.getCategories().size());
        }
    }

    private void writeDeletedIFCategories() {
        log.info("--- DELETED CATEGORIES -- write");
        this.bot.writeCertainIFCategories(this.deletedGraph, MagicStrings.deleted_aiml_file);
        log.info("--- DELETED CATEGORIES -- write {} deleted categories", (Object)this.deletedGraph.getCategories().size());
    }

    private void saveCategory(String pattern, String template, String filename) {
        String that = "*";
        String topic = "*";
        Category c = new Category(0, pattern, that, topic, template, filename);
        if (c.validate()) {
            this.bot.getBrain().addCategory(c);
            this.bot.writeAIMLIFFiles();
            ++this.runCompletedCnt;
        } else {
            log.warn("Invalid Category {}", (Object)c.getValidationMessage());
        }
    }

    private void deleteCategory(Category c) {
        c.setFilename(MagicStrings.deleted_aiml_file);
        c.setTemplate(MagicStrings.deleted_template);
        this.deletedGraph.addCategory(c);
        this.writeDeletedIFCategories();
    }

    private void skipCategory(Category c) {
    }

    public void abwq() {
        Timer timer = new Timer();
        timer.start();
        this.classifyInputs(this.logfile);
        log.info("{} classifying inputs", (Object)Float.valueOf(timer.elapsedTimeSecs()));
        this.bot.writeQuit();
    }

    private void graphInputs(String filename) {
        try (FileInputStream stream = new FileInputStream(filename);
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String strLine;
            for (int count = 0; (strLine = reader.readLine()) != null && count < limit; ++count) {
                Category c = new Category(0, strLine, "*", "*", "nothing", MagicStrings.unknown_aiml_file);
                Nodemapper node = this.inputGraph.findNode(c);
                if (node == null) {
                    this.inputGraph.addCategory(c);
                    c.incrementActivationCnt();
                    continue;
                }
                node.getCategory().incrementActivationCnt();
            }
        }
        catch (Exception e) {
            log.error("Error", (Throwable)e);
        }
    }

    private void findPatterns() {
        this.findPatterns(this.inputGraph.getRoot(), "");
        log.info("{} Leaf Patterns, {} Star Patterns", (Object)leafPatternCnt, (Object)starPatternCnt);
    }

    private void findPatterns(Nodemapper node, String partialPatternThatTopic) {
        if (NodemapperOperator.isLeaf(node)) {
            if (log.isTraceEnabled()) {
                log.trace("LEAF: {}. {}", (Object)node.getCategory().getActivationCnt(), (Object)partialPatternThatTopic);
            }
            if (node.getCategory().getActivationCnt() > MagicNumbers.node_activation_cnt) {
                if (log.isTraceEnabled()) {
                    log.trace("LEAF: {}. {} {}", new Object[]{node.getCategory().getActivationCnt(), partialPatternThatTopic, node.isShortCut()});
                }
                ++leafPatternCnt;
                try {
                    String categoryPatternThatTopic = node.isShortCut() ? partialPatternThatTopic + " <THAT> * <TOPIC> *" : partialPatternThatTopic;
                    Category c = new Category(0, categoryPatternThatTopic, MagicStrings.blank_template, MagicStrings.unknown_aiml_file);
                    if (!this.bot.getBrain().existsCategory(c) && !this.deletedGraph.existsCategory(c)) {
                        this.patternGraph.addCategory(c);
                        this.suggestedCategories.add(c);
                    }
                }
                catch (Exception e) {
                    log.error("Error", (Throwable)e);
                }
            }
        }
        if (NodemapperOperator.size(node) > MagicNumbers.node_size) {
            if (log.isTraceEnabled()) {
                log.trace("STAR: {}. {} * <that> * <topic> *", (Object)NodemapperOperator.size(node), (Object)partialPatternThatTopic);
            }
            ++starPatternCnt;
            try {
                Category c = new Category(0, partialPatternThatTopic + " * <THAT> * <TOPIC> *", MagicStrings.blank_template, MagicStrings.unknown_aiml_file);
                if (!this.bot.getBrain().existsCategory(c) && !this.deletedGraph.existsCategory(c)) {
                    this.patternGraph.addCategory(c);
                    this.suggestedCategories.add(c);
                }
            }
            catch (Exception e) {
                log.error("Error", (Throwable)e);
            }
        }
        for (String key : NodemapperOperator.keySet(node)) {
            Nodemapper value = NodemapperOperator.get(node, key);
            this.findPatterns(value, partialPatternThatTopic + " " + key);
        }
    }

    private void classifyInputs(String filename) {
        try (FileInputStream fstream = new FileInputStream(filename);
             BufferedReader br = new BufferedReader(new InputStreamReader(fstream));){
            String strLine;
            int count = 0;
            while ((strLine = br.readLine()) != null && count < limit) {
                String[] sentences;
                if (log.isTraceEnabled()) {
                    log.trace("Classifying ", (Object)strLine);
                }
                if (strLine.startsWith("Human: ")) {
                    strLine = strLine.substring("Human: ".length(), strLine.length());
                }
                for (String sentence : sentences = this.bot.getPreProcessor().sentenceSplit(strLine)) {
                    if (sentence.length() <= 0) continue;
                    Nodemapper match = this.patternGraph.match(sentence, "unknown", "unknown");
                    if (match == null) {
                        log.info("{} null match", (Object)sentence);
                    } else {
                        match.getCategory().incrementActivationCnt();
                        if (log.isDebugEnabled()) {
                            log.debug("{}. {} matched {}", new Object[]{count, sentence, match.getCategory().inputThatTopic()});
                        }
                    }
                    if (++count % 10000 != 0) continue;
                    log.info("{}", (Object)count);
                }
            }
            log.info("Finished classifying {} inputs", (Object)count);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
    }

    public void ab() {
        String logFile = this.logfile;
        MagicBooleans.enable_external_sets = false;
        if (this.offerAliceResponses) {
            this.alice = new Bot("alice");
        }
        Timer timer = new Timer();
        this.bot.getBrain().nodeStats();
        if (this.bot.getBrain().getCategories().size() < MagicNumbers.brain_print_size) {
            this.bot.getBrain().printGraph();
        }
        timer.start();
        log.info("Graphing inputs");
        this.graphInputs(logFile);
        log.info("{} seconds Graphing inputs", (Object)Float.valueOf(timer.elapsedTimeSecs()));
        this.inputGraph.nodeStats();
        if (this.inputGraph.getCategories().size() < MagicNumbers.brain_print_size) {
            this.inputGraph.printGraph();
        }
        timer.start();
        log.info("Finding Patterns");
        this.findPatterns();
        log.info("{} suggested categories, {} seconds finding patterns", (Object)this.suggestedCategories.size(), (Object)Float.valueOf(timer.elapsedTimeSecs()));
        timer.start();
        this.patternGraph.nodeStats();
        if (this.patternGraph.getCategories().size() < MagicNumbers.brain_print_size) {
            this.patternGraph.printGraph();
        }
        log.info("Classifying Inputs from {}", (Object)logFile);
        this.classifyInputs(logFile);
        log.info("{} classifying inputs", (Object)Float.valueOf(timer.elapsedTimeSecs()));
    }

    private ArrayList<Category> nonZeroActivationCount(ArrayList<Category> suggestedCategories) {
        ArrayList<Category> result = new ArrayList<Category>();
        for (Category c : suggestedCategories) {
            if (c.getActivationCnt() > 0) {
                result.add(c);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.info("[{}] {}", (Object)c.getActivationCnt(), (Object)c.inputThatTopic());
        }
        return result;
    }

    public void terminalInteraction() {
        boolean bl = this.sortMode = !this.shuffleMode;
        if (this.sortMode) {
            this.suggestedCategories.sort(Category.ACTIVATION_COMPARATOR);
        }
        ArrayList<Category> topSuggestCategories = new ArrayList<Category>();
        for (int i = 0; i < 10000 && i < this.suggestedCategories.size(); ++i) {
            topSuggestCategories.add(this.suggestedCategories.get(i));
        }
        this.suggestedCategories = topSuggestCategories;
        if (this.shuffleMode) {
            Collections.shuffle(this.suggestedCategories);
        }
        Timer timer = new Timer();
        timer.start();
        this.runCompletedCnt = 0;
        ArrayList<Category> filteredAtomicCategories = new ArrayList<Category>();
        ArrayList<Category> filteredWildCategories = new ArrayList<Category>();
        for (Category c : this.suggestedCategories) {
            if (!c.getPattern().contains("*")) {
                filteredAtomicCategories.add(c);
                continue;
            }
            filteredWildCategories.add(c);
        }
        ArrayList<Category> browserCategories = this.filterAtomicMode ? filteredAtomicCategories : (this.filterWildMode ? filteredWildCategories : this.suggestedCategories);
        if (log.isDebugEnabled()) {
            log.debug("{} filtered suggested categories", (Object)filteredAtomicCategories.size());
        }
        browserCategories = this.nonZeroActivationCount(browserCategories);
        boolean firstInteraction = true;
        String aliceTemplate = null;
        for (Category c : browserCategories) {
            try {
                ArrayList<String> samples = new ArrayList<String>(c.getMatches(this.bot));
                Collections.shuffle(samples);
                int sampleSize = Math.min(MagicNumbers.displayed_input_sample_size, c.getMatches(this.bot).size());
                for (int i = 0; i < sampleSize; ++i) {
                    log.info("{}", samples.get(i));
                }
                log.info("[{}] {}", (Object)c.getActivationCnt(), (Object)c.inputThatTopic());
                if (this.offerAliceResponses) {
                    Nodemapper node = this.alice.getBrain().findNode(c);
                    if (node != null) {
                        String displayAliceTemplate = aliceTemplate = node.getCategory().getTemplate();
                        if ((displayAliceTemplate = displayAliceTemplate.replace("\n", " ")).length() > 200) {
                            displayAliceTemplate = displayAliceTemplate.substring(0, 200);
                        }
                        log.info("ALICE: {}", (Object)displayAliceTemplate);
                    } else {
                        aliceTemplate = null;
                    }
                }
                if (firstInteraction) {
                    timer.start();
                    firstInteraction = false;
                }
                this.productivity(this.runCompletedCnt, timer);
                this.terminalInteractionStep(this.bot, "", IOUtils.readInputTextLine(), c, aliceTemplate);
            }
            catch (Exception e) {
                log.info("Returning to Category Browser", (Throwable)e);
            }
        }
        log.info("No more samples");
        this.bot.writeAIMLFiles();
        this.bot.writeAIMLIFFiles();
    }

    private void terminalInteractionStep(Bot bot, String request, String textLine, Category c, String alicetemplate) {
        String[] pronouns;
        if (textLine.contains("<pattern>") && textLine.contains("</pattern>")) {
            int index = textLine.indexOf("<pattern>") + "<pattern>".length();
            int jndex = textLine.indexOf("</pattern>");
            int kndex = jndex + "</pattern>".length();
            if (index < jndex) {
                String pattern = textLine.substring(index, jndex);
                c.setPattern(pattern);
                textLine = textLine.substring(kndex, textLine.length());
                log.info("Got pattern = {} template = {}", (Object)pattern, (Object)textLine);
            }
        }
        String botThinks = "";
        for (String p : pronouns = new String[]{"he", "she", "it", "we", "they"}) {
            if (!textLine.contains("<" + p + ">")) continue;
            textLine = textLine.replace("<" + p + ">", "");
            botThinks = "<think><set name=\"" + p + "\"><set name=\"topic\"><star/></set></set></think>";
        }
        if (textLine.equals("q")) {
            System.exit(0);
        } else if (textLine.equals("wq")) {
            bot.writeQuit();
            System.exit(0);
        } else if (textLine.equals("skip") || textLine.equals("")) {
            this.skipCategory(c);
        } else if (textLine.equals("s") || textLine.equals("pass")) {
            this.passed.add(request);
            AIMLSet difference = new AIMLSet("difference", bot);
            difference.addAll(this.testSet);
            difference.removeAll(this.passed);
            difference.writeAIMLSet();
            this.passed.writeAIMLSet();
        } else if (textLine.equals("a")) {
            String template = alicetemplate;
            String filename = template.contains("<sr") ? MagicStrings.reductions_update_aiml_file : MagicStrings.personality_aiml_file;
            this.saveCategory(c.getPattern(), template, filename);
        } else if (textLine.equals("d")) {
            this.deleteCategory(c);
        } else if (textLine.equals("x")) {
            String template = "<sraix services=\"pannous\">" + c.getPattern().replace("*", "<star/>") + "</sraix>";
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.sraix_aiml_file);
        } else if (textLine.equals("p")) {
            String template = "<srai>" + MagicStrings.inappropriate_filter + "</srai>";
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.inappropriate_aiml_file);
        } else if (textLine.equals("f")) {
            String template = "<srai>" + MagicStrings.profanity_filter + "</srai>";
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.profanity_aiml_file);
        } else if (textLine.equals("i")) {
            String template = "<srai>" + MagicStrings.insult_filter + "</srai>";
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.insult_aiml_file);
        } else if (textLine.contains("<srai>") || textLine.contains("<sr/>")) {
            String template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.reductions_update_aiml_file);
        } else if (textLine.contains("<oob>")) {
            String template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.oob_aiml_file);
        } else if (textLine.contains("<set name") || botThinks.length() > 0) {
            String template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.predicates_aiml_file);
        } else if (textLine.contains("<get name") && !textLine.contains("<get name=\"name")) {
            String template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.predicates_aiml_file);
        } else {
            String template = textLine;
            template = template + botThinks;
            this.saveCategory(c.getPattern(), template, MagicStrings.personality_aiml_file);
        }
    }
}

