/*
 * Decompiled with CFR 0.152.
 */
package org.alicebot;

import org.alicebot.ab.AB;
import org.alicebot.ab.AIMLProcessor;
import org.alicebot.ab.Bot;
import org.alicebot.ab.MagicBooleans;
import org.alicebot.ab.MagicNumbers;
import org.alicebot.ab.MagicStrings;
import org.alicebot.ab.PCAIMLProcessorExtension;
import org.alicebot.ab.TestAB;
import org.alicebot.ab.Verbs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    private static final Logger log = LoggerFactory.getLogger(App.class);

    public static void main(String[] args) {
        MagicStrings.setRootPath();
        AIMLProcessor.extension = new PCAIMLProcessorExtension();
        String botName = "alice2";
        MagicBooleans.jp_tokenize = false;
        String action = "chat";
        log.info(MagicStrings.program_name_version);
        for (String s : args) {
            String[] splitArg = s.split("=");
            if (splitArg.length < 2) continue;
            String option = splitArg[0];
            String value = splitArg[1];
            if (option.equals("bot")) {
                botName = value;
            }
            if (option.equals("action")) {
                action = value;
            }
            if (!option.equals("morph")) continue;
            MagicBooleans.jp_tokenize = value.equals("true");
        }
        log.debug("Working Directory = " + MagicStrings.root_path);
        MagicBooleans.graph_enableShortCuts = true;
        Bot bot = new Bot(botName, MagicStrings.root_path, action);
        if (MagicBooleans.make_verbs_sets_maps) {
            Verbs.makeVerbSetsMaps(bot);
        }
        if (bot.getBrain().getCategories().size() < MagicNumbers.brain_print_size) {
            bot.getBrain().printGraph();
        }
        log.debug("Action = '{}'", (Object)action);
        switch (action) {
            case "chat": 
            case "chat-app": {
                boolean doWrites = !action.equals("chat-app");
                TestAB.testChat(bot, doWrites);
                break;
            }
            case "ab": {
                TestAB.testAB(bot, TestAB.sample_file);
                break;
            }
            case "aiml2csv": {
                bot.writeAIMLIFFiles();
                break;
            }
            case "csv2aiml": {
                bot.writeAIMLFiles();
                break;
            }
            case "abwq": {
                AB ab = new AB(bot, TestAB.sample_file);
                ab.abwq();
                break;
            }
            case "test": {
                TestAB.runTests(bot);
                break;
            }
            case "shadow": {
                bot.shadowChecker();
                break;
            }
            default: {
                log.error("Unrecognized action {}", (Object)action);
            }
        }
    }
}

