/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TldScanner
implements ServletContainerInitializer {
    private static Logger log = Logger.getLogger(TldScanner.class.getName());
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static HashSet<String> systemUris = new HashSet();
    private static HashSet<String> systemUrisJsf = new HashSet();
    private static ConcurrentHashMap<String, TldInfo[]> jarTldCache = new ConcurrentHashMap();
    private static final String EAR_LIB_CLASSLOADER = "org.glassfish.javaee.full.deployment.EarLibClassLoader";
    private static final String IS_STANDALONE_ATTRIBUTE_NAME = "org.glassfish.jsp.isStandaloneWebapp";
    private HashMap<String, String[]> mappings;
    private ServletContext ctxt;
    private boolean isValidationEnabled;
    private boolean useMyFaces = false;
    private boolean scanListeners;

    public TldScanner() {
    }

    public TldScanner(ServletContext ctxt, boolean isValidationEnabled) {
        this.ctxt = ctxt;
        this.isValidationEnabled = isValidationEnabled;
        Boolean b = (Boolean)ctxt.getAttribute("com.sun.faces.useMyFaces");
        if (b != null) {
            this.useMyFaces = b;
        }
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctxt) throws ServletException {
        ServletRegistration reg;
        this.ctxt = ctxt;
        Boolean b = (Boolean)ctxt.getAttribute("com.sun.faces.useMyFaces");
        if (b != null) {
            this.useMyFaces = b;
        }
        if ((reg = ctxt.getServletRegistration("jsp")) == null) {
            return;
        }
        String validating = reg.getInitParameter("validating");
        this.isValidationEnabled = "true".equals(validating);
        this.scanListeners = true;
        this.scanTlds();
        ctxt.setAttribute("com.sun.jsp.tldUriToLocationMap", this.mappings);
    }

    public String[] getLocation(String uri) throws JasperException {
        if (this.mappings == null) {
            this.mappings = (HashMap)this.ctxt.getAttribute("com.sun.jsp.tldUriToLocationMap");
            if (this.mappings == null) {
                this.scanListeners = false;
                this.scanTlds();
            }
        }
        return this.mappings.get(uri);
    }

    Map<URI, List<String>> getTldMap() {
        return (Map)this.ctxt.getAttribute("com.sun.appserv.tld.map");
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void scanTlds() throws JasperException {
        this.mappings = new HashMap();
        try {
            this.processWebDotXml();
            this.scanJars();
            this.processTldsInFileSystem("/WEB-INF/");
        }
        catch (JasperException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit"), ex);
        }
    }

    private void processWebDotXml() throws Exception {
        JspConfigDescriptor jspConfig = this.ctxt.getJspConfigDescriptor();
        if (jspConfig == null) {
            return;
        }
        for (TaglibDescriptor taglib : jspConfig.getTaglibs()) {
            if (taglib == null) continue;
            String tagUri = taglib.getTaglibURI();
            String tagLoc = taglib.getTaglibLocation();
            if (tagUri == null || tagLoc == null || systemUris.contains(tagUri) || !this.useMyFaces && systemUrisJsf.contains(tagUri)) continue;
            if (TldScanner.uriType(tagLoc) == 2) {
                tagLoc = "/WEB-INF/" + tagLoc;
            }
            String tagLoc2 = null;
            if (tagLoc.endsWith(JAR_FILE_SUFFIX)) {
                tagLoc = this.ctxt.getResource(tagLoc).toString();
                tagLoc2 = "META-INF/taglib.tld";
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Add tld map from web.xml: " + tagUri + "=>" + tagLoc + "," + tagLoc2);
            }
            this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanJar(JarURLConnection conn, List<String> tldNames, boolean isLocal) throws JasperException {
        block21: {
            resourcePath = conn.getJarFileURL().toString();
            cachedTldInfos = TldScanner.jarTldCache.get(resourcePath);
            if (cachedTldInfos != null && cachedTldInfos.length == 0) {
                return;
            }
            tldInfoA = new ArrayList<TldInfo>();
            if (isLocal || cachedTldInfos == null) {
                jarFile = null;
                try {
                    try {
                        conn.setUseCaches(false);
                        jarFile = conn.getJarFile();
                        if (tldNames != null) {
                            for (String tldName : tldNames) {
                                entry = jarFile.getJarEntry(tldName);
                                stream = jarFile.getInputStream(entry);
                                tldInfoA.add(this.scanTld(resourcePath, tldName, stream));
                            }
                        } else {
                            entries = jarFile.entries();
                            while (entries.hasMoreElements()) {
                                entry = entries.nextElement();
                                name = entry.getName();
                                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                                stream = jarFile.getInputStream(entry);
                                tldInfoA.add(this.scanTld(resourcePath, name, stream));
                            }
                        }
                        var13_15 = null;
                        if (jarFile == null) break block21;
                    }
                    catch (IOException ex) {
                        if (resourcePath.startsWith("file:") == false) throw new JasperException(Localizer.getMessage("jsp.error.jar.io", resourcePath), ex);
                        if (new File(resourcePath).exists() != false) throw new JasperException(Localizer.getMessage("jsp.error.jar.io", resourcePath), ex);
                        if (TldScanner.log.isLoggable(Level.WARNING)) {
                            TldScanner.log.log(Level.WARNING, Localizer.getMessage("jsp.warn.nojar", resourcePath), ex);
                        }
                        var13_15 = null;
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable t) {}
                        }
                        break block21;
                    }
                }
                catch (Throwable var12_19) {
                    var13_16 = null;
                    if (jarFile == null) throw var12_19;
                    ** try [egrp 2[TRYBLOCK] [4 : 334->342)] { 
lbl49:
                    // 1 sources

                    jarFile.close();
                    throw var12_19;
lbl51:
                    // 1 sources

                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw var12_19;
                }
                try {}
                catch (Throwable t) {}
                jarFile.close();
            }
        }
        tldInfos = tldInfoA.toArray(new TldInfo[tldInfoA.size()]);
        if (!isLocal) {
            if (cachedTldInfos == null) {
                TldScanner.jarTldCache.put(resourcePath, tldInfos);
            } else {
                tldInfos = cachedTldInfos;
            }
        }
        arr$ = tldInfos;
        len$ = arr$.length;
        i$ = 0;
        while (i$ < len$) {
            tldInfo = arr$[i$];
            if (this.scanListeners) {
                this.addListener(tldInfo, isLocal);
            }
            this.mapTldLocation(resourcePath, tldInfo, isLocal);
            ++i$;
        }
    }

    private void addListener(TldInfo tldInfo, boolean isLocal) {
        String uri = tldInfo.getUri();
        if (!systemUrisJsf.contains(uri) || isLocal && this.useMyFaces || !isLocal && !this.useMyFaces) {
            for (String listenerClassName : tldInfo.getListeners()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Add tld listener " + listenerClassName);
                }
                this.ctxt.addListener(listenerClassName);
            }
        }
    }

    private void mapTldLocation(String resourcePath, TldInfo tldInfo, boolean isLocal) {
        String uri = tldInfo.getUri();
        if (uri == null) {
            return;
        }
        if (isLocal && this.mappings.get(uri) == null && !systemUris.contains(uri) && (!systemUrisJsf.contains(uri) || this.useMyFaces) || !isLocal && (this.mappings.get(uri) == null || systemUris.contains(uri) || systemUrisJsf.contains(uri) && !this.useMyFaces)) {
            String entryName = tldInfo.getEntryName();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Add tld map from tld in " + (isLocal ? "WEB-INF" : "jar: ") + uri + "=>" + resourcePath + "," + entryName);
            }
            this.mappings.put(uri, new String[]{resourcePath, entryName});
        }
    }

    private void processTldsInFileSystem(String startPath) throws JasperException {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                if (path.startsWith("/WEB-INF/tags/") && !path.endsWith("implicit.tld")) {
                    throw new JasperException(Localizer.getMessage("jsp.error.tldinit.tldInWebInfTags", path));
                }
                InputStream stream = this.ctxt.getResourceAsStream(path);
                TldInfo tldInfo = this.scanTld(path, null, stream);
                if (this.scanListeners) {
                    this.addListener(tldInfo, true);
                }
                this.mapTldLocation(path, tldInfo, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldInfo scanTld(String resourcePath, String entryName, InputStream stream) throws JasperException {
        TldInfo tldInfo;
        block7: {
            try {
                TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, stream, this.isValidationEnabled);
                String uri = null;
                TreeNode uriNode = tld.findChild("uri");
                if (uriNode != null) {
                    uri = uriNode.getBody();
                }
                ArrayList<String> listeners = new ArrayList<String>();
                Iterator<TreeNode> listenerNodes = tld.findChildren("listener");
                while (listenerNodes.hasNext()) {
                    String listenerClassName;
                    TreeNode listener = listenerNodes.next();
                    TreeNode listenerClass = listener.findChild("listener-class");
                    if (listenerClass == null || (listenerClassName = listenerClass.getBody()) == null) continue;
                    listeners.add(listenerClassName);
                }
                tldInfo = new TldInfo(uri, entryName, listeners.toArray(new String[listeners.size()]));
                Object var13_12 = null;
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var13_13 = null;
                    if (stream == null) break block8;
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return tldInfo;
    }

    private void scanJars() throws Exception {
        ClassLoader webappLoader;
        Map<URI, List<String>> tldMap = this.getTldMap();
        Boolean isStandalone = (Boolean)this.ctxt.getAttribute(IS_STANDALONE_ATTRIBUTE_NAME);
        for (ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (loader instanceof URLClassLoader) {
                boolean isLocal = loader == webappLoader;
                URL[] urls = ((URLClassLoader)loader).getURLs();
                ArrayList<String> extraJars = new ArrayList<String>();
                for (int i = 0; i < urls.length; ++i) {
                    URLConnection conn = urls[i].openConnection();
                    JarURLConnection jconn = null;
                    if (conn instanceof JarURLConnection) {
                        jconn = (JarURLConnection)conn;
                    } else {
                        String urlStr = urls[i].toString();
                        if (urlStr.startsWith(FILE_PROTOCOL) && urlStr.endsWith(JAR_FILE_SUFFIX)) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            jconn = (JarURLConnection)jarURL.openConnection();
                        }
                    }
                    if (jconn == null) continue;
                    if (isLocal) {
                        this.addManifestClassPath(null, extraJars, jconn);
                    }
                    this.scanJar(jconn, null, isLocal);
                }
                if (extraJars.size() > 0) {
                    ArrayList<String> newJars;
                    do {
                        newJars = new ArrayList<String>();
                        for (String jar : extraJars) {
                            URL jarURL = new URL("jar:" + jar + "!/");
                            JarURLConnection jconn = (JarURLConnection)jarURL.openConnection();
                            if (!this.addManifestClassPath(extraJars, newJars, jconn)) continue;
                            this.scanJar(jconn, null, true);
                        }
                        extraJars.addAll(newJars);
                    } while (newJars.size() != 0);
                }
            }
            if (tldMap != null && isStandalone != null && (isStandalone.booleanValue() || EAR_LIB_CLASSLOADER.equals(loader.getClass().getName()))) break;
        }
        if (tldMap != null) {
            for (URI uri : tldMap.keySet()) {
                URL jarURL = new URL("jar:" + uri.toString() + "!/");
                this.scanJar((JarURLConnection)jarURL.openConnection(), tldMap.get(uri), false);
            }
        }
    }

    private boolean addManifestClassPath(List<String> scannedJars, List<String> newJars, JarURLConnection jconn) {
        Manifest manifest;
        try {
            manifest = jconn.getManifest();
        }
        catch (IOException ex) {
            return false;
        }
        String file = jconn.getJarFileURL().toString();
        if (!file.contains("WEB-INF")) {
            return true;
        }
        if (manifest == null) {
            return true;
        }
        Attributes attrs = manifest.getMainAttributes();
        String cp = attrs.getValue("Class-Path");
        if (cp == null) {
            return true;
        }
        String[] paths = cp.split(" ");
        int lastIndex = file.lastIndexOf(File.separatorChar);
        String baseDir = "";
        if (lastIndex > 0) {
            baseDir = file.substring(0, lastIndex + 1);
        }
        for (String path : paths) {
            String p = path.startsWith(File.separator) ? path : baseDir + path;
            if (scannedJars != null && scannedJars.contains(p)) continue;
            newJars.add(p);
        }
        return true;
    }

    static {
        systemUrisJsf.add("http://java.sun.com/jsf/core");
        systemUrisJsf.add("http://java.sun.com/jsf/html");
        systemUris.add("http://java.sun.com/jsp/jstl/core");
    }

    static class TldInfo {
        private String entryName;
        private String uri;
        private String[] listeners;

        public TldInfo(String uri, String entryName, String[] listeners) {
            this.uri = uri;
            this.entryName = entryName;
            this.listeners = listeners;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public String getUri() {
            return this.uri;
        }

        public String[] getListeners() {
            return this.listeners;
        }
    }
}

