/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr199JavaCompiler
implements JavaCompiler {
    private List<File> cpath;
    private JspRuntimeContext rtctxt;
    private ArrayList<BytecodeFile> classFiles;
    private ArrayList<String> options = new ArrayList();
    private CharArrayWriter charArrayWriter;
    private JspCompilationContext ctxt;
    private String javaFileName;
    private String javaEncoding;
    private ErrorDispatcher errDispatcher;

    @Override
    public void init(JspCompilationContext ctxt, ErrorDispatcher errDispatcher, boolean suppressLogging) {
        this.ctxt = ctxt;
        this.errDispatcher = errDispatcher;
        this.rtctxt = ctxt.getRuntimeContext();
        this.options.add("-proc:none");
    }

    @Override
    public void setClassPath(List<File> path) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File f : path) {
            paths.add(f.toString());
        }
        List<String> files = JspUtil.expandClassPath(paths);
        this.cpath = new ArrayList<File>();
        for (String file : files) {
            this.cpath.add(new File(file));
        }
    }

    @Override
    public void setExtdirs(String exts) {
        this.options.add("-extdirs");
        this.options.add(exts);
    }

    @Override
    public void setSourceVM(String sourceVM) {
        this.options.add("-source");
        this.options.add(sourceVM);
    }

    @Override
    public void setTargetVM(String targetVM) {
        this.options.add("-target");
        this.options.add(targetVM);
    }

    @Override
    public void saveClassFile(String className, String classFileName) {
        for (BytecodeFile bytecodeFile : this.classFiles) {
            String c = bytecodeFile.getClassName();
            String f = classFileName;
            if (!className.equals(c)) {
                f = f.substring(0, f.lastIndexOf(File.separator) + 1) + c.substring(c.lastIndexOf(46) + 1) + ".class";
            }
            this.rtctxt.saveBytecode(c, f);
        }
    }

    @Override
    public void doJavaFile(boolean keep) throws JasperException {
        if (!keep) {
            this.charArrayWriter = null;
            return;
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.javaFileName), this.javaEncoding);
            writer.write(this.charArrayWriter.toString());
            ((Writer)writer).close();
            this.charArrayWriter = null;
        }
        catch (UnsupportedEncodingException ex) {
            this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", this.javaEncoding);
        }
        catch (IOException ex) {
            throw new JasperException(ex);
        }
    }

    @Override
    public void setDebug(boolean debug) {
        if (debug) {
            this.options.add("-g");
        } else {
            this.options.add("-g:none");
        }
    }

    @Override
    public Writer getJavaWriter(String javaFileName, String javaEncoding) {
        this.javaFileName = javaFileName;
        this.javaEncoding = javaEncoding;
        this.charArrayWriter = new CharArrayWriter();
        return this.charArrayWriter;
    }

    @Override
    public long getClassLastModified() {
        String className = this.ctxt.getFullClassName();
        return this.rtctxt.getBytecodeBirthTime(className);
    }

    @Override
    public JavacErrorDetail[] compile(String className, Node.Nodes pageNodes) throws JasperException {
        final String source = this.charArrayWriter.toString();
        this.classFiles = new ArrayList();
        javax.tools.JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
        if (javac == null) {
            this.errDispatcher.jspError("jsp.error.nojdk");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager stdFileManager = javac.getStandardFileManager(diagnostics, null, null);
        String name = className.substring(className.lastIndexOf(46) + 1);
        JavaFileObject[] sourceFiles = new JavaFileObject[]{new SimpleJavaFileObject(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE){

            public CharSequence getCharContent(boolean ignore) {
                return source;
            }
        }};
        try {
            stdFileManager.setLocation(StandardLocation.CLASS_PATH, this.cpath);
        }
        catch (IOException e) {
            // empty catch block
        }
        JavaFileManager javaFileManager = this.getJavaFileManager(stdFileManager);
        JavaCompiler.CompilationTask ct = javac.getTask(null, javaFileManager, diagnostics, this.options, null, Arrays.asList(sourceFiles));
        try {
            javaFileManager.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (ct.call().booleanValue()) {
            for (BytecodeFile bytecodeFile : this.classFiles) {
                this.rtctxt.setBytecode(bytecodeFile.getClassName(), bytecodeFile.getBytecode());
            }
            this.classFiles = null;
            return null;
        }
        ArrayList<JavacErrorDetail> problems = new ArrayList<JavacErrorDetail>();
        for (Diagnostic dm : diagnostics.getDiagnostics()) {
            problems.add(ErrorDispatcher.createJavacError(this.javaFileName, pageNodes, new StringBuffer(dm.getMessage(null)), (int)dm.getLineNumber()));
        }
        this.classFiles = null;
        return problems.toArray(new JavacErrorDetail[0]);
    }

    private JavaFileObject getOutputFile(String className, URI uri) {
        BytecodeFile classFile = new BytecodeFile(uri, className);
        String packageName = className.substring(0, className.lastIndexOf("."));
        Map<String, Map<String, JavaFileObject>> packageMap = this.rtctxt.getPackageMap();
        Map<String, JavaFileObject> packageFiles = packageMap.get(packageName);
        if (packageFiles == null) {
            packageFiles = new HashMap<String, JavaFileObject>();
            packageMap.put(packageName, packageFiles);
        }
        packageFiles.put(className, classFile);
        this.classFiles.add(classFile);
        return classFile;
    }

    private JavaFileManager getJavaFileManager(JavaFileManager fm) {
        return new ForwardingJavaFileManager<JavaFileManager>(fm){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
                return Jsr199JavaCompiler.this.getOutputFile(className, URI.create("file:///" + className.replace('.', '/') + (Object)((Object)kind)));
            }

            @Override
            public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
                if (file instanceof BytecodeFile) {
                    return ((BytecodeFile)file).getClassName();
                }
                return super.inferBinaryName(location, file);
            }

            @Override
            public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                Map<String, JavaFileObject> packageFiles;
                if (location == StandardLocation.CLASS_PATH && packageName.startsWith("org.apache.jsp") && (packageFiles = Jsr199JavaCompiler.this.rtctxt.getPackageMap().get(packageName)) != null) {
                    return packageFiles.values();
                }
                Iterable<JavaFileObject> lst = super.list(location, packageName, kinds, recurse);
                return lst;
            }
        };
    }

    private static class BytecodeFile
    extends SimpleJavaFileObject {
        private byte[] bytecode;
        private String className;

        BytecodeFile(URI uri, String className) {
            super(uri, JavaFileObject.Kind.CLASS);
            this.className = className;
        }

        String getClassName() {
            return this.className;
        }

        byte[] getBytecode() {
            return this.bytecode;
        }

        public OutputStream openOutputStream() {
            return new ByteArrayOutputStream(){

                public void close() {
                    BytecodeFile.access$002(BytecodeFile.this, this.toByteArray());
                }
            };
        }

        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.bytecode);
        }

        static /* synthetic */ byte[] access$002(BytecodeFile x0, byte[] x1) {
            x0.bytecode = x1;
            return x1;
        }
    }
}

