/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.TyrusServer;

public class TyrusServerContainer
extends BaseContainer
implements WebSocketContainer {
    private final TyrusServer server;
    private final String contextPath;
    private final ServerApplicationConfig configuration;
    private final Set<SPIRegisteredEndpoint> endpoints = new HashSet<SPIRegisteredEndpoint>();
    private final ErrorCollector collector;
    private final ComponentProviderService componentProvider;
    private long defaultMaxSessionIdleTimeout = 0L;
    private long defaultAsyncSendTimeout = 0L;
    private int maxTextMessageBufferSize = Integer.MAX_VALUE;
    private int maxBinaryMessageBufferSize = Integer.MAX_VALUE;

    public TyrusServerContainer(TyrusServer server, String contextPath, Set<Class<?>> classes, Set<Class<?>> dynamicallyAddedClasses, Set<ServerEndpointConfig> dynamicallyAddedEndpointConfigs) {
        this.collector = new ErrorCollector();
        this.server = server;
        this.contextPath = contextPath;
        this.configuration = new TyrusServerConfiguration(classes == null ? Collections.emptySet() : classes, dynamicallyAddedClasses, dynamicallyAddedEndpointConfigs, this.collector);
        this.componentProvider = ComponentProviderService.create();
    }

    public void start() throws IOException, DeploymentException {
        this.server.start();
        try {
            for (Class endpointClass : this.configuration.getAnnotatedEndpointClasses(null)) {
                EndpointConfig config;
                AnnotatedEndpoint endpoint;
                EndpointWrapper ew = new EndpointWrapper((Endpoint)endpoint, config, this.componentProvider, (BaseContainer)this, this.contextPath, this.collector, (config = (endpoint = AnnotatedEndpoint.fromClass((Class)endpointClass, (ComponentProviderService)this.componentProvider, (boolean)true, (ErrorCollector)this.collector)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null);
                this.deploy(ew);
            }
            for (ServerEndpointConfig serverEndpointConfiguration : this.configuration.getEndpointConfigs(null)) {
                if (serverEndpointConfiguration == null) continue;
                EndpointWrapper ew = new EndpointWrapper(serverEndpointConfiguration.getEndpointClass(), (EndpointConfig)serverEndpointConfiguration, this.componentProvider, (BaseContainer)this, this.contextPath, this.collector, serverEndpointConfiguration.getConfigurator());
                this.deploy(ew);
            }
        }
        catch (DeploymentException de) {
            this.collector.addException((Exception)((Object)de));
        }
        if (!this.collector.isEmpty()) {
            this.stop();
            throw this.collector.composeComprehensiveException();
        }
    }

    private void deploy(EndpointWrapper wrapper) throws DeploymentException {
        SPIRegisteredEndpoint ge = this.server.register((SPIEndpoint)wrapper);
        this.endpoints.add(ge);
    }

    public void stop() {
        for (SPIRegisteredEndpoint wsa : this.endpoints) {
            wsa.remove();
            this.server.unregister(wsa);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).fine("Closing down : " + wsa);
        }
        this.server.stop();
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        throw new UnsupportedOperationException();
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        throw new UnsupportedOperationException();
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.maxBinaryMessageBufferSize = max;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.maxTextMessageBufferSize = max;
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long defaultMaxSessionIdleTimeout) {
        this.defaultMaxSessionIdleTimeout = defaultMaxSessionIdleTimeout;
    }
}

