/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.OsgiRegistry;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.TyrusContainerProvider;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.spi.TyrusContainer;

public class ServerContainerFactory {
    private static OsgiRegistry osgiRegistry = null;

    private static void initOsgiRegistry() {
        try {
            osgiRegistry = OsgiRegistry.getInstance();
            if (osgiRegistry != null) {
                osgiRegistry.hookUp();
            }
        }
        catch (Throwable e) {
            osgiRegistry = null;
        }
    }

    public static TyrusServerContainer create(String providerClassName, String contextPath, int port, Set<Class<?>> classes) {
        Class providerClass;
        ServerContainerFactory.initOsgiRegistry();
        try {
            providerClass = osgiRegistry != null ? osgiRegistry.classForNameWithException(providerClassName) : Class.forName(providerClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load container provider class: " + providerClassName, e);
        }
        Logger.getLogger(ServerContainerFactory.class.getName()).info("Provider class loaded: " + providerClassName);
        TyrusServerContainer container = ServerContainerFactory.create(providerClass, contextPath, port, classes, Collections.<Class<?>>emptySet(), Collections.<ServerEndpointConfig>emptySet());
        TyrusContainerProvider.getContainerProvider().setContainer((Object)container);
        return container;
    }

    public static TyrusServerContainer create(Class<? extends TyrusContainer> providerClass, String contextPath, int port, Set<Class<?>> configuration, Set<Class<?>> dynamicallyAddedClasses, Set<ServerEndpointConfig> dynamicallyAddedEndpointConfigs) {
        TyrusContainer containerProvider;
        try {
            containerProvider = (TyrusContainer)ReflectionHelper.getInstance(providerClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate provider class: " + providerClass.getName(), e);
        }
        return new TyrusServerContainer(containerProvider.createServer(contextPath, port), contextPath, configuration, dynamicallyAddedClasses, dynamicallyAddedEndpointConfigs);
    }
}

