/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.test.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class GrizzlyModProxy {
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Attribute<Socket> tunnelSockets = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(ProxyFilter.class.getName() + ".TunnelSocket");
    private final HttpServer server;
    private final ProxyFilter proxyFilter;

    public GrizzlyModProxy(String host, int port) {
        this.server = HttpServer.createSimpleServer((String)"/", (String)host, (int)port);
        this.proxyFilter = new ProxyFilter();
        this.server.getListener("grizzly").registerAddOn((networkListener, builder) -> {
            int httpServerFilterIdx = builder.indexOfType(HttpServerFilter.class);
            if (httpServerFilterIdx >= 0) {
                builder.add(httpServerFilterIdx, (Filter)this.proxyFilter);
            }
        });
    }

    public void start() throws IOException {
        this.server.start();
    }

    public void stop() throws IOException {
        this.server.shutdown();
        this.executorService.shutdown();
    }

    protected NextAction handleConnect(FilterChainContext ctx, HttpContent content) {
        int port;
        System.out.println("Handle CONNECT start . . .");
        HttpHeader httpHeader = content.getHttpHeader();
        HttpRequestPacket requestPacket = (HttpRequestPacket)httpHeader.getHttpHeader();
        if (!requestPacket.getMethod().matchesMethod("CONNECT")) {
            System.out.println("Received method is not CONNECT");
            this.writeHttpResponse(ctx, 400);
            return ctx.getStopAction();
        }
        String destinationUri = requestPacket.getRequestURI();
        int colonIdx = destinationUri.indexOf(58);
        if (colonIdx == -1) {
            System.out.println("Destination URI not in host:port format: " + destinationUri);
            this.writeHttpResponse(ctx, 400);
            return ctx.getStopAction();
        }
        String hostName = destinationUri.substring(0, colonIdx);
        String portStr = destinationUri.substring(colonIdx + 1);
        try {
            port = Integer.parseInt(portStr);
        }
        catch (Throwable t) {
            System.out.println("Could not parse destination port: " + portStr);
            this.writeHttpResponse(ctx, 400);
            return ctx.getStopAction();
        }
        try {
            Socket tunnelSocket = new Socket(hostName, port);
            Connection grizzlyConnection = ctx.getConnection();
            this.tunnelSockets.set((AttributeStorage)grizzlyConnection, (Object)tunnelSocket);
            TunnelSocketReader tunnelSocketReader = new TunnelSocketReader(tunnelSocket, grizzlyConnection);
            this.executorService.submit(tunnelSocketReader::read);
        }
        catch (IOException e) {
            this.writeHttpResponse(ctx, 400);
            return ctx.getStopAction();
        }
        HttpRequestPacket request = this.getHttpRequest(ctx);
        request.getResponse().getProcessingState().setKeepAlive(true);
        request.getResponse().setContentLength(0);
        request.setMethod("GET");
        this.writeHttpResponse(ctx, 200);
        System.out.println("Connection to proxy established.");
        return ctx.getStopAction();
    }

    private void writeHttpResponse(FilterChainContext ctx, int status) {
        HttpResponsePacket responsePacket = this.getHttpRequest(ctx).getResponse();
        responsePacket.setProtocol(Protocol.HTTP_1_1);
        responsePacket.setStatus(status);
        ctx.write((Object)HttpContent.builder((HttpHeader)responsePacket).build());
    }

    private HttpRequestPacket getHttpRequest(FilterChainContext ctx) {
        return (HttpRequestPacket)((HttpContent)ctx.getMessage()).getHttpHeader();
    }

    private static class TunnelSocketReader {
        private final Socket tunnelSocket;
        private final Connection grizzlyConnection;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private final InputStream inputStream;

        TunnelSocketReader(Socket tunnelSocket, Connection grizzlyConnection) throws IOException {
            this.tunnelSocket = tunnelSocket;
            this.grizzlyConnection = grizzlyConnection;
            this.inputStream = tunnelSocket.getInputStream();
        }

        void read() {
            try {
                while (true) {
                    if (this.tunnelSocket.isClosed()) {
                        this.flushBufferedData();
                        this.grizzlyConnection.close();
                        return;
                    }
                    int b = this.inputStream.read();
                    if (b == -1) {
                        this.flushBufferedData();
                        this.grizzlyConnection.close();
                        return;
                    }
                    this.buffer.write(b);
                    if (this.inputStream.available() != 0) continue;
                    this.flushBufferedData();
                }
            }
            catch (IOException e) {
                this.flushBufferedData();
                this.grizzlyConnection.close();
                if (e.getMessage().contains("Socket closed")) {
                    System.out.println("Connection between the proxy and a server closed by the server.");
                } else {
                    e.printStackTrace();
                }
                return;
            }
        }

        private void flushBufferedData() {
            if (this.buffer.size() == 0) {
                return;
            }
            Buffer message = Buffers.wrap((MemoryManager)this.grizzlyConnection.getMemoryManager(), (byte[])this.buffer.toByteArray());
            this.grizzlyConnection.write((Object)message);
            this.buffer.reset();
        }
    }

    private class ProxyFilter
    extends BaseFilter {
        private ProxyFilter() {
        }

        public NextAction handleClose(FilterChainContext ctx) throws IOException {
            Socket tunnelSocket = (Socket)GrizzlyModProxy.this.tunnelSockets.get((AttributeStorage)ctx.getConnection());
            if (tunnelSocket != null) {
                tunnelSocket.close();
            }
            return ctx.getStopAction();
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            HttpContent message = (HttpContent)ctx.getMessage();
            Socket tunnelSocket = (Socket)GrizzlyModProxy.this.tunnelSockets.get((AttributeStorage)ctx.getConnection());
            if (tunnelSocket == null) {
                return GrizzlyModProxy.this.handleConnect(ctx, message);
            }
            if (message.getContent().hasRemaining()) {
                Buffer buffer = message.getContent();
                message.recycle();
                tunnelSocket.getOutputStream().write(buffer.array(), buffer.arrayOffset(), buffer.remaining());
            }
            return ctx.getStopAction();
        }
    }
}

