/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.test.tools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.websocket.ClientEndpoint;
import javax.websocket.DeploymentException;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import junit.framework.Assert;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.server.Server;

public class TestContainer {
    protected static final String POSITIVE = "POSITIVE";
    protected static final String NEGATIVE = "NEGATIVE";
    private String contextPath = "/e2e-test";
    private String defaultHost = "localhost";
    private int defaultPort = 8025;
    private Map<String, Object> serverProperties = new HashMap<String, Object>();

    protected Server startServer(Class<?> ... endpointClasses) throws DeploymentException {
        String host = System.getProperty("tyrus.test.host");
        if (host == null) {
            Server server = new Server(this.defaultHost, this.getPort(), this.contextPath, this.serverProperties, (Class[])endpointClasses);
            server.start();
            return server;
        }
        return null;
    }

    protected void stopServer(Server server) {
        if (server != null) {
            server.stop();
        }
    }

    protected String getHost() {
        String host = System.getProperty("tyrus.test.host");
        if (host != null) {
            return host;
        }
        return this.defaultHost;
    }

    protected int getPort() {
        String port = System.getProperty("tyrus.test.port");
        if (port != null) {
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.defaultPort;
    }

    protected URI getURI(Class<?> serverClass) {
        return this.getURI(serverClass, null);
    }

    protected URI getURI(Class<?> serverClass, String scheme) {
        String endpointPath = serverClass.getAnnotation(ServerEndpoint.class).value();
        return this.getURI(endpointPath, scheme);
    }

    protected URI getURI(String endpointPath) {
        return this.getURI(endpointPath, null);
    }

    protected URI getURI(String endpointPath, String scheme) {
        try {
            String currentScheme = scheme == null ? "ws" : scheme;
            int port = this.getPort();
            if (port == 80 && "ws".equalsIgnoreCase(currentScheme) || port == 443 && "wss".equalsIgnoreCase(currentScheme)) {
                port = -1;
            }
            return new URI(currentScheme, null, this.getHost(), port, this.contextPath + endpointPath, null, null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ClientManager createClient() {
        String clientContainerClassName = System.getProperty("tyrus.test.container.client");
        if (clientContainerClassName != null) {
            return ClientManager.createClient((String)clientContainerClassName);
        }
        return ClientManager.createClient();
    }

    public Map<String, Object> getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(Map<String, Object> properties) {
        this.serverProperties = properties;
    }

    protected void testViaServiceEndpoint(ClientManager client, Class<?> serviceEndpoint, String expectedResult, String message) throws DeploymentException, IOException, InterruptedException {
        MyServiceClientEndpoint myServiceClientEndpoint = new MyServiceClientEndpoint();
        Session serviceSession = client.connectToServer((Object)myServiceClientEndpoint, this.getURI(serviceEndpoint));
        serviceSession.getBasicRemote().sendText(message);
        Assert.assertTrue((boolean)myServiceClientEndpoint.latch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((String)expectedResult, (String)myServiceClientEndpoint.receivedMessage);
        serviceSession.close();
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    @ClientEndpoint
    public static class MyServiceClientEndpoint {
        public final CountDownLatch latch = new CountDownLatch(1);
        public volatile String receivedMessage = null;

        @OnMessage
        public void onMessage(String message) {
            this.receivedMessage = message;
            this.latch.countDown();
        }
    }
}

