/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Extension;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.Masker;
import org.glassfish.tyrus.core.MaskingKeyGenerator;
import org.glassfish.tyrus.core.ProtocolException;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusFuture;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.extension.ExtendedExtension;
import org.glassfish.tyrus.core.frame.BinaryFrame;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.TextFrame;
import org.glassfish.tyrus.core.frame.TyrusFrame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.core.monitoring.MessageEventListener;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;
import org.glassfish.tyrus.spi.WriterInfo;

public final class ProtocolHandler {
    public static final int MASK_SIZE = 4;
    private static final Logger LOGGER = Logger.getLogger(ProtocolHandler.class.getName());
    private static final int SEND_TIMEOUT = 3000;
    private final boolean client;
    private final MaskingKeyGenerator maskingKeyGenerator;
    private final ParsingState parsingState = new ParsingState();
    private volatile TyrusWebSocket webSocket;
    private volatile byte outFragmentedType;
    private volatile Writer writer;
    private volatile byte inFragmentedType;
    private volatile boolean processingFragment;
    private volatile String subProtocol = null;
    private volatile List<Extension> extensions;
    private volatile ExtendedExtension.ExtensionContext extensionContext;
    private volatile ByteBuffer remainder = null;
    private volatile boolean hasExtensions = false;
    private volatile MessageEventListener messageEventListener = MessageEventListener.NO_OP;
    private volatile SendingFragmentState sendingFragment = SendingFragmentState.IDLE;
    private static final WriterInfo CLOSE = new WriterInfo(WriterInfo.MessageType.CLOSE, WriterInfo.RemoteEndpointType.SUPER);
    private static final WriterInfo NULL_INFO = new WriterInfo(null, null);
    private final Lock lock = new ReentrantLock();
    private final Condition idleCondition = this.lock.newCondition();

    ProtocolHandler(boolean client, MaskingKeyGenerator maskingKeyGenerator) {
        this.client = client;
        this.maskingKeyGenerator = client ? (maskingKeyGenerator != null ? maskingKeyGenerator : new MaskingKeyGenerator(){
            private final SecureRandom secureRandom = new SecureRandom();

            @Override
            public int nextInt() {
                return this.secureRandom.nextInt();
            }
        }) : null;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean hasExtensions() {
        return this.hasExtensions;
    }

    public Handshake handshake(TyrusEndpointWrapper endpointWrapper, UpgradeRequest request, UpgradeResponse response, ExtendedExtension.ExtensionContext extensionContext) throws HandshakeException {
        Handshake handshake = Handshake.createServerHandshake(request, extensionContext);
        this.extensions = handshake.respond(request, response, endpointWrapper);
        this.subProtocol = response.getFirstHeaderValue("Sec-WebSocket-Protocol");
        this.extensionContext = extensionContext;
        this.hasExtensions = this.extensions != null && this.extensions.size() > 0;
        return handshake;
    }

    List<Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        this.hasExtensions = extensions != null && extensions.size() > 0;
    }

    String getSubProtocol() {
        return this.subProtocol;
    }

    public void setWebSocket(TyrusWebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public void setExtensionContext(ExtendedExtension.ExtensionContext extensionContext) {
        this.extensionContext = extensionContext;
    }

    public void setMessageEventListener(MessageEventListener messageEventListener) {
        this.messageEventListener = messageEventListener;
    }

    final Future<Frame> send(TyrusFrame frame, WriterInfo writerInfo) {
        return this.send(frame, null, writerInfo, (Boolean)true);
    }

    private Future<Frame> send(TyrusFrame frame, CompletionHandler<Frame> completionHandler, WriterInfo writerInfo, Boolean useTimeout) {
        return this.write(frame, completionHandler, writerInfo, (boolean)useTimeout);
    }

    private Future<Frame> send(ByteBuffer frame, CompletionHandler<Frame> completionHandler, WriterInfo writerInfo, Boolean useTimeout) {
        return this.write(frame, completionHandler, writerInfo, (boolean)useTimeout);
    }

    @Deprecated
    public Future<Frame> send(byte[] data) {
        return this.send(data, NULL_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Frame> send(byte[] data, WriterInfo writerInfo) {
        this.lock.lock();
        try {
            this.checkSendingFragment();
            Future<Frame> future = this.send(new BinaryFrame(data, false, true), null, writerInfo, (Boolean)true);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public void send(byte[] data, SendHandler handler) {
        this.send(data, handler, NULL_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] data, final SendHandler handler, WriterInfo writerInfo) {
        this.lock.lock();
        try {
            this.checkSendingFragment();
            this.send(new BinaryFrame(data, false, true), new CompletionHandler<Frame>(){

                @Override
                public void failed(Throwable throwable) {
                    handler.onResult(new SendResult(throwable));
                }

                @Override
                public void completed(Frame result) {
                    handler.onResult(new SendResult());
                }
            }, writerInfo, (Boolean)true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public Future<Frame> send(String data) {
        return this.send(data, NULL_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Frame> send(String data, WriterInfo writerInfo) {
        this.lock.lock();
        try {
            this.checkSendingFragment();
            Future<Frame> future = this.send(new TextFrame(data, false, true), writerInfo);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public void send(String data, SendHandler handler) {
        this.send(data, handler, NULL_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String data, final SendHandler handler, WriterInfo writerInfo) {
        this.lock.lock();
        try {
            this.checkSendingFragment();
            this.send(new TextFrame(data, false, true), new CompletionHandler<Frame>(){

                @Override
                public void failed(Throwable throwable) {
                    handler.onResult(new SendResult(throwable));
                }

                @Override
                public void completed(Frame result) {
                    handler.onResult(new SendResult());
                }
            }, writerInfo, (Boolean)true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Future<Frame> sendRawFrame(ByteBuffer data) {
        this.lock.lock();
        try {
            this.checkSendingFragment();
            Future<Frame> future = this.send(data, null, new WriterInfo(WriterInfo.MessageType.BINARY, WriterInfo.RemoteEndpointType.BROADCAST), (Boolean)true);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkSendingFragment() {
        long timeout = System.currentTimeMillis() + 3000L;
        while (this.sendingFragment != SendingFragmentState.IDLE) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis >= timeout) {
                throw new IllegalStateException();
            }
            try {
                if (this.idleCondition.await(timeout - currentTimeMillis, TimeUnit.MILLISECONDS)) continue;
                throw new IllegalStateException();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }

    @Deprecated
    public Future<Frame> stream(boolean last, byte[] bytes, int off, int len) {
        return this.stream(last, bytes, off, len, NULL_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Frame> stream(boolean last, byte[] bytes, int off, int len, WriterInfo writerInfo) {
        this.lock.lock();
        try {
            switch (this.sendingFragment) {
                case SENDING_BINARY: {
                    Future<Frame> frameFuture = this.send(new BinaryFrame(Arrays.copyOfRange(bytes, off, off + len), true, last), writerInfo);
                    if (last) {
                        this.sendingFragment = SendingFragmentState.IDLE;
                        this.idleCondition.signalAll();
                    }
                    Future<Frame> future = frameFuture;
                    return future;
                }
                case SENDING_TEXT: {
                    this.checkSendingFragment();
                    this.sendingFragment = last ? SendingFragmentState.IDLE : SendingFragmentState.SENDING_BINARY;
                    Future<Frame> future = this.send(new BinaryFrame(Arrays.copyOfRange(bytes, off, off + len), false, last), writerInfo);
                    return future;
                }
            }
            this.sendingFragment = last ? SendingFragmentState.IDLE : SendingFragmentState.SENDING_BINARY;
            Future<Frame> future = this.send(new BinaryFrame(Arrays.copyOfRange(bytes, off, off + len), false, last), writerInfo);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public Future<Frame> stream(boolean last, String fragment) {
        return this.stream(last, fragment, NULL_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Frame> stream(boolean last, String fragment, WriterInfo writerInfo) {
        this.lock.lock();
        try {
            switch (this.sendingFragment) {
                case SENDING_TEXT: {
                    Future<Frame> frameFuture = this.send(new TextFrame(fragment, true, last), writerInfo);
                    if (last) {
                        this.sendingFragment = SendingFragmentState.IDLE;
                        this.idleCondition.signalAll();
                    }
                    Future<Frame> future = frameFuture;
                    return future;
                }
                case SENDING_BINARY: {
                    this.checkSendingFragment();
                    this.sendingFragment = last ? SendingFragmentState.IDLE : SendingFragmentState.SENDING_TEXT;
                    Future<Frame> future = this.send(new TextFrame(fragment, false, last), writerInfo);
                    return future;
                }
            }
            this.sendingFragment = last ? SendingFragmentState.IDLE : SendingFragmentState.SENDING_TEXT;
            Future<Frame> future = this.send(new TextFrame(fragment, false, last), writerInfo);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized Future<Frame> close(int code, String reason) {
        CloseReason closeReason = new CloseReason(CloseReason.CloseCodes.getCloseCode(code), reason);
        CloseFrame outgoingCloseFrame = code == CloseReason.CloseCodes.NO_STATUS_CODE.getCode() || code == CloseReason.CloseCodes.CLOSED_ABNORMALLY.getCode() || code == CloseReason.CloseCodes.TLS_HANDSHAKE_FAILURE.getCode() || this.client && (code == CloseReason.CloseCodes.SERVICE_RESTART.getCode() || code == CloseReason.CloseCodes.TRY_AGAIN_LATER.getCode()) ? new CloseFrame(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, reason)) : new CloseFrame(closeReason);
        Future<Frame> send = this.send(outgoingCloseFrame, null, CLOSE, (Boolean)false);
        this.webSocket.onClose(new CloseFrame(closeReason));
        return send;
    }

    private Future<Frame> write(TyrusFrame frame, CompletionHandler<Frame> completionHandler, WriterInfo data, boolean useTimeout) {
        Writer localWriter = this.writer;
        TyrusFuture<Frame> future = new TyrusFuture<Frame>();
        if (localWriter == null) {
            throw new IllegalStateException(LocalizationMessages.CONNECTION_NULL());
        }
        ByteBuffer byteBuffer = this.frame(frame);
        localWriter.write(byteBuffer, new CompletionHandlerWrapper(completionHandler, future, frame), data);
        this.messageEventListener.onFrameSent(frame.getFrameType(), frame.getPayloadLength());
        return future;
    }

    private Future<Frame> write(ByteBuffer frame, CompletionHandler<Frame> completionHandler, WriterInfo data, boolean useTimeout) {
        Writer localWriter = this.writer;
        TyrusFuture<Frame> future = new TyrusFuture<Frame>();
        if (localWriter == null) {
            throw new IllegalStateException(LocalizationMessages.CONNECTION_NULL());
        }
        localWriter.write(frame, new CompletionHandlerWrapper(completionHandler, future, null), data);
        return future;
    }

    private long decodeLength(byte[] bytes) {
        return Utils.toLong(bytes, 0, bytes.length);
    }

    private byte[] encodeLength(long length) {
        byte[] lengthBytes;
        if (length <= 125L) {
            lengthBytes = new byte[]{(byte)length};
        } else {
            byte[] b = Utils.toArray(length);
            if (length <= 65535L) {
                lengthBytes = new byte[3];
                lengthBytes[0] = 126;
                System.arraycopy(b, 6, lengthBytes, 1, 2);
            } else {
                lengthBytes = new byte[9];
                lengthBytes[0] = 127;
                System.arraycopy(b, 0, lengthBytes, 1, 8);
            }
        }
        return lengthBytes;
    }

    private void validate(byte fragmentType, byte opcode) {
        if (opcode != 0 && opcode != fragmentType && !this.isControlFrame(opcode)) {
            throw new ProtocolException(LocalizationMessages.SEND_MESSAGE_INFRAGMENT());
        }
    }

    private byte checkForLastFrame(Frame frame) {
        byte local = frame.getOpcode();
        if (frame.isControlFrame()) {
            local = (byte)(local | 0x80);
            return local;
        }
        if (!frame.isFin()) {
            if (this.outFragmentedType != 0) {
                local = 0;
            } else {
                this.outFragmentedType = local;
                local = (byte)(local & 0x7F);
            }
            this.validate(this.outFragmentedType, local);
        } else if (this.outFragmentedType != 0) {
            local = -128;
            this.outFragmentedType = 0;
        } else {
            local = (byte)(local | 0x80);
        }
        return local;
    }

    void doClose() {
        Writer localWriter = this.writer;
        if (localWriter == null) {
            throw new IllegalStateException(LocalizationMessages.CONNECTION_NULL());
        }
        try {
            localWriter.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(LocalizationMessages.IOEXCEPTION_CLOSE(), e);
        }
    }

    ByteBuffer frame(Frame frame) {
        if (this.client) {
            frame = Frame.builder(frame).maskingKey(this.maskingKeyGenerator.nextInt()).mask(true).build();
        }
        if (this.extensions != null && this.extensions.size() > 0) {
            for (Extension extension : this.extensions) {
                if (!(extension instanceof ExtendedExtension)) continue;
                try {
                    frame = ((ExtendedExtension)extension).processOutgoing(this.extensionContext, frame);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.FINE, LocalizationMessages.EXTENSION_EXCEPTION(extension.getName(), t.getMessage()), t);
                }
            }
        }
        byte opcode = this.checkForLastFrame(frame);
        if (frame.isRsv1()) {
            opcode = (byte)(opcode | 0x40);
        }
        if (frame.isRsv2()) {
            opcode = (byte)(opcode | 0x20);
        }
        if (frame.isRsv3()) {
            opcode = (byte)(opcode | 0x10);
        }
        byte[] bytes = frame.getPayloadData();
        byte[] lengthBytes = this.encodeLength(frame.getPayloadLength());
        int payloadLength = (int)frame.getPayloadLength();
        int length = 1 + lengthBytes.length + payloadLength + (this.client ? 4 : 0);
        int payloadStart = 1 + lengthBytes.length + (this.client ? 4 : 0);
        byte[] packet = new byte[length];
        packet[0] = opcode;
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        if (this.client) {
            Integer maskingKey = frame.getMaskingKey();
            if (maskingKey == null) {
                throw new ProtocolException("Masking key cannot be null when sending message from client to server.");
            }
            Masker masker = new Masker(maskingKey);
            packet[1] = (byte)(packet[1] | 0x80);
            masker.mask(packet, payloadStart, bytes, payloadLength);
            System.arraycopy(masker.getMask(), 0, packet, payloadStart - 4, 4);
        } else {
            System.arraycopy(bytes, 0, packet, payloadStart, payloadLength);
        }
        return ByteBuffer.wrap(packet);
    }

    public Frame unframe(ByteBuffer buffer) {
        try {
            block8: while (true) {
                switch (this.parsingState.state.get()) {
                    case 0: {
                        if (buffer.remaining() < 2) {
                            return null;
                        }
                        byte opcode = buffer.get();
                        this.parsingState.finalFragment = this.isBitSet(opcode, 7);
                        this.parsingState.controlFrame = this.isControlFrame(opcode);
                        this.parsingState.opcode = (byte)(opcode & 0x7F);
                        if (!this.parsingState.finalFragment && this.parsingState.controlFrame) {
                            throw new ProtocolException(LocalizationMessages.CONTROL_FRAME_FRAGMENTED());
                        }
                        byte lengthCode = buffer.get();
                        this.parsingState.masked = (lengthCode & 0x80) == 128;
                        this.parsingState.masker = new Masker(buffer);
                        if (this.parsingState.masked) {
                            lengthCode = (byte)(lengthCode ^ 0x80);
                        }
                        this.parsingState.lengthCode = lengthCode;
                        this.parsingState.state.incrementAndGet();
                        continue block8;
                    }
                    case 1: {
                        if (this.parsingState.lengthCode <= 125) {
                            this.parsingState.length = this.parsingState.lengthCode;
                        } else {
                            int lengthBytes;
                            if (this.parsingState.controlFrame) {
                                throw new ProtocolException(LocalizationMessages.CONTROL_FRAME_LENGTH());
                            }
                            int n = lengthBytes = this.parsingState.lengthCode == 126 ? 2 : 8;
                            if (buffer.remaining() < lengthBytes) {
                                return null;
                            }
                            this.parsingState.masker.setBuffer(buffer);
                            this.parsingState.length = this.decodeLength(this.parsingState.masker.unmask(lengthBytes));
                        }
                        this.parsingState.state.incrementAndGet();
                        continue block8;
                    }
                    case 2: {
                        if (this.parsingState.masked) {
                            if (buffer.remaining() < 4) {
                                return null;
                            }
                            this.parsingState.masker.setBuffer(buffer);
                            this.parsingState.masker.readMask();
                        }
                        this.parsingState.state.incrementAndGet();
                        continue block8;
                    }
                    case 3: {
                        if ((long)buffer.remaining() < this.parsingState.length) {
                            return null;
                        }
                        this.parsingState.masker.setBuffer(buffer);
                        byte[] data = this.parsingState.masker.unmask((int)this.parsingState.length);
                        if ((long)data.length != this.parsingState.length) {
                            throw new ProtocolException(LocalizationMessages.DATA_UNEXPECTED_LENGTH(data.length, this.parsingState.length));
                        }
                        Frame frame = Frame.builder().fin(this.parsingState.finalFragment).rsv1(this.isBitSet(this.parsingState.opcode, 6)).rsv2(this.isBitSet(this.parsingState.opcode, 5)).rsv3(this.isBitSet(this.parsingState.opcode, 4)).opcode((byte)(this.parsingState.opcode & 0xF)).payloadLength(this.parsingState.length).payloadData(data).build();
                        this.parsingState.recycle();
                        return frame;
                    }
                }
                break;
            }
            throw new IllegalStateException(LocalizationMessages.UNEXPECTED_STATE(this.parsingState.state));
        }
        catch (Exception e) {
            this.parsingState.recycle();
            throw (RuntimeException)e;
        }
    }

    public void process(Frame frame, TyrusWebSocket socket) {
        CloseReason.CloseCode closeCode;
        TyrusFrame tyrusFrame;
        if (frame.isRsv1() || frame.isRsv2() || frame.isRsv3()) {
            throw new ProtocolException(LocalizationMessages.RSV_INCORRECTLY_SET());
        }
        byte opcode = frame.getOpcode();
        boolean fin = frame.isFin();
        if (!frame.isControlFrame()) {
            boolean continuationFrame;
            boolean bl = continuationFrame = opcode == 0;
            if (continuationFrame && !this.processingFragment) {
                throw new ProtocolException(LocalizationMessages.UNEXPECTED_END_FRAGMENT());
            }
            if (this.processingFragment && !continuationFrame) {
                throw new ProtocolException(LocalizationMessages.FRAGMENT_INVALID_OPCODE());
            }
            if (!fin && !continuationFrame) {
                this.processingFragment = true;
            }
            if (!fin && this.inFragmentedType == 0) {
                this.inFragmentedType = opcode;
            }
        }
        if ((tyrusFrame = TyrusFrame.wrap(frame, this.inFragmentedType, this.remainder)) instanceof TextFrame) {
            this.remainder = ((TextFrame)tyrusFrame).getRemainder();
        }
        if (!this.client && tyrusFrame.isControlFrame() && tyrusFrame instanceof CloseFrame && ((closeCode = ((CloseFrame)tyrusFrame).getCloseReason().getCloseCode()).equals(CloseReason.CloseCodes.SERVICE_RESTART) || closeCode.equals(CloseReason.CloseCodes.TRY_AGAIN_LATER))) {
            throw new ProtocolException("Illegal close code: " + closeCode);
        }
        tyrusFrame.respond(socket);
        if (!tyrusFrame.isControlFrame() && fin) {
            this.inFragmentedType = 0;
            this.processingFragment = false;
        }
    }

    private boolean isControlFrame(byte opcode) {
        return (opcode & 8) == 8;
    }

    private boolean isBitSet(byte b, int bit) {
        return (b >> bit & 1) != 0;
    }

    private static class ParsingState {
        final AtomicInteger state = new AtomicInteger(0);
        volatile byte opcode = (byte)-1;
        volatile long length = -1L;
        volatile boolean masked;
        volatile Masker masker;
        volatile boolean finalFragment;
        volatile boolean controlFrame;
        private volatile byte lengthCode = (byte)-1;

        private ParsingState() {
        }

        void recycle() {
            this.state.set(0);
            this.opcode = (byte)-1;
            this.length = -1L;
            this.lengthCode = (byte)-1;
            this.masked = false;
            this.masker = null;
            this.finalFragment = false;
            this.controlFrame = false;
        }
    }

    private static class CompletionHandlerWrapper
    extends CompletionHandler<ByteBuffer> {
        private final CompletionHandler<Frame> frameCompletionHandler;
        private final TyrusFuture<Frame> future;
        private final Frame frame;

        private CompletionHandlerWrapper(CompletionHandler<Frame> frameCompletionHandler, TyrusFuture<Frame> future, Frame frame) {
            this.frameCompletionHandler = frameCompletionHandler;
            this.future = future;
            this.frame = frame;
        }

        @Override
        public void cancelled() {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.cancelled();
            }
            if (this.future != null) {
                this.future.setFailure(new RuntimeException(LocalizationMessages.FRAME_WRITE_CANCELLED()));
            }
        }

        @Override
        public void failed(Throwable throwable) {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.failed(throwable);
            }
            if (this.future != null) {
                this.future.setFailure(throwable);
            }
        }

        @Override
        public void completed(ByteBuffer result) {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.completed(this.frame);
            }
            if (this.future != null) {
                this.future.setResult(this.frame);
            }
        }

        @Override
        public void updated(ByteBuffer result) {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.updated(this.frame);
            }
        }
    }

    private static enum SendingFragmentState {
        IDLE,
        SENDING_TEXT,
        SENDING_BINARY;

    }
}

