/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.Bits;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.MemoryUtils;
import org.glassfish.grizzly.utils.ArrayUtils;

public final class BuffersBuffer
extends CompositeBuffer {
    public static volatile boolean DEBUG_MODE = false;
    private static final ThreadCache.CachedTypeIndex<BuffersBuffer> CACHE_IDX = ThreadCache.obtainIndex(BuffersBuffer.class, Integer.getInteger(BuffersBuffer.class.getName() + ".bb-cache-size", 5));
    protected Exception disposeStackTrace;
    private MemoryManager memoryManager;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean bigEndian = true;
    private boolean allowBufferDispose = false;
    private boolean allowInternalBuffersDispose = true;
    private boolean isDisposed;
    private boolean isReadOnly;
    private int mark = -1;
    private int position;
    private int limit;
    private int capacity;
    private int[] bufferBounds;
    private Buffer[] buffers;
    private int buffersSize;
    private int lastSegmentIndex;
    private int lowerBound;
    private int upperBound;
    private int activeBufferLowerBound;
    private Buffer activeBuffer;
    private final SetterImpl setter = new SetterImpl();

    public static BuffersBuffer create() {
        return BuffersBuffer.create(MemoryManager.DEFAULT_MEMORY_MANAGER, null, 0, false);
    }

    public static BuffersBuffer create(MemoryManager memoryManager) {
        return BuffersBuffer.create(memoryManager, null, 0, false);
    }

    public static BuffersBuffer create(MemoryManager memoryManager, Buffer ... buffers) {
        return BuffersBuffer.create(memoryManager, buffers, buffers.length, false);
    }

    public static BuffersBuffer create(MemoryManager memoryManager, Buffer[] buffers, boolean isReadOnly) {
        return BuffersBuffer.create(memoryManager, buffers, buffers.length, isReadOnly);
    }

    private static BuffersBuffer create(MemoryManager memoryManager, Buffer[] buffers, int buffersSize, boolean isReadOnly) {
        BuffersBuffer buffer = ThreadCache.takeFromCache(CACHE_IDX);
        if (buffer != null) {
            buffer.set(memoryManager, buffers, buffersSize, isReadOnly);
            buffer.isDisposed = false;
            return buffer;
        }
        return new BuffersBuffer(memoryManager, buffers, buffersSize, isReadOnly);
    }

    protected BuffersBuffer(MemoryManager memoryManager, Buffer[] buffers, int buffersSize, boolean isReadOnly) {
        this.set(memoryManager, buffers, buffersSize, isReadOnly);
    }

    private void set(MemoryManager memoryManager, Buffer[] buffers, int buffersSize, boolean isReadOnly) {
        MemoryManager memoryManager2 = this.memoryManager = memoryManager != null ? memoryManager : MemoryManager.DEFAULT_MEMORY_MANAGER;
        if (buffers != null || this.buffers == null) {
            this.initBuffers(buffers, buffersSize);
            this.calcCapacity();
            this.limit = this.capacity;
        }
        this.isReadOnly = isReadOnly;
    }

    private void initBuffers(Buffer[] buffers, int bufferSize) {
        this.buffers = buffers != null ? buffers : new Buffer[4];
        this.buffersSize = bufferSize;
        if (this.bufferBounds == null || this.bufferBounds.length < this.buffers.length) {
            this.bufferBounds = new int[this.buffers.length];
        }
    }

    private BuffersBuffer duplicateFrom(BuffersBuffer that) {
        this.memoryManager = that.memoryManager;
        Buffer[] ba = new Buffer[that.buffers.length];
        int len = that.buffersSize;
        for (int i = 0; i < len; ++i) {
            ba[i] = that.buffers[i].duplicate();
        }
        this.initBuffers(ba, that.buffersSize);
        System.arraycopy(that.bufferBounds, 0, this.bufferBounds, 0, that.buffersSize);
        this.position = that.position;
        this.limit = that.limit;
        this.capacity = that.capacity;
        this.isReadOnly = that.isReadOnly;
        return this;
    }

    @Override
    public final boolean tryDispose() {
        if (this.allowBufferDispose) {
            this.dispose();
            return true;
        }
        if (this.allowInternalBuffersDispose) {
            this.removeAndDisposeBuffers();
        }
        return false;
    }

    @Override
    public void dispose() {
        this.checkDispose();
        this.isDisposed = true;
        this.removeAndDisposeBuffers();
        if (DEBUG_MODE) {
            DebugLogic.doDebug(this);
        }
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public final boolean isComposite() {
        return true;
    }

    @Override
    public BuffersBuffer append(Buffer buffer) {
        if (buffer == this) {
            throw new IllegalArgumentException("CompositeBuffer can not append itself");
        }
        this.checkDispose();
        this.checkReadOnly();
        this.ensureBuffersCapacity(1);
        this.capacity += buffer.remaining();
        this.bufferBounds[this.buffersSize] = this.capacity;
        this.buffers[this.buffersSize++] = buffer;
        this.limit = this.capacity;
        this.resetLastLocation();
        return this;
    }

    @Override
    public BuffersBuffer prepend(Buffer buffer) {
        if (buffer == this) {
            throw new IllegalArgumentException("CompositeBuffer can not append itself");
        }
        this.checkDispose();
        this.checkReadOnly();
        this.ensureBuffersCapacity(1);
        System.arraycopy(this.buffers, 0, this.buffers, 1, this.buffersSize);
        this.buffers[0] = buffer;
        ++this.buffersSize;
        this.calcCapacity();
        this.position = 0;
        this.limit += buffer.remaining();
        this.resetLastLocation();
        return this;
    }

    @Override
    public boolean replace(Buffer oldBuffer, Buffer newBuffer) {
        if (newBuffer == this) {
            throw new IllegalArgumentException("CompositeBuffer can not append itself");
        }
        for (int i = 0; i < this.buffersSize; ++i) {
            Buffer b = this.buffers[i];
            if (b == oldBuffer) {
                this.buffers[i] = newBuffer;
                this.calcCapacity();
                this.limit = this.capacity;
                if (this.position > this.limit) {
                    this.position = this.limit;
                }
                this.resetLastLocation();
                return true;
            }
            if (b.isComposite() && ((CompositeBuffer)b).replace(oldBuffer, newBuffer)) break;
        }
        return false;
    }

    private void ensureBuffersCapacity(int newElementsNum) {
        int newSize = this.buffersSize + newElementsNum;
        if (newSize > this.buffers.length) {
            int newCapacity = Math.max(newSize, this.buffers.length * 3 / 2 + 1);
            this.buffers = Arrays.copyOf(this.buffers, newCapacity);
            this.bufferBounds = Arrays.copyOf(this.bufferBounds, newCapacity);
        }
    }

    public Buffer[] underlying() {
        this.checkDispose();
        return this.buffers;
    }

    @Override
    public int position() {
        this.checkDispose();
        return this.position;
    }

    @Override
    public BuffersBuffer position(int newPosition) {
        this.checkDispose();
        this.setPosLim(newPosition, this.limit);
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public int limit() {
        this.checkDispose();
        return this.limit;
    }

    @Override
    public BuffersBuffer limit(int newLimit) {
        this.checkDispose();
        this.setPosLim(this.position <= newLimit ? this.position : newLimit, newLimit);
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public int capacity() {
        this.checkDispose();
        return this.capacity;
    }

    @Override
    public BuffersBuffer mark() {
        this.mark = this.position;
        return this;
    }

    @Override
    public BuffersBuffer reset() {
        int m = this.mark;
        if (m < 0) {
            throw new InvalidMarkException();
        }
        this.position = m;
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.buffers[0].isDirect();
    }

    @Override
    public BuffersBuffer clear() {
        this.checkDispose();
        this.calcCapacity();
        this.setPosLim(0, this.capacity);
        this.mark = -1;
        return this;
    }

    @Override
    public BuffersBuffer flip() {
        this.checkDispose();
        this.setPosLim(0, this.position);
        this.mark = -1;
        return this;
    }

    @Override
    public BuffersBuffer rewind() {
        this.checkDispose();
        this.setPosLim(0, this.limit);
        this.mark = -1;
        return this;
    }

    @Override
    public int remaining() {
        this.checkDispose();
        return this.limit - this.position;
    }

    @Override
    public boolean hasRemaining() {
        this.checkDispose();
        return this.limit > this.position;
    }

    @Override
    public boolean isReadOnly() {
        this.checkDispose();
        return this.isReadOnly;
    }

    @Override
    public BuffersBuffer asReadOnlyBuffer() {
        this.checkDispose();
        BuffersBuffer buffer = BuffersBuffer.create().duplicateFrom(this);
        buffer.isReadOnly = true;
        return buffer;
    }

    @Override
    public Buffer split(int splitPosition) {
        this.checkDispose();
        int oldPosition = this.position;
        int oldLimit = this.limit;
        if (splitPosition == this.capacity) {
            return Buffers.EMPTY_BUFFER;
        }
        if (splitPosition == 0) {
            BuffersBuffer slice2Buffer = BuffersBuffer.create(this.memoryManager, this.buffers, this.buffersSize, this.isReadOnly);
            slice2Buffer.setPosLim(this.position, this.limit);
            this.initBuffers(null, 0);
            this.position = 0;
            this.limit = 0;
            this.capacity = 0;
            this.resetLastLocation();
            return slice2Buffer;
        }
        this.checkIndex(splitPosition);
        int splitBufferIdx = this.lastSegmentIndex;
        int splitBufferPos = this.toActiveBufferPos(splitPosition);
        BuffersBuffer slice2Buffer = BuffersBuffer.create(this.memoryManager);
        Buffer splitBuffer = this.activeBuffer;
        int newSize = splitBufferIdx + 1;
        if (splitBufferPos == 0) {
            slice2Buffer.append(splitBuffer);
            this.buffers[splitBufferIdx] = null;
            newSize = splitBufferIdx;
        } else if (splitBufferPos < splitBuffer.limit()) {
            Buffer splitBuffer2 = splitBuffer.split(splitBufferPos);
            slice2Buffer.append(splitBuffer2);
        }
        for (int i = splitBufferIdx + 1; i < this.buffersSize; ++i) {
            slice2Buffer.append(this.buffers[i]);
            this.buffers[i] = null;
        }
        this.buffersSize = newSize;
        this.calcCapacity();
        if (oldPosition < splitPosition) {
            this.position = oldPosition;
        } else {
            this.position = this.capacity;
            slice2Buffer.position(oldPosition - splitPosition);
        }
        if (oldLimit < splitPosition) {
            this.limit = oldLimit;
            slice2Buffer.limit(0);
        } else {
            slice2Buffer.limit(oldLimit - splitPosition);
            this.limit = this.capacity;
        }
        this.resetLastLocation();
        return slice2Buffer;
    }

    @Override
    public void shrink() {
        this.checkDispose();
        if (this.position == this.limit) {
            this.removeAndDisposeBuffers();
            return;
        }
        this.checkIndex(this.position);
        int posBufferIndex = this.lastSegmentIndex;
        int posBufferPosition = this.toActiveBufferPos(this.position);
        this.checkIndex(this.limit - 1);
        int limitBufferIndex = this.lastSegmentIndex;
        int rightTrim = this.buffersSize - limitBufferIndex - 1;
        int shift = 0;
        for (int i = 0; i < posBufferIndex; ++i) {
            Buffer buffer = this.buffers[i];
            shift += buffer.remaining();
            if (!this.allowInternalBuffersDispose) continue;
            buffer.tryDispose();
        }
        Buffer posBuffer = this.buffers[posBufferIndex];
        int diff = posBufferPosition - posBuffer.position();
        if (diff > 0) {
            posBuffer.position(posBufferPosition);
            posBuffer.shrink();
            shift += diff;
        }
        this.setPosLim(this.position - shift, this.limit - shift);
        if (this.mark > this.position) {
            this.mark = -1;
        }
        for (int i = 0; i < rightTrim; ++i) {
            int idx = this.buffersSize - i - 1;
            Buffer buffer = this.buffers[idx];
            this.buffers[idx] = null;
            if (!this.allowInternalBuffersDispose) continue;
            buffer.tryDispose();
        }
        this.buffersSize -= posBufferIndex + rightTrim;
        if (posBufferIndex > 0) {
            System.arraycopy(this.buffers, posBufferIndex, this.buffers, 0, this.buffersSize);
            Arrays.fill(this.buffers, this.buffersSize, this.buffersSize + posBufferIndex, null);
        }
        this.calcCapacity();
        this.resetLastLocation();
    }

    @Override
    public void trim() {
        this.flip();
        if (this.limit == 0) {
            this.removeRightBuffers(0);
            this.capacity = 0;
        } else {
            this.checkIndex(this.limit - 1);
            this.capacity -= this.removeRightBuffers(this.lastSegmentIndex + 1);
        }
        this.resetLastLocation();
    }

    protected int removeRightBuffers(int startIndex) {
        int removedBytes = 0;
        for (int i = startIndex; i < this.buffersSize; ++i) {
            Buffer buffer = this.buffers[i];
            this.buffers[i] = null;
            removedBytes += buffer.remaining();
            if (!this.allowInternalBuffersDispose) continue;
            buffer.tryDispose();
        }
        this.buffersSize = startIndex;
        return removedBytes;
    }

    @Override
    public Buffer slice() {
        return this.slice(this.position, this.limit);
    }

    @Override
    public Buffer slice(int position, int limit) {
        this.checkDispose();
        if (this.buffersSize == 0 || position == limit) {
            return Buffers.EMPTY_BUFFER;
        }
        if (this.buffersSize == 1) {
            return this.buffers[0].slice(position, limit);
        }
        this.checkIndex(position);
        int posBufferIndex = this.lastSegmentIndex;
        int posBufferPosition = this.toActiveBufferPos(position);
        this.checkIndex(limit - 1);
        int limitBufferIndex = this.lastSegmentIndex;
        int limitBufferPosition = this.toActiveBufferPos(limit);
        if (posBufferIndex == limitBufferIndex) {
            return this.buffers[posBufferIndex].slice(posBufferPosition, limitBufferPosition);
        }
        Buffer[] newList = new Buffer[limitBufferIndex - posBufferIndex + 1];
        Buffer posBuffer = this.buffers[posBufferIndex];
        newList[0] = posBuffer.slice(posBufferPosition, posBuffer.limit());
        int index = 1;
        for (int i = posBufferIndex + 1; i < limitBufferIndex; ++i) {
            newList[index++] = this.buffers[i].slice();
        }
        Buffer limitBuffer = this.buffers[limitBufferIndex];
        newList[index] = limitBuffer.slice(limitBuffer.position(), limitBufferPosition);
        return BuffersBuffer.create(this.memoryManager, newList, newList.length, this.isReadOnly);
    }

    @Override
    public BuffersBuffer duplicate() {
        this.checkDispose();
        return BuffersBuffer.create().duplicateFrom(this);
    }

    @Override
    public BuffersBuffer compact() {
        this.checkDispose();
        if (this.buffersSize == 0) {
            return this;
        }
        if (this.buffersSize == 1) {
            Buffer buffer = this.buffers[0];
            Buffers.setPositionLimit(buffer, buffer.position() + this.position, buffer.position() + this.limit);
            buffer.compact();
        } else {
            this.checkIndex(this.position);
            int posBufferIndex = this.lastSegmentIndex;
            this.activeBuffer.position(this.toActiveBufferPos(this.position));
            this.checkIndex(this.limit - 1);
            int limitBufferIndex = this.lastSegmentIndex;
            this.activeBuffer.limit(this.toActiveBufferPos(this.limit));
            for (int i = posBufferIndex; i <= limitBufferIndex; ++i) {
                Buffer b1 = this.buffers[i - posBufferIndex];
                this.buffers[i - posBufferIndex] = this.buffers[i];
                this.buffers[i] = b1;
            }
        }
        this.setPosLim(0, this.position);
        this.calcCapacity();
        this.resetLastLocation();
        return this;
    }

    @Override
    public ByteOrder order() {
        this.checkDispose();
        return this.byteOrder;
    }

    @Override
    public BuffersBuffer order(ByteOrder bo) {
        this.checkDispose();
        this.byteOrder = bo;
        if (this.byteOrder != ByteOrder.BIG_ENDIAN) {
            this.bigEndian = false;
        }
        return this;
    }

    @Override
    public boolean allowBufferDispose() {
        return this.allowBufferDispose;
    }

    @Override
    public void allowBufferDispose(boolean allow) {
        this.allowBufferDispose = allow;
    }

    @Override
    public boolean allowInternalBuffersDispose() {
        return this.allowInternalBuffersDispose;
    }

    @Override
    public void allowInternalBuffersDispose(boolean allowInternalBuffersDispose) {
        this.allowInternalBuffersDispose = allowInternalBuffersDispose;
    }

    @Override
    public byte get() {
        return this.get(this.position++);
    }

    @Override
    public BuffersBuffer put(byte b) {
        return this.put(this.position++, b);
    }

    @Override
    public byte get(int index) {
        this.checkDispose();
        this.checkIndex(index);
        return this.activeBuffer.get(this.toActiveBufferPos(index));
    }

    @Override
    public BuffersBuffer put(int index, byte b) {
        this.checkDispose();
        this.checkReadOnly();
        this.checkIndex(index);
        this.activeBuffer.put(this.toActiveBufferPos(index), b);
        return this;
    }

    private void checkIndex(int index) {
        if (index >= this.lowerBound & index < this.upperBound) {
            return;
        }
        this.recalcIndex(index);
    }

    private void recalcIndex(int index) {
        int idx = index < this.bufferBounds[0] ? 0 : ArrayUtils.binarySearch(this.bufferBounds, 0, this.buffersSize - 1, index + 1);
        this.activeBuffer = this.buffers[idx];
        this.upperBound = this.bufferBounds[idx];
        this.lowerBound = this.upperBound - this.activeBuffer.remaining();
        this.lastSegmentIndex = idx;
        this.activeBufferLowerBound = this.lowerBound - this.activeBuffer.position();
    }

    private int toActiveBufferPos(int index) {
        return index - this.activeBufferLowerBound;
    }

    @Override
    public BuffersBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public BuffersBuffer get(byte[] dst, int offset, int length) {
        this.checkDispose();
        if (length == 0) {
            return this;
        }
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
        this.checkIndex(this.position);
        int bufferIdx = this.lastSegmentIndex;
        Buffer buffer = this.activeBuffer;
        int bufferPosition = this.toActiveBufferPos(this.position);
        while (true) {
            int oldPos = buffer.position();
            buffer.position(bufferPosition);
            int bytesToCopy = Math.min(buffer.remaining(), length);
            buffer.get(dst, offset, bytesToCopy);
            buffer.position(oldPos);
            offset += bytesToCopy;
            this.position += bytesToCopy;
            if ((length -= bytesToCopy) == 0) break;
            buffer = this.buffers[++bufferIdx];
            bufferPosition = buffer.position();
        }
        return this;
    }

    @Override
    public BuffersBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public BuffersBuffer put(byte[] src, int offset, int length) {
        this.checkDispose();
        this.checkReadOnly();
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        this.checkIndex(this.position);
        int bufferIdx = this.lastSegmentIndex;
        Buffer buffer = this.activeBuffer;
        int bufferPosition = this.toActiveBufferPos(this.position);
        while (true) {
            int oldPos = buffer.position();
            buffer.position(bufferPosition);
            int bytesToCopy = Math.min(buffer.remaining(), length);
            buffer.put(src, offset, bytesToCopy);
            buffer.position(oldPos);
            offset += bytesToCopy;
            this.position += bytesToCopy;
            if ((length -= bytesToCopy) == 0) break;
            buffer = this.buffers[++bufferIdx];
            bufferPosition = buffer.position();
        }
        return this;
    }

    @Override
    public BuffersBuffer put8BitString(String s) {
        int len = s.length();
        if (this.remaining() < len) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < len; ++i) {
            this.put((byte)s.charAt(i));
        }
        return this;
    }

    @Override
    public BuffersBuffer get(ByteBuffer dst) {
        this.get(dst, dst.position(), dst.remaining());
        dst.position(dst.limit());
        return this;
    }

    @Override
    public BuffersBuffer get(ByteBuffer dst, int offset, int length) {
        if (length == 0) {
            return this;
        }
        this.checkDispose();
        this.checkReadOnly();
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        this.checkIndex(this.position);
        int bufferIdx = this.lastSegmentIndex;
        Buffer buffer = this.activeBuffer;
        int bufferPosition = this.toActiveBufferPos(this.position);
        while (true) {
            int oldPos = buffer.position();
            buffer.position(bufferPosition);
            int bytesToCopy = Math.min(buffer.remaining(), length);
            buffer.get(dst, offset, bytesToCopy);
            buffer.position(oldPos);
            offset += bytesToCopy;
            this.position += bytesToCopy;
            if ((length -= bytesToCopy) == 0) break;
            buffer = this.buffers[++bufferIdx];
            bufferPosition = buffer.position();
        }
        return this;
    }

    @Override
    public BuffersBuffer put(ByteBuffer src) {
        this.put(src, 0, src.remaining());
        src.position(src.limit());
        return this;
    }

    @Override
    public BuffersBuffer put(ByteBuffer src, int offset, int length) {
        this.checkDispose();
        this.checkReadOnly();
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        this.checkIndex(this.position);
        int bufferIdx = this.lastSegmentIndex;
        Buffer buffer = this.activeBuffer;
        int bufferPosition = this.toActiveBufferPos(this.position);
        while (true) {
            int oldPos = buffer.position();
            buffer.position(bufferPosition);
            int bytesToCopy = Math.min(buffer.remaining(), length);
            buffer.put(src, offset, bytesToCopy);
            buffer.position(oldPos);
            offset += bytesToCopy;
            this.position += bytesToCopy;
            if ((length -= bytesToCopy) == 0) break;
            buffer = this.buffers[++bufferIdx];
            bufferPosition = buffer.position();
        }
        return this;
    }

    @Override
    public BuffersBuffer put(Buffer src) {
        this.put(src, src.position(), src.remaining());
        src.position(src.limit());
        return this;
    }

    @Override
    public Buffer put(Buffer src, int position, int length) {
        this.checkDispose();
        this.checkReadOnly();
        Buffers.put(src, position, length, this);
        return this;
    }

    @Override
    public char getChar() {
        char value = this.getChar(this.position);
        this.position += 2;
        return value;
    }

    @Override
    public BuffersBuffer putChar(char value) {
        this.putChar(this.position, value);
        this.position += 2;
        return this;
    }

    @Override
    public char getChar(int index) {
        this.checkDispose();
        this.checkIndex(index);
        if (this.upperBound - index >= 2) {
            return this.activeBuffer.getChar(this.toActiveBufferPos(index));
        }
        return this.bigEndian ? this.makeCharB(index) : this.makeCharL(index);
    }

    @Override
    public BuffersBuffer putChar(int index, char value) {
        this.checkDispose();
        this.checkReadOnly();
        this.checkIndex(index);
        if (this.upperBound - index >= 2) {
            this.activeBuffer.putChar(this.toActiveBufferPos(index), value);
        } else if (this.bigEndian) {
            this.putCharB(index, value);
        } else {
            this.putCharL(index, value);
        }
        return this;
    }

    @Override
    public short getShort() {
        short value = this.getShort(this.position);
        this.position += 2;
        return value;
    }

    @Override
    public BuffersBuffer putShort(short value) {
        this.putShort(this.position, value);
        this.position += 2;
        return this;
    }

    @Override
    public short getShort(int index) {
        this.checkDispose();
        this.checkIndex(index);
        if (this.upperBound - index >= 2) {
            return this.activeBuffer.getShort(this.toActiveBufferPos(index));
        }
        return this.bigEndian ? this.makeShortB(index) : this.makeShortL(index);
    }

    @Override
    public BuffersBuffer putShort(int index, short value) {
        this.checkDispose();
        this.checkReadOnly();
        this.checkIndex(index);
        if (this.upperBound - index >= 2) {
            this.activeBuffer.putShort(this.toActiveBufferPos(index), value);
        } else if (this.bigEndian) {
            this.putShortB(index, value);
        } else {
            this.putShortL(index, value);
        }
        return this;
    }

    @Override
    public int getInt() {
        int value = this.getInt(this.position);
        this.position += 4;
        return value;
    }

    @Override
    public BuffersBuffer putInt(int value) {
        this.putInt(this.position, value);
        this.position += 4;
        return this;
    }

    @Override
    public int getInt(int index) {
        this.checkDispose();
        this.checkIndex(index);
        if (this.upperBound - index >= 4) {
            return this.activeBuffer.getInt(this.toActiveBufferPos(index));
        }
        return this.bigEndian ? this.makeIntB(index) : this.makeIntL(index);
    }

    @Override
    public BuffersBuffer putInt(int index, int value) {
        this.checkDispose();
        this.checkReadOnly();
        this.checkIndex(index);
        if (this.upperBound - index >= 4) {
            this.activeBuffer.putInt(this.toActiveBufferPos(index), value);
        } else if (this.bigEndian) {
            this.putIntB(index, value);
        } else {
            this.putIntL(index, value);
        }
        return this;
    }

    @Override
    public long getLong() {
        long value = this.getLong(this.position);
        this.position += 8;
        return value;
    }

    @Override
    public BuffersBuffer putLong(long value) {
        this.putLong(this.position, value);
        this.position += 8;
        return this;
    }

    @Override
    public long getLong(int index) {
        this.checkDispose();
        this.checkIndex(index);
        if (this.upperBound - index >= 8) {
            return this.activeBuffer.getLong(this.toActiveBufferPos(index));
        }
        return this.bigEndian ? this.makeLongB(index) : this.makeLongL(index);
    }

    @Override
    public BuffersBuffer putLong(int index, long value) {
        this.checkDispose();
        this.checkReadOnly();
        this.checkIndex(index);
        if (this.upperBound - index >= 8) {
            this.activeBuffer.putLong(this.toActiveBufferPos(index), value);
        } else if (this.bigEndian) {
            this.putLongB(index, value);
        } else {
            this.putLongL(index, value);
        }
        return this;
    }

    @Override
    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public BuffersBuffer putFloat(float value) {
        return this.putInt(Float.floatToIntBits(value));
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public BuffersBuffer putFloat(int index, float value) {
        return this.putInt(index, Float.floatToIntBits(value));
    }

    @Override
    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public BuffersBuffer putDouble(double value) {
        return this.putLong(Double.doubleToLongBits(value));
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public BuffersBuffer putDouble(int index, double value) {
        return this.putLong(index, Double.doubleToLongBits(value));
    }

    @Override
    public int bulk(CompositeBuffer.BulkOperation operation) {
        return this.bulk(operation, this.position, this.limit);
    }

    @Override
    public int bulk(CompositeBuffer.BulkOperation operation, int position, int limit) {
        this.checkDispose();
        int length = limit - position;
        if (length == 0) {
            return -1;
        }
        int offset = position;
        this.checkIndex(position);
        int bufferIdx = this.lastSegmentIndex;
        Buffer buffer = this.activeBuffer;
        int bufferPosition = this.toActiveBufferPos(position);
        while (true) {
            int bytesToProcess = Math.min(buffer.limit() - bufferPosition, length);
            if (buffer.isComposite()) {
                int findPos = ((CompositeBuffer)buffer).bulk(operation, bufferPosition, bufferPosition + bytesToProcess);
                if (findPos != -1) {
                    return offset + (findPos - bufferPosition);
                }
            } else {
                this.setter.buffer = buffer;
                for (int i = bufferPosition; i < bufferPosition + bytesToProcess; ++i) {
                    this.setter.position = i;
                    if (!operation.processByte(buffer.get(i), this.setter)) continue;
                    return offset + (i - bufferPosition);
                }
            }
            if ((length -= bytesToProcess) == 0) {
                return -1;
            }
            offset += bytesToProcess;
            buffer = this.buffers[++bufferIdx];
            bufferPosition = buffer.position();
        }
    }

    @Override
    public int compareTo(Buffer that) {
        this.checkDispose();
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BuffersBuffer (" + System.identityHashCode(this) + ") [");
        sb.append("pos=").append(this.position);
        sb.append(" lim=").append(this.limit);
        sb.append(" cap=").append(this.capacity);
        sb.append(" bufferSize=").append(this.buffersSize);
        sb.append(" buffers=").append(Arrays.toString(this.buffers));
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String toStringContent() {
        return this.toStringContent(null, this.position, this.limit);
    }

    @Override
    public String toStringContent(Charset charset) {
        return this.toStringContent(charset, this.position, this.limit);
    }

    @Override
    public String toStringContent(Charset charset, int position, int limit) {
        this.checkDispose();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        byte[] tmpBuffer = new byte[limit - position];
        int oldPosition = this.position;
        int oldLimit = this.limit;
        this.setPosLim(position, limit);
        this.get(tmpBuffer);
        this.setPosLim(oldPosition, oldLimit);
        try {
            return new String(tmpBuffer, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("We took charset name from Charset, why it's not unsupported?", e);
        }
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(this.position, this.limit);
    }

    @Override
    public ByteBuffer toByteBuffer(int position, int limit) {
        if (position < 0 || position > this.capacity || limit < 0 || limit > this.capacity) {
            throw new IndexOutOfBoundsException("position=" + position + " limit=" + limit + "on " + this.toString());
        }
        if (this.buffersSize == 0 || position == limit) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        if (this.buffersSize == 1) {
            Buffer buffer = this.buffers[0];
            int bufferPos = buffer.position();
            return buffer.toByteBuffer(bufferPos + position, bufferPos + limit);
        }
        this.checkIndex(position);
        int pos1 = this.lastSegmentIndex;
        int bufPosition = this.toActiveBufferPos(position);
        this.checkIndex(limit - 1);
        int pos2 = this.lastSegmentIndex;
        int bufLimit = this.toActiveBufferPos(limit);
        if (pos1 == pos2) {
            Buffer buffer = this.buffers[pos1];
            return buffer.toByteBuffer(bufPosition, bufLimit);
        }
        ByteBuffer resultByteBuffer = MemoryUtils.allocateByteBuffer(this.memoryManager, limit - position);
        Buffer startBuffer = this.buffers[pos1];
        ByteBufferArray array = ByteBufferArray.create();
        this.fillByteBuffer(resultByteBuffer, startBuffer.toByteBufferArray(array, bufPosition, startBuffer.limit()));
        for (int i = pos1 + 1; i < pos2; ++i) {
            this.fillByteBuffer(resultByteBuffer, this.buffers[i].toByteBufferArray(array));
        }
        Buffer endBuffer = this.buffers[pos2];
        this.fillByteBuffer(resultByteBuffer, endBuffer.toByteBufferArray(array, endBuffer.position(), bufLimit));
        array.restore();
        array.recycle();
        return (ByteBuffer)resultByteBuffer.flip();
    }

    @Override
    public final ByteBufferArray toByteBufferArray() {
        return this.toByteBufferArray(this.position, this.limit);
    }

    @Override
    public final ByteBufferArray toByteBufferArray(ByteBufferArray array) {
        if (this.position == 0 && this.limit == this.capacity) {
            for (int i = 0; i < this.buffersSize; ++i) {
                this.buffers[i].toByteBufferArray(array);
            }
            return array;
        }
        return this.toByteBufferArray(array, this.position, this.limit);
    }

    @Override
    public final ByteBufferArray toByteBufferArray(int position, int limit) {
        ByteBufferArray array = ByteBufferArray.create();
        if (position == 0 && limit == this.capacity) {
            for (int i = 0; i < this.buffersSize; ++i) {
                this.buffers[i].toByteBufferArray(array);
            }
            return array;
        }
        return this.toByteBufferArray(array, position, limit);
    }

    @Override
    public final ByteBufferArray toByteBufferArray(ByteBufferArray array, int position, int limit) {
        if (position < 0 || position > this.capacity || limit < 0 || limit > this.capacity) {
            throw new IndexOutOfBoundsException("position=" + position + " limit=" + limit + "on " + this.toString());
        }
        if (this.buffersSize == 0 || position == limit) {
            return array;
        }
        if (this.buffersSize == 1) {
            Buffer b = this.buffers[0];
            int startPos = b.position();
            return b.toByteBufferArray(array, position + startPos, limit + startPos);
        }
        if (position == 0 && limit == this.capacity) {
            for (int i = 0; i < this.buffersSize; ++i) {
                this.buffers[i].toByteBufferArray(array);
            }
            return array;
        }
        this.checkIndex(position);
        int pos1 = this.lastSegmentIndex;
        int bufPosition = this.toActiveBufferPos(position);
        this.checkIndex(limit - 1);
        int pos2 = this.lastSegmentIndex;
        int bufLimit = this.toActiveBufferPos(limit);
        if (pos1 == pos2) {
            Buffer buffer = this.buffers[pos1];
            return buffer.toByteBufferArray(array, bufPosition, bufLimit);
        }
        Buffer startBuffer = this.buffers[pos1];
        startBuffer.toByteBufferArray(array, bufPosition, startBuffer.limit());
        for (int i = pos1 + 1; i < pos2; ++i) {
            Buffer srcBuffer = this.buffers[i];
            srcBuffer.toByteBufferArray(array);
        }
        Buffer endBuffer = this.buffers[pos2];
        endBuffer.toByteBufferArray(array, endBuffer.position(), bufLimit);
        return array;
    }

    @Override
    public final BufferArray toBufferArray() {
        return this.toBufferArray(this.position, this.limit);
    }

    @Override
    public final BufferArray toBufferArray(BufferArray array) {
        if (this.position == 0 && this.limit == this.capacity) {
            for (int i = 0; i < this.buffersSize; ++i) {
                this.buffers[i].toBufferArray(array);
            }
            return array;
        }
        return this.toBufferArray(array, this.position, this.limit);
    }

    @Override
    public final BufferArray toBufferArray(int position, int limit) {
        BufferArray array = BufferArray.create();
        if (position == 0 && limit == this.capacity) {
            for (int i = 0; i < this.buffersSize; ++i) {
                this.buffers[i].toBufferArray(array);
            }
            return array;
        }
        return this.toBufferArray(array, position, limit);
    }

    @Override
    public final BufferArray toBufferArray(BufferArray array, int position, int limit) {
        if (position < 0 || position > this.capacity || limit < 0 || limit > this.capacity) {
            throw new IndexOutOfBoundsException("position=" + position + " limit=" + limit + "on " + this.toString());
        }
        if (this.buffersSize == 0 || position == limit) {
            return array;
        }
        if (this.buffersSize == 1) {
            Buffer b = this.buffers[0];
            int startPos = b.position();
            return b.toBufferArray(array, position + startPos, limit + startPos);
        }
        if (position == 0 && limit == this.capacity) {
            for (int i = 0; i < this.buffersSize; ++i) {
                this.buffers[i].toBufferArray(array);
            }
            return array;
        }
        this.checkIndex(position);
        int pos1 = this.lastSegmentIndex;
        int bufPosition = this.toActiveBufferPos(position);
        this.checkIndex(limit - 1);
        int pos2 = this.lastSegmentIndex;
        int bufLimit = this.toActiveBufferPos(limit);
        if (pos1 == pos2) {
            Buffer buffer = this.buffers[pos1];
            return buffer.toBufferArray(array, bufPosition, bufLimit);
        }
        Buffer startBuffer = this.buffers[pos1];
        startBuffer.toBufferArray(array, bufPosition, startBuffer.limit());
        for (int i = pos1 + 1; i < pos2; ++i) {
            Buffer srcBuffer = this.buffers[i];
            srcBuffer.toBufferArray(array);
        }
        Buffer endBuffer = this.buffers[pos2];
        endBuffer.toBufferArray(array, endBuffer.position(), bufLimit);
        return array;
    }

    @Override
    public void removeAll() {
        this.position = 0;
        this.limit = 0;
        this.capacity = 0;
        Arrays.fill(this.buffers, 0, this.buffersSize, null);
        this.buffersSize = 0;
        this.resetLastLocation();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Buffer) {
            Buffer that = (Buffer)obj;
            if (this.remaining() != that.remaining()) {
                return false;
            }
            int p = this.position();
            int i = this.limit() - 1;
            int j = that.limit() - 1;
            while (i >= p) {
                byte v2;
                byte v1 = this.get(i);
                if (v1 != (v2 = that.get(j))) {
                    return false;
                }
                --i;
                --j;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        h = 31 * h + this.mark;
        return h;
    }

    @Override
    public boolean release() {
        return this.tryDispose();
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    private void fillByteBuffer(ByteBuffer bb, ByteBufferArray array) {
        ByteBuffer[] bbs = (ByteBuffer[])array.getArray();
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            ByteBuffer srcByteBuffer = bbs[i];
            bb.put(srcByteBuffer);
        }
    }

    private void removeAndDisposeBuffers() {
        boolean isNulled = false;
        if (this.allowInternalBuffersDispose) {
            if (this.disposeOrder != CompositeBuffer.DisposeOrder.FIRST_TO_LAST) {
                for (int i = this.buffersSize - 1; i >= 0; --i) {
                    Buffer buffer = this.buffers[i];
                    buffer.tryDispose();
                    this.buffers[i] = null;
                }
            } else {
                for (int i = 0; i < this.buffersSize; ++i) {
                    Buffer buffer = this.buffers[i];
                    buffer.tryDispose();
                    this.buffers[i] = null;
                }
            }
            isNulled = true;
        }
        this.position = 0;
        this.limit = 0;
        this.capacity = 0;
        this.mark = -1;
        if (!isNulled) {
            Arrays.fill(this.buffers, 0, this.buffersSize, null);
        }
        this.buffersSize = 0;
        this.disposeOrder = CompositeBuffer.DisposeOrder.LAST_TO_FIRST;
        this.allowBufferDispose = false;
        this.allowInternalBuffersDispose = true;
        this.resetLastLocation();
    }

    private void setPosLim(int position, int limit) {
        if (position > limit) {
            throw new IllegalArgumentException("Position exceeds a limit: " + position + '>' + limit);
        }
        this.position = position;
        this.limit = limit;
    }

    private void checkDispose() {
        if (this.isDisposed) {
            throw new IllegalStateException("CompositeBuffer has already been disposed", this.disposeStackTrace);
        }
    }

    private void checkReadOnly() {
        if (this.isReadOnly) {
            throw new IllegalStateException("Buffer is in read-only mode");
        }
    }

    private void calcCapacity() {
        int currentCapacity = 0;
        for (int i = 0; i < this.buffersSize; ++i) {
            this.bufferBounds[i] = currentCapacity += this.buffers[i].remaining();
        }
        this.capacity = currentCapacity;
    }

    private void resetLastLocation() {
        this.lowerBound = 0;
        this.upperBound = 0;
        this.activeBuffer = null;
    }

    private long makeLongL(int index) {
        this.checkIndex(index += 7);
        byte b1 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b2 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b3 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b4 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b5 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b6 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b7 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b8 = this.activeBuffer.get(this.toActiveBufferPos(index));
        return Bits.makeLong(b1, b2, b3, b4, b5, b6, b7, b8);
    }

    private long makeLongB(int index) {
        byte b1 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b2 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b3 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b4 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b5 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b6 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b7 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b8 = this.activeBuffer.get(this.toActiveBufferPos(index));
        return Bits.makeLong(b1, b2, b3, b4, b5, b6, b7, b8);
    }

    private void putLongL(int index, long value) {
        this.checkIndex(index += 7);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long7(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long6(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long5(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long4(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long3(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long2(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long1(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long0(value));
    }

    private void putLongB(int index, long value) {
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long7(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long6(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long5(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long4(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long3(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long2(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long1(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.long0(value));
    }

    private void putIntL(int index, int value) {
        this.checkIndex(index += 3);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.int3(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.int2(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.int1(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.int0(value));
    }

    private void putIntB(int index, int value) {
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.int3(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.int2(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.int1(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.int0(value));
    }

    private int makeIntL(int index) {
        this.checkIndex(index += 3);
        byte b1 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b2 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b3 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(--index);
        byte b4 = this.activeBuffer.get(this.toActiveBufferPos(index));
        return Bits.makeInt(b1, b2, b3, b4);
    }

    private int makeIntB(int index) {
        byte b1 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b2 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b3 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b4 = this.activeBuffer.get(this.toActiveBufferPos(index));
        return Bits.makeInt(b1, b2, b3, b4);
    }

    private void putShortL(int index, short value) {
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.short0(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.short1(value));
    }

    private void putShortB(int index, short value) {
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.short1(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.short0(value));
    }

    private short makeShortL(int index) {
        byte b2 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b1 = this.activeBuffer.get(this.toActiveBufferPos(index));
        return Bits.makeShort(b2, b1);
    }

    private short makeShortB(int index) {
        byte b1 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b2 = this.activeBuffer.get(this.toActiveBufferPos(index));
        return Bits.makeShort(b1, b2);
    }

    private void putCharL(int index, char value) {
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.char0(value));
        this.checkIndex(--index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.char1(value));
    }

    private void putCharB(int index, char value) {
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.char1(value));
        this.checkIndex(++index);
        this.activeBuffer.put(this.toActiveBufferPos(index), Bits.char0(value));
    }

    private char makeCharL(int index) {
        byte b2 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b1 = this.activeBuffer.get(this.toActiveBufferPos(index));
        return Bits.makeChar(b2, b1);
    }

    private char makeCharB(int index) {
        byte b1 = this.activeBuffer.get(this.toActiveBufferPos(index));
        this.checkIndex(++index);
        byte b2 = this.activeBuffer.get(this.toActiveBufferPos(index));
        return Bits.makeChar(b1, b2);
    }

    private static class DebugLogic {
        private DebugLogic() {
        }

        static void doDebug(BuffersBuffer buffersBuffer) {
            buffersBuffer.disposeStackTrace = new Exception("BuffersBuffer was disposed from: ");
        }
    }

    private static final class SetterImpl
    implements CompositeBuffer.Setter {
        private Buffer buffer;
        private int position;

        private SetterImpl() {
        }

        @Override
        public void set(byte value) {
            this.buffer.put(this.position, value);
        }
    }
}

