/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client.auth;

import org.glassfish.tyrus.client.auth.AuthConfig;
import org.glassfish.tyrus.core.Beta;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;

@Beta
public final class Credentials {
    private final String username;
    private final byte[] password;

    public Credentials(String username, byte[] password) {
        if (username == null) {
            throw new IllegalArgumentException(LocalizationMessages.ARGUMENT_NOT_NULL("username"));
        }
        if (password == null) {
            throw new IllegalArgumentException(LocalizationMessages.ARGUMENT_NOT_NULL("password"));
        }
        this.username = username;
        this.password = password;
    }

    public Credentials(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException(LocalizationMessages.ARGUMENT_NOT_NULL("username"));
        }
        if (password == null) {
            throw new IllegalArgumentException(LocalizationMessages.ARGUMENT_NOT_NULL("password"));
        }
        this.username = username;
        this.password = password.getBytes(AuthConfig.CHARACTER_SET);
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getPassword() {
        return this.password;
    }
}

