/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core.extension;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.websocket.Extension;
import org.glassfish.tyrus.core.ExtendedExtension;
import org.glassfish.tyrus.core.Frame;

public class PerMessageDeflateExtension
implements ExtendedExtension {
    private static final Pool<byte[]> BYTE_ARRAY_POOL = new Pool<byte[]>(){

        @Override
        byte[] create() {
            return new byte[8192];
        }
    };
    private static final String INFLATER = PerMessageDeflateExtension.class.getName() + ".INFLATER";
    private static final String DEFLATER = PerMessageDeflateExtension.class.getName() + ".DEFLATER";
    private static final Logger LOGGER = Logger.getLogger(PerMessageDeflateExtension.class.getName());
    private static final boolean DEBUG = LOGGER.isLoggable(Level.FINE);
    private static final byte[] TAIL = new byte[]{0, 0, -1, -1};

    @Override
    public Frame processIncoming(ExtendedExtension.ExtensionContext context, Frame frame) {
        Inflater decompresser = (Inflater)context.getProperties().get(INFLATER);
        if (DEBUG) {
            LOGGER.fine("Incoming frame: " + frame);
        }
        if (frame.isRsv1() && !frame.isControlFrame()) {
            int payloadLength = (int)frame.getPayloadLength();
            ArrayList<PartialResultWithLength<byte[]>> wholeResult = new ArrayList<PartialResultWithLength<byte[]>>();
            int wholeResultLength = 0;
            int tmp = this.processCompressed(decompresser, frame.getPayloadData(), payloadLength, wholeResult);
            if (tmp == -1) {
                return frame;
            }
            wholeResultLength += tmp;
            tmp = this.processCompressed(decompresser, TAIL, 4, wholeResult);
            if (tmp == -1) {
                return frame;
            }
            byte[] completeResult = new byte[wholeResultLength += tmp];
            wholeResultLength = 0;
            for (PartialResultWithLength partialResultWithLength : wholeResult) {
                tmp = partialResultWithLength.getLength();
                byte[] result = (byte[])partialResultWithLength.getResult();
                System.arraycopy(result, 0, completeResult, wholeResultLength, tmp);
                BYTE_ARRAY_POOL.recycle(result);
                wholeResultLength += tmp;
            }
            return Frame.builder(frame).payloadData(completeResult).rsv1(false).build();
        }
        return frame;
    }

    private int processCompressed(Inflater decompresser, byte[] compressed, int length, List<PartialResultWithLength<byte[]>> partialResults) {
        decompresser.setInput(compressed, 0, length);
        int decompressedLength = 0;
        do {
            int partialResultLength;
            byte[] result = BYTE_ARRAY_POOL.take();
            try {
                partialResultLength = decompresser.inflate(result);
            }
            catch (DataFormatException e) {
                LOGGER.log(Level.INFO, e.getMessage(), e);
                return -1;
            }
            if (partialResultLength != 0) {
                partialResults.add(new PartialResultWithLength(partialResultLength, result));
                decompressedLength += partialResultLength;
                continue;
            }
            BYTE_ARRAY_POOL.recycle(result);
        } while (decompresser.getRemaining() > 0);
        return decompressedLength;
    }

    @Override
    public Frame processOutgoing(ExtendedExtension.ExtensionContext context, Frame frame) {
        Deflater compresser = (Deflater)context.getProperties().get(DEFLATER);
        if (DEBUG) {
            LOGGER.fine("Outgoing frame: " + frame);
        }
        if (!frame.isControlFrame()) {
            int compressedDataLength;
            ArrayList wholeResult = new ArrayList();
            int wholeResultLength = 0;
            int payloadLength = (int)frame.getPayloadLength();
            compresser.setInput(frame.getPayloadData(), 0, payloadLength);
            do {
                byte[] output;
                if ((compressedDataLength = compresser.deflate(output = BYTE_ARRAY_POOL.take(), 0, output.length, 2)) > 0) {
                    wholeResult.add(new PartialResultWithLength(compressedDataLength, output));
                    wholeResultLength += compressedDataLength;
                    continue;
                }
                BYTE_ARRAY_POOL.recycle(output);
            } while (compressedDataLength > 0);
            byte[] completeResult = new byte[wholeResultLength];
            wholeResultLength = 0;
            for (PartialResultWithLength partialResultWithLength : wholeResult) {
                int tmp = partialResultWithLength.getLength();
                byte[] result = (byte[])partialResultWithLength.getResult();
                System.arraycopy(result, 0, completeResult, wholeResultLength, tmp);
                BYTE_ARRAY_POOL.recycle(result);
                wholeResultLength += tmp;
            }
            boolean strip = false;
            if (completeResult[completeResult.length - 4] == TAIL[0] && completeResult[completeResult.length - 3] == TAIL[1] && completeResult[completeResult.length - 2] == TAIL[2] && completeResult[completeResult.length - 1] == TAIL[3]) {
                strip = true;
            }
            return Frame.builder(frame).payloadData(completeResult).payloadLength(strip ? (long)(completeResult.length - 4) : (long)completeResult.length).rsv1(true).build();
        }
        return frame;
    }

    private void init(ExtendedExtension.ExtensionContext context) {
        Deflater compresser = new Deflater(9, true);
        Inflater decompresser = new Inflater(true);
        compresser.setStrategy(0);
        context.getProperties().put(INFLATER, decompresser);
        context.getProperties().put(DEFLATER, compresser);
    }

    @Override
    public List<Extension.Parameter> onExtensionNegotiation(ExtendedExtension.ExtensionContext context, List<Extension.Parameter> requestedParameters) {
        this.init(context);
        return Collections.emptyList();
    }

    @Override
    public void onHandshakeResponse(ExtendedExtension.ExtensionContext context, List<Extension.Parameter> responseParameters) {
        this.init(context);
    }

    @Override
    public void destroy(ExtendedExtension.ExtensionContext context) {
        Inflater decompresser = (Inflater)context.getProperties().get(INFLATER);
        Deflater compresser = (Deflater)context.getProperties().get(DEFLATER);
        context.getProperties().remove(DEFLATER);
        context.getProperties().remove(INFLATER);
        if (decompresser != null) {
            decompresser.end();
        }
        if (compresser != null) {
            compresser.end();
        }
    }

    @Override
    public String getName() {
        return "permessage-deflate";
    }

    @Override
    public List<Extension.Parameter> getParameters() {
        return Collections.emptyList();
    }

    private static class PartialResultWithLength<T> {
        private final int length;
        private final T result;

        private PartialResultWithLength(int length, T result) {
            this.length = length;
            this.result = result;
        }

        public int getLength() {
            return this.length;
        }

        public T getResult() {
            return this.result;
        }
    }

    private static abstract class Pool<T> {
        private volatile WeakReference<ConcurrentLinkedQueue<T>> queue;

        private Pool() {
        }

        public final T take() {
            T t = this.getQueue().poll();
            if (t == null) {
                return this.create();
            }
            return t;
        }

        abstract T create();

        private ConcurrentLinkedQueue<T> getQueue() {
            ConcurrentLinkedQueue d;
            WeakReference<ConcurrentLinkedQueue<T>> q = this.queue;
            if (q != null && (d = (ConcurrentLinkedQueue)q.get()) != null) {
                return d;
            }
            d = new ConcurrentLinkedQueue();
            this.queue = new WeakReference(d);
            return d;
        }

        public final void recycle(T t) {
            this.getQueue().offer(t);
        }
    }
}

