/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusRemoteEndpoint;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;

public class TyrusEndpoint {
    private static final Logger LOGGER = Logger.getLogger(TyrusEndpoint.class.getName());
    private final TyrusEndpointWrapper endpoint;
    private List<Extension> temporaryNegotiatedExtensions = Collections.emptyList();
    private String temporaryNegotiatedProtocol;

    public TyrusEndpoint(TyrusEndpointWrapper endpoint) {
        this.endpoint = endpoint;
    }

    protected boolean isApplicationRequest(UpgradeRequest request) {
        List<String> protocols = request.getHeaders().get("Sec-WebSocket-Protocol");
        this.temporaryNegotiatedProtocol = this.endpoint.getNegotiatedProtocol(protocols);
        List<Extension> extensions = TyrusExtension.fromString(request.getHeaders().get("Sec-WebSocket-Extensions"));
        this.temporaryNegotiatedExtensions = this.endpoint.getNegotiatedExtensions(extensions);
        return this.endpoint.checkHandshake(request);
    }

    public final boolean upgrade(UpgradeRequest request) {
        String upgradeHeader = request.getHeader("Upgrade");
        return request.getHeaders().get("Upgrade") != null && "websocket".equalsIgnoreCase(upgradeHeader) && this.isApplicationRequest(request);
    }

    public String getPath() {
        return this.endpoint.getEndpointPath();
    }

    public TyrusWebSocket createSocket(ProtocolHandler handler) {
        return new TyrusWebSocket(handler, this);
    }

    public void onConnect(TyrusWebSocket socket, UpgradeRequest upgradeRequest) {
        this.endpoint.onConnect(new TyrusRemoteEndpoint(socket), this.temporaryNegotiatedProtocol, this.temporaryNegotiatedExtensions, upgradeRequest);
    }

    public void onFragment(TyrusWebSocket socket, String fragment, boolean last) {
        try {
            this.endpoint.onPartialMessage(new TyrusRemoteEndpoint(socket), fragment, last);
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, t.getMessage(), t);
        }
    }

    public void onFragment(TyrusWebSocket socket, byte[] fragment, boolean last) {
        try {
            this.endpoint.onPartialMessage(new TyrusRemoteEndpoint(socket), ByteBuffer.wrap(fragment), last);
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, t.getMessage(), t);
        }
    }

    public void onMessage(TyrusWebSocket socket, String text) {
        this.endpoint.onMessage(new TyrusRemoteEndpoint(socket), text);
    }

    public void onMessage(TyrusWebSocket socket, byte[] bytes) {
        this.endpoint.onMessage(new TyrusRemoteEndpoint(socket), ByteBuffer.wrap(bytes));
    }

    public void onClose(TyrusWebSocket socket, CloseReason closeReason) {
        this.endpoint.onClose(new TyrusRemoteEndpoint(socket), closeReason);
    }

    public void onPing(TyrusWebSocket socket, byte[] bytes) {
        this.endpoint.onPing(new TyrusRemoteEndpoint(socket), ByteBuffer.wrap(bytes));
    }

    public void onPong(TyrusWebSocket socket, byte[] bytes) {
        this.endpoint.onPong(new TyrusRemoteEndpoint(socket), ByteBuffer.wrap(bytes));
    }

    public List<Extension> getSupportedExtensions() {
        return new ArrayList<Extension>(this.temporaryNegotiatedExtensions);
    }

    public boolean onError(TyrusWebSocket webSocket, Throwable t) {
        Logger.getLogger(TyrusEndpoint.class.getName()).log(Level.WARNING, "Unexpected error, closing connection.", t);
        return true;
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        List<String> result;
        if (this.temporaryNegotiatedProtocol == null || this.temporaryNegotiatedProtocol.isEmpty()) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList<String>();
            result.add(this.temporaryNegotiatedProtocol);
        }
        return result;
    }

    public void onHandShakeResponse(UpgradeRequest request, UpgradeResponse response) {
        EndpointConfig configuration = this.endpoint.getEndpointConfig();
        if (configuration instanceof ServerEndpointConfig) {
            ServerEndpointConfig serverEndpointConfig = (ServerEndpointConfig)configuration;
            serverEndpointConfig.getConfigurator().modifyHandshake(serverEndpointConfig, this.createHandshakeRequest(request), response);
        }
    }

    private HandshakeRequest createHandshakeRequest(UpgradeRequest webSocketRequest) {
        if (webSocketRequest instanceof RequestContext) {
            RequestContext requestContext = (RequestContext)webSocketRequest;
            requestContext.lock();
            return requestContext;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TyrusEndpoint that = (TyrusEndpoint)o;
        if (this.endpoint == null) {
            return super.equals(o);
        }
        return this.endpoint.equals(that.endpoint);
    }

    public int hashCode() {
        if (this.endpoint == null) {
            return super.hashCode();
        }
        return this.endpoint.hashCode();
    }
}

