/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import javax.websocket.CloseReason;
import org.glassfish.tyrus.core.DataFrame;
import org.glassfish.tyrus.core.ProtocolError;
import org.glassfish.tyrus.core.StrictUtf8;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.Utf8DecodingError;
import org.glassfish.tyrus.core.frame.ClosingFrame;

public class ClosingDataFrame
extends DataFrame {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int code = CloseReason.CloseCodes.NORMAL_CLOSURE.getCode();
    private String reason;

    public ClosingDataFrame(int code, String reason) {
        super(new ClosingFrame());
        if (code > 0) {
            this.code = code;
        }
        this.reason = reason;
    }

    public ClosingDataFrame(byte[] data) {
        super(new ClosingFrame());
        this.setPayload(data);
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public void setPayload(byte[] bytes) {
        if (bytes.length == 1) {
            throw new ProtocolError("Closing frame payload, if present, must be a minimum of 2 bytes in length");
        }
        if (bytes.length > 0) {
            this.code = (int)TyrusWebSocketEngine.toLong(bytes, 0, 2);
            if (this.code < 1000 || this.code == 1004 || this.code == 1005 || this.code == 1006 || this.code > 1011 && this.code < 3000 || this.code > 4999) {
                throw new ProtocolError("Illegal status code: " + this.code);
            }
            if (bytes.length > 2) {
                this.utf8Decode(bytes);
            }
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.code == -1) {
            return EMPTY_BYTES;
        }
        byte[] bytes = TyrusWebSocketEngine.toArray(this.code);
        byte[] reasonBytes = this.reason == null ? EMPTY_BYTES : this.reason.getBytes(new StrictUtf8());
        byte[] frameBytes = new byte[2 + reasonBytes.length];
        System.arraycopy(bytes, bytes.length - 2, frameBytes, 0, 2);
        System.arraycopy(reasonBytes, 0, frameBytes, 2, reasonBytes.length);
        return frameBytes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClosingFrame");
        sb.append("{code=").append(this.code);
        sb.append(", reason=").append(this.reason == null ? null : "'" + this.reason + "'");
        sb.append('}');
        return sb.toString();
    }

    private void utf8Decode(byte[] data) {
        CharBuffer cb;
        CharsetDecoder decoder;
        block2: {
            ByteBuffer b = ByteBuffer.wrap(data, 2, data.length - 2);
            StrictUtf8 charset = new StrictUtf8();
            decoder = ((Charset)charset).newDecoder();
            int n = (int)((float)b.remaining() * decoder.averageCharsPerByte());
            cb = CharBuffer.allocate(n);
            while (true) {
                CoderResult result;
                if ((result = decoder.decode(b, cb, true)).isUnderflow()) break block2;
                if (result.isOverflow()) {
                    CharBuffer tmp = CharBuffer.allocate(2 * n + 1);
                    cb.flip();
                    tmp.put(cb);
                    cb = tmp;
                    continue;
                }
                if (result.isError() || result.isMalformed()) break;
            }
            throw new Utf8DecodingError("Illegal UTF-8 Sequence");
        }
        decoder.flush(cb);
        cb.flip();
        this.reason = cb.toString();
    }
}

