/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.RemoteEndpoint;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusRemoteEndpoint;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.core.WebSocketApplication;
import org.glassfish.tyrus.core.WebSocketListener;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;

public class TyrusEndpoint
extends WebSocketApplication {
    private static final Logger LOGGER = Logger.getLogger(TyrusEndpoint.class.getName());
    private final EndpointWrapper endpoint;
    private List<Extension> temporaryNegotiatedExtensions = Collections.emptyList();
    private String temporaryNegotiatedProtocol;

    public TyrusEndpoint(EndpointWrapper endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public boolean isApplicationRequest(UpgradeRequest webSocketRequest) {
        List<String> protocols = webSocketRequest.getHeaders().get("Sec-WebSocket-Protocol");
        this.temporaryNegotiatedProtocol = this.endpoint.getNegotiatedProtocol(protocols);
        List<Extension> extensions = TyrusExtension.fromString(webSocketRequest.getHeaders().get("Sec-WebSocket-Extensions"));
        this.temporaryNegotiatedExtensions = this.endpoint.getNegotiatedExtensions(extensions);
        return this.endpoint.checkHandshake(webSocketRequest);
    }

    @Override
    public String getPath() {
        return this.endpoint.getEndpointPath();
    }

    @Override
    public WebSocket createSocket(ProtocolHandler handler, WebSocketListener listener) {
        handler.setContainer(this.endpoint.getWebSocketContainer());
        return new TyrusWebSocket(handler, listener);
    }

    @Override
    public void onConnect(WebSocket socket, UpgradeRequest upgradeRequest) {
        this.endpoint.onConnect(new TyrusRemoteEndpoint(socket), this.temporaryNegotiatedProtocol, this.temporaryNegotiatedExtensions, upgradeRequest);
    }

    @Override
    public void onFragment(WebSocket socket, String fragment, boolean last) {
        try {
            this.endpoint.onPartialMessage((RemoteEndpoint)new TyrusRemoteEndpoint(socket), fragment, last);
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, t.getMessage(), t);
        }
    }

    @Override
    public void onFragment(WebSocket socket, byte[] fragment, boolean last) {
        try {
            this.endpoint.onPartialMessage((RemoteEndpoint)new TyrusRemoteEndpoint(socket), ByteBuffer.wrap(fragment), last);
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, t.getMessage(), t);
        }
    }

    @Override
    public void onMessage(WebSocket socket, String messageString) {
        this.endpoint.onMessage((RemoteEndpoint)new TyrusRemoteEndpoint(socket), messageString);
    }

    @Override
    public void onMessage(WebSocket socket, byte[] bytes) {
        this.endpoint.onMessage((RemoteEndpoint)new TyrusRemoteEndpoint(socket), ByteBuffer.wrap(bytes));
    }

    @Override
    public void onClose(WebSocket socket, CloseReason closeReason) {
        this.endpoint.onClose(new TyrusRemoteEndpoint(socket), closeReason);
    }

    @Override
    public void onPing(WebSocket socket, byte[] bytes) {
        this.endpoint.onPing(new TyrusRemoteEndpoint(socket), ByteBuffer.wrap(bytes));
    }

    @Override
    public void onPong(WebSocket socket, byte[] bytes) {
        this.endpoint.onPong(new TyrusRemoteEndpoint(socket), ByteBuffer.wrap(bytes));
    }

    @Override
    public List<Extension> getSupportedExtensions() {
        return new ArrayList<Extension>(this.temporaryNegotiatedExtensions);
    }

    @Override
    public boolean onError(WebSocket webSocket, Throwable t) {
        Logger.getLogger(TyrusEndpoint.class.getName()).log(Level.WARNING, "Unexpected error, closing connection.", t);
        return true;
    }

    @Override
    public List<String> getSupportedProtocols(List<String> subProtocol) {
        List<String> result;
        if (this.temporaryNegotiatedProtocol == null || this.temporaryNegotiatedProtocol.isEmpty()) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList<String>();
            result.add(this.temporaryNegotiatedProtocol);
        }
        return result;
    }

    @Override
    public void onHandShakeResponse(UpgradeRequest request, UpgradeResponse response) {
        EndpointConfig configuration = this.endpoint.getEndpointConfig();
        if (configuration instanceof ServerEndpointConfig) {
            ServerEndpointConfig serverEndpointConfig = (ServerEndpointConfig)configuration;
            serverEndpointConfig.getConfigurator().modifyHandshake(serverEndpointConfig, this.createHandshakeRequest(request), response);
        }
    }

    private HandshakeRequest createHandshakeRequest(UpgradeRequest webSocketRequest) {
        if (webSocketRequest instanceof RequestContext) {
            RequestContext requestContext = (RequestContext)webSocketRequest;
            requestContext.lock();
            return requestContext;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TyrusEndpoint that = (TyrusEndpoint)o;
        return this.endpoint.equals(that.endpoint);
    }

    public int hashCode() {
        return this.endpoint.hashCode();
    }
}

