/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.MessageTooBigException;

class BinaryBuffer {
    private final List<ByteBuffer> list = new ArrayList<ByteBuffer>();
    private int bufferSize;
    private int currentlyBuffered = 0;
    private static final Logger LOGGER = Logger.getLogger(BinaryBuffer.class.getName());

    BinaryBuffer() {
    }

    void appendMessagePart(ByteBuffer message) {
        if (this.currentlyBuffered + message.remaining() <= this.bufferSize) {
            this.currentlyBuffered += message.remaining();
        } else {
            MessageTooBigException messageTooBigException = new MessageTooBigException("Partial message could not be delivered due to buffer overflow.");
            LOGGER.log(Level.FINE, "Partial message could not be delivered due to buffer overflow.", messageTooBigException);
            throw messageTooBigException;
        }
        this.list.add(message);
    }

    ByteBuffer getBufferedContent() {
        ByteBuffer b = null;
        for (ByteBuffer buffered : this.list) {
            if (b == null) {
                b = buffered;
                continue;
            }
            b = this.joinBuffers(b, buffered);
        }
        return b;
    }

    void resetBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.list.clear();
        this.currentlyBuffered = 0;
    }

    private ByteBuffer joinBuffers(ByteBuffer bb1, ByteBuffer bb2) {
        int remaining1 = bb1.remaining();
        int remaining2 = bb2.remaining();
        byte[] array = new byte[remaining1 + remaining2];
        bb1.get(array, 0, remaining1);
        System.arraycopy(bb2.array(), 0, array, remaining1, remaining2);
        ByteBuffer buf = ByteBuffer.wrap(array);
        buf.limit(remaining1 + remaining2);
        return buf;
    }
}

