/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientSocket;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyWriter;
import org.glassfish.tyrus.container.grizzly.client.HttpCodecFilter;
import org.glassfish.tyrus.container.grizzly.client.TaskProcessor;
import org.glassfish.tyrus.core.CloseReasons;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;

class GrizzlyClientFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(GrizzlyClientFilter.class);
    private static final Attribute<org.glassfish.tyrus.spi.Connection> TYRUS_CONNECTION = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyClientFilter.class.getName() + ".Connection");
    private static final Attribute<UpgradeRequest> UPGRADE_REQUEST = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyClientFilter.class.getName() + ".UpgradeRequest");
    private static final Attribute<TaskProcessor> TASK_PROCESSOR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(TaskProcessor.class.getName() + ".TaskProcessor");
    private static final Attribute<Boolean> PROXY_CONNECTED = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyClientFilter.class.getName() + ".ProxyConnected");
    private final boolean proxy;
    private final Filter sslFilter;
    private final HttpCodecFilter httpCodecFilter;
    private final ClientEngine engine;
    private final URI uri;
    private final boolean sharedTransport;
    private final Map<String, String> proxyHeaders;
    private final Callable<Void> grizzlyConnector;
    private final UpgradeRequest upgradeRequest;
    private volatile boolean done = false;

    GrizzlyClientFilter(ClientEngine engine, boolean proxy, Filter sslFilter, HttpCodecFilter httpCodecFilter, URI uri, boolean sharedTransport, Map<String, String> proxyHeaders, Callable<Void> grizzlyConnector, UpgradeRequest upgradeRequest) {
        this.engine = engine;
        this.proxy = proxy;
        this.sslFilter = sslFilter;
        this.httpCodecFilter = httpCodecFilter;
        this.uri = uri;
        this.sharedTransport = sharedTransport;
        this.proxyHeaders = proxyHeaders;
        this.grizzlyConnector = grizzlyConnector;
        this.upgradeRequest = upgradeRequest;
    }

    public NextAction handleConnect(FilterChainContext ctx) {
        LOGGER.log(Level.FINEST, "handleConnect");
        if (this.upgradeRequest == null) {
            new GrizzlyWriter(ctx.getConnection()).close();
            return ctx.getStopAction();
        }
        if (this.proxy) {
            PROXY_CONNECTED.set((AttributeStorage)ctx.getConnection(), (Object)false);
        }
        return this.sendRequest(ctx, this.upgradeRequest);
    }

    private NextAction sendRequest(FilterChainContext ctx, UpgradeRequest upgradeRequest) {
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
        if (this.proxy && !((Boolean)PROXY_CONNECTED.get((AttributeStorage)ctx.getConnection())).booleanValue()) {
            UPGRADE_REQUEST.set((AttributeStorage)ctx.getConnection(), (Object)upgradeRequest);
            URI requestURI = upgradeRequest.getRequestURI();
            int requestPort = Utils.getWsPort(requestURI);
            builder = builder.uri(String.format("%s:%d", requestURI.getHost(), requestPort));
            builder = (HttpRequestPacket.Builder)builder.protocol(Protocol.HTTP_1_1);
            builder = builder.method(Method.CONNECT);
            if (this.proxyHeaders != null && this.proxyHeaders.size() > 0) {
                for (Map.Entry<String, String> entry : this.proxyHeaders.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            builder = (HttpRequestPacket.Builder)builder.header(Header.Host, requestURI.getHost());
            builder = (HttpRequestPacket.Builder)builder.header(Header.ProxyConnection, "keep-alive");
            builder = (HttpRequestPacket.Builder)builder.header(Header.Connection, "keep-alive");
            ctx.write((Object)HttpContent.builder((HttpHeader)builder.build()).build());
            ctx.flush(null);
        } else {
            ctx.write((Object)this.getHttpContent(upgradeRequest));
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        org.glassfish.tyrus.spi.Connection connection = (org.glassfish.tyrus.spi.Connection)TYRUS_CONNECTION.get((AttributeStorage)ctx.getConnection());
        if (connection != null) {
            TaskProcessor taskProcessor = (TaskProcessor)TASK_PROCESSOR.get((AttributeStorage)ctx.getConnection());
            this.done = true;
            taskProcessor.processTask(new CloseTask(connection, CloseReasons.CLOSED_ABNORMALLY.getCloseReason(), ctx.getConnection()));
        }
        return ctx.getStopAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        if (this.done) {
            return ctx.getStopAction();
        }
        HttpContent message = (HttpContent)ctx.getMessage();
        Connection grizzlyConnection = ctx.getConnection();
        org.glassfish.tyrus.spi.Connection tyrusConnection = (org.glassfish.tyrus.spi.Connection)TYRUS_CONNECTION.get((AttributeStorage)grizzlyConnection);
        HttpHeader header = message.getHttpHeader();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{tyrusConnection, message.getContent().remaining(), header});
        }
        if (tyrusConnection != null) {
            if (message.getContent().hasRemaining()) {
                Buffer buffer = message.getContent();
                ByteBuffer webSocketBuffer = buffer.toByteBuffer();
                message.recycle();
                ReadHandler readHandler = tyrusConnection.getReadHandler();
                TaskProcessor taskProcessor = (TaskProcessor)TASK_PROCESSOR.get((AttributeStorage)ctx.getConnection());
                taskProcessor.processTask(new ProcessTask(webSocketBuffer, readHandler));
            }
            return ctx.getStopAction();
        }
        HttpStatus httpStatus = ((HttpResponsePacket)message.getHttpHeader()).getHttpStatus();
        if (httpStatus.getStatusCode() != 101 && this.proxy && !((Boolean)PROXY_CONNECTED.get((AttributeStorage)grizzlyConnection)).booleanValue()) {
            if (httpStatus.equals(HttpStatus.OK_200)) {
                PROXY_CONNECTED.set((AttributeStorage)grizzlyConnection, (Object)true);
                if (this.sslFilter != null) {
                    ((GrizzlyClientSocket.FilterWrapper)this.sslFilter).enable();
                }
            } else {
                throw new IOException(String.format("Proxy error. %s: %s", httpStatus.getStatusCode(), new String(httpStatus.getReasonPhraseBytes(), "UTF-8")));
            }
            this.httpCodecFilter.resetResponseProcessing(grizzlyConnection);
            UpgradeRequest upgradeRequest = (UpgradeRequest)UPGRADE_REQUEST.get((AttributeStorage)grizzlyConnection);
            ctx.write((Object)this.getHttpContent(upgradeRequest));
            UPGRADE_REQUEST.remove((AttributeStorage)grizzlyConnection);
            return ctx.getInvokeAction();
        }
        if (!"websocket".equalsIgnoreCase(header.getUpgrade()) && message.getHttpHeader().isRequest()) {
            return ctx.getInvokeAction();
        }
        return this.handleHandshake(ctx, message);
    }

    private NextAction handleHandshake(FilterChainContext ctx, HttpContent content) {
        org.glassfish.tyrus.spi.Connection tyrusConnection;
        final GrizzlyWriter grizzlyWriter = new GrizzlyWriter(ctx.getConnection()){

            @Override
            public void close() {
                super.close();
                try {
                    if (GrizzlyClientFilter.this.sharedTransport) {
                        this.connection.close();
                    } else {
                        this.connection.getTransport().shutdownNow();
                    }
                }
                catch (IOException e) {
                    Logger.getLogger(GrizzlyClientFilter.class.getName()).log(Level.INFO, "Exception thrown during shutdown.", e);
                }
            }
        };
        ClientEngine.ClientUpgradeInfo clientUpgradeInfo = this.engine.processResponse(GrizzlyClientFilter.getUpgradeResponse((HttpResponsePacket)content.getHttpHeader()), grizzlyWriter, new Connection.CloseListener(){

            @Override
            public void close(CloseReason reason) {
                grizzlyWriter.close();
            }
        });
        switch (clientUpgradeInfo.getUpgradeStatus()) {
            case UPGRADE_REQUEST_FAILED: {
                grizzlyWriter.close();
                return ctx.getStopAction();
            }
            case ANOTHER_UPGRADE_REQUEST_REQUIRED: {
                grizzlyWriter.close();
                try {
                    this.grizzlyConnector.call();
                }
                catch (Exception e) {
                    this.engine.processError(e);
                }
                return ctx.getInvokeAction();
            }
            case SUCCESS: {
                tyrusConnection = clientUpgradeInfo.createConnection();
                break;
            }
            default: {
                return ctx.getStopAction();
            }
        }
        TASK_PROCESSOR.set((AttributeStorage)ctx.getConnection(), (Object)new TaskProcessor());
        TYRUS_CONNECTION.set((AttributeStorage)ctx.getConnection(), (Object)tyrusConnection);
        String ATTR_NAME = "org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED";
        AttributeHolder attributeHolder = ctx.getAttributes();
        if (attributeHolder != null) {
            Object attribute = attributeHolder.getAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED");
            if (attribute != null) {
                return ctx.getInvokeAction();
            }
            attributeHolder.setAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED", (Object)true);
        }
        if (content.getContent().hasRemaining()) {
            return ctx.getRerunFilterAction();
        }
        content.recycle();
        return ctx.getStopAction();
    }

    private static UpgradeResponse getUpgradeResponse(HttpResponsePacket httpResponsePacket) {
        TyrusUpgradeResponse tyrusUpgradeResponse = new TyrusUpgradeResponse();
        for (String name : httpResponsePacket.getHeaders().names()) {
            for (String headerValue : httpResponsePacket.getHeaders().values(name)) {
                List<String> values = tyrusUpgradeResponse.getHeaders().get(name);
                if (values == null) {
                    tyrusUpgradeResponse.getHeaders().put(name, Utils.parseHeaderValue(headerValue.trim()));
                    continue;
                }
                values.addAll(Utils.parseHeaderValue(headerValue.trim()));
            }
        }
        tyrusUpgradeResponse.setStatus(httpResponsePacket.getStatus());
        return tyrusUpgradeResponse;
    }

    private HttpContent getHttpContent(UpgradeRequest request) {
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
        builder = (HttpRequestPacket.Builder)builder.protocol(Protocol.HTTP_1_1);
        builder = builder.method(Method.GET);
        StringBuilder sb = new StringBuilder();
        URI uri = URI.create(request.getRequestUri());
        sb.append(uri.getPath());
        String query = uri.getQuery();
        if (query != null) {
            sb.append('?').append(query);
        }
        if (sb.length() == 0) {
            sb.append('/');
        }
        builder = builder.uri(sb.toString());
        for (Map.Entry<String, List<String>> headerEntry : request.getHeaders().entrySet()) {
            StringBuilder finalHeaderValue = new StringBuilder();
            for (String headerValue : headerEntry.getValue()) {
                if (finalHeaderValue.length() != 0) {
                    finalHeaderValue.append(", ");
                }
                finalHeaderValue.append(headerValue);
            }
            builder.header(headerEntry.getKey(), finalHeaderValue.toString());
        }
        return HttpContent.builder((HttpHeader)builder.build()).build();
    }

    private class CloseTask
    extends TaskProcessor.Task {
        private final org.glassfish.tyrus.spi.Connection connection;
        private final CloseReason closeReason;
        private final Connection grizzlyConnection;

        private CloseTask(org.glassfish.tyrus.spi.Connection connection, CloseReason closeReason, Connection grizzlyConnection) {
            this.connection = connection;
            this.closeReason = closeReason;
            this.grizzlyConnection = grizzlyConnection;
        }

        @Override
        public void execute() {
            this.connection.close(this.closeReason);
            TYRUS_CONNECTION.remove((AttributeStorage)this.grizzlyConnection);
            TASK_PROCESSOR.remove((AttributeStorage)this.grizzlyConnection);
        }
    }

    private class ProcessTask
    extends TaskProcessor.Task {
        private final ByteBuffer buffer;
        private final ReadHandler readHandler;

        private ProcessTask(ByteBuffer buffer, ReadHandler readHandler) {
            this.buffer = buffer;
            this.readHandler = readHandler;
        }

        @Override
        public void execute() {
            this.readHandler.handle(this.buffer);
        }
    }
}

