/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.WebSocketException;
import org.glassfish.tyrus.core.cluster.ClusterContext;
import org.glassfish.tyrus.core.extension.ExtendedExtension;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.core.uri.Match;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

public class TyrusWebSocketEngine
implements WebSocketEngine {
    public static final String INCOMING_BUFFER_SIZE = "org.glassfish.tyrus.incomingBufferSize";
    private static final int BUFFER_STEP_SIZE = 256;
    private static final Logger LOGGER = Logger.getLogger("websocket");
    private static final WebSocketEngine.UpgradeInfo NOT_APPLICABLE_UPGRADE_INFO = new NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus.NOT_APPLICABLE);
    private static final WebSocketEngine.UpgradeInfo HANDSHAKE_FAILED_UPGRADE_INFO = new NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus.HANDSHAKE_FAILED);
    private final Set<TyrusEndpointWrapper> endpointWrappers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ComponentProviderService componentProviderService = ComponentProviderService.create();
    private final WebSocketContainer webSocketContainer;
    private int incomingBufferSize = 0x40000B;
    private final ClusterContext clusterContext;

    public TyrusWebSocketEngine(WebSocketContainer webSocketContainer) {
        this(webSocketContainer, null, null);
    }

    public TyrusWebSocketEngine(WebSocketContainer webSocketContainer, Integer incomingBufferSize, ClusterContext clusterContext) {
        if (incomingBufferSize != null) {
            this.incomingBufferSize = incomingBufferSize;
        }
        this.webSocketContainer = webSocketContainer;
        this.clusterContext = clusterContext;
    }

    private static ProtocolHandler loadHandler(UpgradeRequest request) {
        for (Version version : Version.values()) {
            if (!version.validate(request)) continue;
            return version.createHandler(false);
        }
        return null;
    }

    private static void handleUnsupportedVersion(UpgradeRequest request, UpgradeResponse response) {
        response.setStatus(426);
        response.getHeaders().put("Sec-WebSocket-Version", Arrays.asList(Version.getSupportedWireProtocolVersions()));
    }

    TyrusEndpointWrapper getEndpointWrapper(UpgradeRequest request) {
        if (this.endpointWrappers.isEmpty()) {
            return null;
        }
        String requestPath = request.getRequestUri();
        for (Match m : Match.getAllMatches(requestPath, this.endpointWrappers)) {
            TyrusEndpointWrapper endpointWrapper = m.getEndpointWrapper();
            for (String name : m.getParameterNames()) {
                request.getParameterMap().put(name, Arrays.asList(m.getParameterValue(name)));
            }
            if (!endpointWrapper.upgrade(request)) continue;
            return endpointWrapper;
        }
        return null;
    }

    @Override
    public WebSocketEngine.UpgradeInfo upgrade(UpgradeRequest request, UpgradeResponse response) {
        try {
            TyrusEndpointWrapper endpointWrapper = this.getEndpointWrapper(request);
            if (endpointWrapper != null) {
                ProtocolHandler protocolHandler = TyrusWebSocketEngine.loadHandler(request);
                if (protocolHandler == null) {
                    TyrusWebSocketEngine.handleUnsupportedVersion(request, response);
                    return HANDSHAKE_FAILED_UPGRADE_INFO;
                }
                ExtendedExtension.ExtensionContext extensionContext = new ExtendedExtension.ExtensionContext(){
                    private final Map<String, Object> properties = new HashMap<String, Object>();

                    @Override
                    public Map<String, Object> getProperties() {
                        return this.properties;
                    }
                };
                protocolHandler.handshake(endpointWrapper, request, response, extensionContext);
                if (this.clusterContext != null && request.getHeaders().get("tyrus-cluster-connection-id") == null) {
                    response.getHeaders().put("tyrus-cluster-connection-id", Collections.singletonList(this.clusterContext.createConnectionId()));
                }
                return new SuccessfulUpgradeInfo(endpointWrapper, protocolHandler, this.incomingBufferSize, request, response, extensionContext);
            }
        }
        catch (HandshakeException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            response.setStatus(e.getHttpStatusCode());
            return HANDSHAKE_FAILED_UPGRADE_INFO;
        }
        response.setStatus(500);
        return NOT_APPLICABLE_UPGRADE_INFO;
    }

    public void setIncomingBufferSize(int incomingBufferSize) {
        this.incomingBufferSize = incomingBufferSize;
    }

    private void register(TyrusEndpointWrapper endpointWrapper) throws DeploymentException {
        this.checkPath(endpointWrapper);
        this.endpointWrappers.add(endpointWrapper);
    }

    @Override
    public void register(Class<?> endpointClass, String contextPath) throws DeploymentException {
        EndpointConfig config;
        AnnotatedEndpoint endpoint;
        ErrorCollector collector = new ErrorCollector();
        TyrusEndpointWrapper endpointWrapper = new TyrusEndpointWrapper(endpoint, config, this.componentProviderService, this.webSocketContainer, contextPath, (config = (endpoint = AnnotatedEndpoint.fromClass(endpointClass, this.componentProviderService, true, collector)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null, null, this.clusterContext);
        if (!collector.isEmpty()) {
            throw collector.composeComprehensiveException();
        }
        this.register(endpointWrapper);
    }

    @Override
    public void register(ServerEndpointConfig serverConfig, String contextPath) throws DeploymentException {
        TyrusEndpointWrapper endpointWrapper;
        Class<?> endpointClass = serverConfig.getEndpointClass();
        boolean isEndpointClass = false;
        do {
            if (!(endpointClass = endpointClass.getSuperclass()).equals(Endpoint.class)) continue;
            isEndpointClass = true;
        } while (!endpointClass.equals(Object.class));
        if (isEndpointClass) {
            endpointWrapper = new TyrusEndpointWrapper(serverConfig.getEndpointClass(), serverConfig, this.componentProviderService, this.webSocketContainer, contextPath, serverConfig.getConfigurator());
        } else {
            EndpointConfig config;
            AnnotatedEndpoint endpoint;
            ErrorCollector collector = new ErrorCollector();
            endpointWrapper = new TyrusEndpointWrapper(endpoint, config, this.componentProviderService, this.webSocketContainer, contextPath, (config = (endpoint = AnnotatedEndpoint.fromClass(serverConfig.getEndpointClass(), this.componentProviderService, true, collector)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null, null, this.clusterContext);
            if (!collector.isEmpty()) {
                throw collector.composeComprehensiveException();
            }
        }
        this.register(endpointWrapper);
    }

    private void checkPath(TyrusEndpointWrapper endpoint) throws DeploymentException {
        for (TyrusEndpointWrapper endpointWrapper : this.endpointWrappers) {
            if (!Match.isEquivalent(endpoint.getEndpointPath(), endpointWrapper.getEndpointPath())) continue;
            throw new DeploymentException(LocalizationMessages.EQUIVALENT_PATHS(endpoint.getEndpointPath(), endpointWrapper.getEndpointPath()));
        }
    }

    public void unregister(TyrusEndpointWrapper endpointWrapper) {
        this.endpointWrappers.remove(endpointWrapper);
    }

    static class TyrusConnection
    implements Connection {
        private final ReadHandler readHandler;
        private final Writer writer;
        private final Connection.CloseListener closeListener;
        private final TyrusWebSocket socket;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private final List<Extension> extensions;

        TyrusConnection(TyrusEndpointWrapper endpointWrapper, ProtocolHandler protocolHandler, int incomingBufferSize, Writer writer, Connection.CloseListener closeListener, UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse, ExtendedExtension.ExtensionContext extensionContext) {
            protocolHandler.setWriter(writer);
            this.extensions = protocolHandler.getExtensions();
            this.socket = endpointWrapper.createSocket(protocolHandler);
            List<String> connectionIdHeader = upgradeRequest.getHeaders().get("tyrus-cluster-connection-id");
            String connectionId = connectionIdHeader != null && connectionIdHeader.size() == 1 ? connectionIdHeader.get(0) : upgradeResponse.getFirstHeaderValue("tyrus-cluster-connection-id");
            this.socket.onConnect(upgradeRequest, protocolHandler.getSubProtocol(), this.extensions, connectionId);
            this.readHandler = new TyrusReadHandler(protocolHandler, this.socket, endpointWrapper, incomingBufferSize, extensionContext);
            this.writer = writer;
            this.closeListener = closeListener;
            this.extensionContext = extensionContext;
        }

        @Override
        public ReadHandler getReadHandler() {
            return this.readHandler;
        }

        @Override
        public Writer getWriter() {
            return this.writer;
        }

        @Override
        public Connection.CloseListener getCloseListener() {
            return this.closeListener;
        }

        @Override
        public void close(CloseReason reason) {
            if (!this.socket.isConnected()) {
                return;
            }
            this.socket.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
            for (Extension extension : this.extensions) {
                if (!(extension instanceof ExtendedExtension)) continue;
                try {
                    ((ExtendedExtension)extension).destroy(this.extensionContext);
                }
                catch (Throwable t) {}
            }
        }
    }

    private static class SuccessfulUpgradeInfo
    implements WebSocketEngine.UpgradeInfo {
        private final TyrusEndpointWrapper endpointWrapper;
        private final ProtocolHandler protocolHandler;
        private final int incomingBufferSize;
        private final UpgradeRequest upgradeRequest;
        private final UpgradeResponse upgradeResponse;
        private final ExtendedExtension.ExtensionContext extensionContext;

        SuccessfulUpgradeInfo(TyrusEndpointWrapper endpointWrapper, ProtocolHandler protocolHandler, int incomingBufferSize, UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse, ExtendedExtension.ExtensionContext extensionContext) {
            this.endpointWrapper = endpointWrapper;
            this.protocolHandler = protocolHandler;
            this.incomingBufferSize = incomingBufferSize;
            this.upgradeRequest = upgradeRequest;
            this.upgradeResponse = upgradeResponse;
            this.extensionContext = extensionContext;
        }

        @Override
        public WebSocketEngine.UpgradeStatus getStatus() {
            return WebSocketEngine.UpgradeStatus.SUCCESS;
        }

        @Override
        public Connection createConnection(Writer writer, Connection.CloseListener closeListener) {
            return new TyrusConnection(this.endpointWrapper, this.protocolHandler, this.incomingBufferSize, writer, closeListener, this.upgradeRequest, this.upgradeResponse, this.extensionContext);
        }
    }

    private static class NoConnectionUpgradeInfo
    implements WebSocketEngine.UpgradeInfo {
        private final WebSocketEngine.UpgradeStatus status;

        NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus status) {
            this.status = status;
        }

        @Override
        public WebSocketEngine.UpgradeStatus getStatus() {
            return this.status;
        }

        @Override
        public Connection createConnection(Writer writer, Connection.CloseListener closeListener) {
            return null;
        }
    }

    private static class TyrusReadHandler
    implements ReadHandler {
        private final ProtocolHandler protocolHandler;
        private final TyrusWebSocket socket;
        private final TyrusEndpointWrapper endpointWrapper;
        private final int incomingBufferSize;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private volatile ByteBuffer buffer;

        private TyrusReadHandler(ProtocolHandler protocolHandler, TyrusWebSocket socket, TyrusEndpointWrapper endpointWrapper, int incomingBufferSize, ExtendedExtension.ExtensionContext extensionContext) {
            this.extensionContext = extensionContext;
            this.protocolHandler = protocolHandler;
            this.socket = socket;
            this.endpointWrapper = endpointWrapper;
            this.incomingBufferSize = incomingBufferSize;
        }

        @Override
        public void handle(ByteBuffer data) {
            block12: {
                try {
                    if (data == null || !data.hasRemaining()) break block12;
                    if (this.buffer != null) {
                        data = Utils.appendBuffers(this.buffer, data, this.incomingBufferSize, 256);
                    } else {
                        int newSize = data.remaining();
                        if (newSize > this.incomingBufferSize) {
                            throw new IllegalArgumentException(LocalizationMessages.BUFFER_OVERFLOW());
                        }
                        int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
                        ByteBuffer result = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
                        result.flip();
                        data = Utils.appendBuffers(result, data, this.incomingBufferSize, 256);
                    }
                    while (true) {
                        Frame incomingFrame;
                        if ((incomingFrame = this.protocolHandler.unframe(data)) == null) {
                            this.buffer = data;
                            break;
                        }
                        Frame frame = incomingFrame;
                        for (Extension extension : this.protocolHandler.getExtensions()) {
                            if (!(extension instanceof ExtendedExtension)) continue;
                            try {
                                frame = ((ExtendedExtension)extension).processIncoming(this.extensionContext, frame);
                            }
                            catch (Throwable t) {
                                LOGGER.log(Level.FINE, String.format("Extension '%s' threw an exception during processIncoming method invocation: \"%s\".", extension.getName(), t.getMessage()), t);
                            }
                        }
                        this.protocolHandler.process(frame, this.socket);
                    }
                }
                catch (WebSocketException e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(e.getCloseReason()));
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    LOGGER.log(Level.FINE, message, e);
                    if (!this.endpointWrapper.onError(this.socket, e)) break block12;
                    if (message.length() > 123) {
                        message = message.substring(0, 123);
                    }
                    this.socket.onClose(new CloseFrame(new CloseReason(CloseReason.CloseCodes.UNEXPECTED_CONDITION, message)));
                }
            }
        }
    }
}

