/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.CloseReason;
import javax.websocket.SendHandler;
import org.glassfish.tyrus.core.Frame;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;

public class TyrusRemoteEndpoint {
    private final TyrusWebSocket socket;

    public TyrusRemoteEndpoint(TyrusWebSocket socket) {
        this.socket = socket;
    }

    public Future<Frame> sendText(String text) {
        return this.socket.send(text);
    }

    public void sendText(String text, SendHandler handler) {
        this.socket.send(text, handler);
    }

    public Future<Frame> sendBinary(ByteBuffer data) {
        return this.socket.send(Utils.getRemainingArray(data));
    }

    public void sendBinary(ByteBuffer data, SendHandler handler) {
        this.socket.send(Utils.getRemainingArray(data), handler);
    }

    public Future<Frame> sendText(String fragment, boolean isLast) {
        return this.socket.stream(isLast, fragment);
    }

    public Future<Frame> sendBinary(ByteBuffer data, boolean isLast) {
        byte[] bytes = Utils.getRemainingArray(data);
        return this.socket.stream(isLast, bytes, 0, bytes.length);
    }

    public Future<Frame> sendPing(ByteBuffer data) {
        return this.socket.sendPing(Utils.getRemainingArray(data));
    }

    public Future<Frame> sendPong(ByteBuffer data) {
        return this.socket.sendPong(Utils.getRemainingArray(data));
    }

    public void close(CloseReason closeReason) {
        this.socket.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }

    public void setWriteTimeout(long timeoutMs) {
        this.socket.setWriteTimeout(timeoutMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TyrusRemoteEndpoint)) {
            return false;
        }
        TyrusRemoteEndpoint that = (TyrusRemoteEndpoint)o;
        return this.socket.equals(that.socket);
    }

    public int hashCode() {
        return this.socket.hashCode();
    }

    public Future<Frame> sendRawFrame(ByteBuffer dataFrame) {
        return this.socket.sendRawFrame(dataFrame);
    }

    TyrusWebSocket getSocket() {
        return this.socket;
    }
}

