/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.server;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.tyrus.container.grizzly.server.WebSocketAddOn;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.spi.ServerContainer;
import org.glassfish.tyrus.spi.ServerContainerFactory;
import org.glassfish.tyrus.spi.WebSocketEngine;

public class GrizzlyServerContainer
extends ServerContainerFactory {
    public static final String WORKER_THREAD_POOL_CONFIG = "org.glassfish.tyrus.container.grizzly.server.workerThreadPoolConfig";
    public static final String SELECTOR_THREAD_POOL_CONFIG = "org.glassfish.tyrus.container.grizzly.server.selectorThreadPoolConfig";

    @Override
    public ServerContainer createContainer(Map<String, Object> properties) {
        final Map<Object, Object> localProperties = properties == null ? Collections.emptyMap() : new HashMap<String, Object>(properties);
        Object o = localProperties.get("org.glassfish.tyrus.incomingBufferSize");
        final Integer incomingBufferSize = o instanceof Integer ? (Integer)o : null;
        return new TyrusServerContainer(null){
            private final WebSocketEngine engine;
            private HttpServer server;
            private String contextPath;
            {
                super(x0);
                this.engine = new TyrusWebSocketEngine(this, incomingBufferSize);
            }

            @Override
            public void register(Class<?> endpointClass) throws DeploymentException {
                this.engine.register(endpointClass, this.contextPath);
            }

            @Override
            public void register(ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
                this.engine.register(serverEndpointConfig, this.contextPath);
            }

            @Override
            public WebSocketEngine getWebSocketEngine() {
                return this.engine;
            }

            @Override
            public void start(String rootPath, int port) throws IOException, DeploymentException {
                this.contextPath = rootPath;
                this.server = HttpServer.createSimpleServer((String)rootPath, (int)port);
                ThreadPoolConfig workerThreadPoolConfig = Utils.getProperty(localProperties, GrizzlyServerContainer.WORKER_THREAD_POOL_CONFIG, ThreadPoolConfig.class);
                ThreadPoolConfig selectorThreadPoolConfig = Utils.getProperty(localProperties, GrizzlyServerContainer.SELECTOR_THREAD_POOL_CONFIG, ThreadPoolConfig.class);
                if (workerThreadPoolConfig != null || selectorThreadPoolConfig != null) {
                    TCPNIOTransportBuilder transportBuilder = TCPNIOTransportBuilder.newInstance();
                    if (workerThreadPoolConfig != null) {
                        transportBuilder.setWorkerThreadPoolConfig(workerThreadPoolConfig);
                    }
                    if (selectorThreadPoolConfig != null) {
                        transportBuilder.setSelectorThreadPoolConfig(selectorThreadPoolConfig);
                    }
                    transportBuilder.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
                    this.server.getListener("grizzly").setTransport(transportBuilder.build());
                } else {
                    this.server.getListener("grizzly").getTransport().setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
                }
                this.server.getListener("grizzly").getKeepAlive().setIdleTimeoutInSeconds(-1);
                this.server.getListener("grizzly").registerAddOn((AddOn)new WebSocketAddOn(this));
                Object staticContentPath = localProperties.get("org.glassfish.tyrus.server.staticContentRoot");
                if (staticContentPath != null && !staticContentPath.toString().isEmpty()) {
                    StaticHttpHandler staticHttpHandler = new StaticHttpHandler(new String[]{staticContentPath.toString()});
                    this.server.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/"});
                }
                this.server.start();
                super.start(rootPath, port);
            }

            @Override
            public void stop() {
                super.stop();
                this.server.shutdownNow();
            }
        };
    }
}

