/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientSocket;
import org.glassfish.tyrus.spi.ClientContainer;
import org.glassfish.tyrus.spi.ClientEngine;

public class GrizzlyClientContainer
implements ClientContainer {
    public static final String SSL_ENGINE_CONFIGURATOR = "org.glassfish.tyrus.client.sslEngineConfigurator";
    private static final long CLIENT_SOCKET_TIMEOUT = 30000L;

    @Override
    public void openClientSocket(String url, ClientEndpointConfig cec, Map<String, Object> properties, ClientEngine clientEngine) throws DeploymentException, IOException {
        SSLEngineConfigurator sslEngineConfigurator;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid URI.", e);
        }
        SSLEngineConfigurator sSLEngineConfigurator = sslEngineConfigurator = properties == null ? null : (SSLEngineConfigurator)properties.get(SSL_ENGINE_CONFIGURATOR);
        if (uri.getScheme().equalsIgnoreCase("wss") && sslEngineConfigurator == null) {
            SSLContextConfigurator defaultConfig = new SSLContextConfigurator();
            defaultConfig.retrieve(System.getProperties());
            sslEngineConfigurator = new SSLEngineConfigurator(defaultConfig, true, false, false);
        }
        GrizzlyClientSocket clientSocket = new GrizzlyClientSocket(uri, 30000L, clientEngine, properties == null ? null : sslEngineConfigurator, properties == null ? null : (String)properties.get("org.glassfish.tyrus.client.proxy"), properties == null ? null : (ThreadPoolConfig)properties.get("org.glassfish.tyrus.client.grizzly.workerThreadPoolConfig"), properties == null ? null : (ThreadPoolConfig)properties.get("org.glassfish.tyrus.client.grizzly.selectorThreadPoolConfig"));
        clientSocket.connect();
    }
}

