/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core.uri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.WebSocketApplication;
import org.glassfish.tyrus.core.uri.MatchComparator;
import org.glassfish.tyrus.core.uri.internal.PathSegment;
import org.glassfish.tyrus.core.uri.internal.UriComponent;

public class Match {
    private final WebSocketApplication webSocketApplication;
    private final List<String> parameterNames = new ArrayList<String>();
    private final List<String> parameterValues = new ArrayList<String>();
    private final List<Integer> variableSegmentIndices = new ArrayList<Integer>();
    private static final Logger LOGGER = Logger.getLogger(Match.class.getName());
    private static final boolean noisy = false;

    private static void debug(String message) {
    }

    private Match(WebSocketApplication webSocketApplication) {
        this.webSocketApplication = webSocketApplication;
    }

    public String getPath() {
        return this.webSocketApplication.getPath();
    }

    public List<Integer> getVariableSegmentIndices() {
        return this.variableSegmentIndices;
    }

    int getLowestVariableSegmentIndex() {
        if (this.getVariableSegmentIndices().isEmpty()) {
            return -1;
        }
        return this.getVariableSegmentIndices().get(0);
    }

    void addParameter(String name, String value, int index) {
        this.parameterNames.add(name);
        this.parameterValues.add(value);
        this.variableSegmentIndices.add(index);
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public String getParameterValue(String name) {
        return this.parameterValues.get(this.parameterNames.indexOf(name));
    }

    public WebSocketApplication getWebSocketApplication() {
        return this.webSocketApplication;
    }

    public String toString() {
        if (this.isExact()) {
            return "Match(exact, path:" + this.webSocketApplication.getPath() + ")";
        }
        return "Match(path:" + this.webSocketApplication.getPath() + " params: " + this.paramsToString() + " idices: " + this.variableSegmentIndices + ")";
    }

    private String paramsToString() {
        StringBuilder sb = new StringBuilder();
        for (String nextName : this.parameterNames) {
            sb.append(nextName).append("=").append(this.getParameterValue(nextName));
            if (this.parameterNames.indexOf(nextName) == this.parameterNames.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public boolean isExact() {
        return this.getLowestVariableSegmentIndex() == -1;
    }

    public static Match getBestMatch(String incoming, Set<WebSocketApplication> thingsWithPath) {
        List<Match> sortedMatches = Match.getAllMatches(incoming, thingsWithPath);
        if (sortedMatches.isEmpty()) {
            return null;
        }
        return sortedMatches.get(0);
    }

    public static List<Match> getAllMatches(String incoming, Set<WebSocketApplication> thingsWithPath) {
        HashSet<Match> matches = new HashSet<Match>();
        for (WebSocketApplication nextThingWithPath : thingsWithPath) {
            Match m = Match.matchPath(incoming, nextThingWithPath);
            if (m == null) continue;
            matches.add(m);
        }
        ArrayList<Match> sortedMatches = new ArrayList<Match>();
        sortedMatches.addAll(matches);
        Match.debug("Unsorted: " + sortedMatches);
        Collections.sort(sortedMatches, new MatchComparator());
        Match.debug("Sorted: " + sortedMatches);
        return sortedMatches;
    }

    private static List<String> asEquivalenceList(String path) {
        ArrayList<String> eList = new ArrayList<String>();
        List<PathSegment> asSegments = UriComponent.decodePath(path, true);
        for (PathSegment next : asSegments) {
            if (Match.isVariable(next.getPath())) {
                eList.add("{x}");
                continue;
            }
            eList.add(next.getPath());
        }
        return eList;
    }

    public static boolean checkForEquivalents(List<String> paths) {
        for (int i = 0; i < paths.size(); ++i) {
            String nextPath = paths.get(i);
            for (int j = 0; j < paths.size(); ++j) {
                if (j == i || !Match.isEquivalent(nextPath, paths.get(j))) continue;
                Match.debug("two the same!!: " + nextPath + " is equivalent to " + paths.get(j));
                return true;
            }
        }
        return false;
    }

    public static boolean isEquivalent(String path1, String path2) {
        Match.debug("isEquivalent ? " + path1 + " and " + path2);
        List<String> path1EList = Match.asEquivalenceList(path1);
        List<String> path2EList = Match.asEquivalenceList(path2);
        boolean eq = path1EList.equals(path2EList);
        Match.debug("isEquivalent ? " + eq);
        return eq;
    }

    private static Match matchPath(String incoming, WebSocketApplication hasPath) {
        List<PathSegment> incomingList = UriComponent.decodePath(incoming, true);
        List<PathSegment> pathList = UriComponent.decodePath(hasPath.getPath(), true);
        if (incomingList.size() != pathList.size()) {
            return null;
        }
        Match m = new Match(hasPath);
        boolean somethingMatched = false;
        for (int i = 0; i < incomingList.size(); ++i) {
            String pathSegment;
            String incomingSegment = incomingList.get(i).getPath();
            if (incomingSegment.equals(pathSegment = pathList.get(i).getPath())) {
                somethingMatched = true;
                continue;
            }
            if (Match.isVariable(pathSegment)) {
                somethingMatched = true;
                m.addParameter(Match.getVariableName(pathSegment), incomingSegment, i);
                continue;
            }
            return null;
        }
        if (somethingMatched) {
            return m;
        }
        return null;
    }

    private static boolean isVariable(String segment) {
        return segment.startsWith("{") && segment.endsWith("}");
    }

    private static String getVariableName(String segment) {
        return segment.substring(1, segment.length() - 1);
    }
}

