/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.Reader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.MessageHandler;
import org.glassfish.tyrus.core.BufferedStringReader;
import org.glassfish.tyrus.core.MessageTooBigException;

class ReaderBuffer {
    private final AtomicBoolean buffering = new AtomicBoolean(true);
    private final ExecutorService executorService;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private static final Logger LOGGER = Logger.getLogger(ReaderBuffer.class.getName());
    private boolean receivedLast = false;
    private int bufferSize;
    private int currentlyBuffered;
    private StringBuffer buffer = new StringBuffer();
    private BufferedStringReader reader = null;
    private MessageHandler.Whole<Reader> messageHandler;

    public ReaderBuffer(ExecutorService executorService) {
        this.executorService = executorService;
        this.currentlyBuffered = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getNextChars(int number) {
        this.lock.lock();
        try {
            if (this.buffer.length() == 0) {
                boolean interrupted;
                if (this.receivedLast) {
                    this.reader = null;
                    this.buffering.set(true);
                    this.currentlyBuffered = 0;
                    char[] cArray = null;
                    return cArray;
                }
                do {
                    interrupted = false;
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                } while (interrupted);
            }
            int size = number > this.buffer.length() ? this.buffer.length() : number;
            char[] result = new char[size];
            this.buffer.getChars(0, size, result, 0);
            this.buffer.delete(0, size);
            char[] cArray = result;
            return cArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void finishReading() {
        this.buffer = new StringBuffer();
        this.reader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessagePart(String message, boolean last) {
        this.lock.lock();
        try {
            this.currentlyBuffered += message.length();
            if (this.currentlyBuffered <= this.bufferSize) {
                this.buffer.append(message);
            } else if (this.buffering.get()) {
                this.buffering.set(false);
                MessageTooBigException messageTooBigException = new MessageTooBigException("Partial message could not be delivered due to buffer overflow.");
                LOGGER.log(Level.FINE, "Partial message could not be delivered due to buffer overflow.", messageTooBigException);
                this.receivedLast = true;
                throw messageTooBigException;
            }
            this.receivedLast = last;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.reader == null) {
            this.reader = new BufferedStringReader(this);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    ReaderBuffer.this.messageHandler.onMessage(ReaderBuffer.this.reader);
                }
            });
        }
    }

    public void setMessageHandler(MessageHandler.Whole<Reader> messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void resetBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffering.set(true);
        this.currentlyBuffered = 0;
        this.buffer.delete(0, this.buffer.length());
    }
}

