/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ReflectionHelper;

public class TyrusServerConfiguration
implements ServerApplicationConfig {
    private static final Logger LOGGER = Logger.getLogger(TyrusServerConfiguration.class.getName());
    private final Set<ServerEndpointConfig> serverEndpointConfigs = new HashSet<ServerEndpointConfig>();
    private final Set<Class<?>> annotatedClasses = new HashSet();

    public TyrusServerConfiguration(Set<Class<?>> classes, Set<ServerEndpointConfig> serverEndpointConfigs) {
        this(classes, Collections.emptySet(), serverEndpointConfigs, new ErrorCollector());
    }

    public TyrusServerConfiguration(Set<Class<?>> classes, Set<Class<?>> dynamicallyAddedClasses, Set<ServerEndpointConfig> serverEndpointConfigs, ErrorCollector errorCollector) {
        if (classes == null || serverEndpointConfigs == null || errorCollector == null) {
            throw new IllegalArgumentException();
        }
        this.serverEndpointConfigs.addAll(serverEndpointConfigs);
        HashSet<ServerApplicationConfig> configurations = new HashSet<ServerApplicationConfig>();
        HashSet<Class<? extends Endpoint>> scannedProgramatics = new HashSet<Class<? extends Endpoint>>();
        HashSet scannedAnnotateds = new HashSet();
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> clazz = it.next();
            if (this.isAbstract(clazz, errorCollector)) {
                it.remove();
                continue;
            }
            if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                ServerApplicationConfig serverApplicationConfig = (ServerApplicationConfig)ReflectionHelper.getInstance(clazz, errorCollector);
                configurations.add(serverApplicationConfig);
            }
            if (Endpoint.class.isAssignableFrom(clazz)) {
                scannedProgramatics.add(clazz);
            }
            if (!clazz.isAnnotationPresent(ServerEndpoint.class)) continue;
            scannedAnnotateds.add(clazz);
        }
        for (Class<?> clazz : dynamicallyAddedClasses) {
            if (this.isAbstract(clazz, errorCollector)) continue;
            if (clazz.isAnnotationPresent(ServerEndpoint.class)) {
                this.annotatedClasses.add(clazz);
                continue;
            }
            if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                ServerApplicationConfig serverApplicationConfig = (ServerApplicationConfig)ReflectionHelper.getInstance(clazz, errorCollector);
                configurations.add(serverApplicationConfig);
                continue;
            }
            errorCollector.addException(new DeploymentException(String.format("Class %s is not ServerApplicationConfig descendant nor has @ServerEndpoint annotation.", clazz.getName())));
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            StringBuilder logMessage = new StringBuilder();
            if (!configurations.isEmpty()) {
                logMessage.append("Found server application configs:\n");
            }
            for (ServerApplicationConfig serverApplicationConfig : configurations) {
                logMessage.append("\t").append(serverApplicationConfig.getClass().getName()).append("\n");
            }
            if (!scannedProgramatics.isEmpty()) {
                logMessage.append("Found programmatic endpoints:\n");
            }
            for (Class clazz : scannedProgramatics) {
                logMessage.append("\t").append(clazz.getName()).append("\n");
            }
            if (!scannedAnnotateds.isEmpty() || !this.annotatedClasses.isEmpty()) {
                logMessage.append("Found annotated endpoints:\n");
            }
            for (Class clazz : scannedAnnotateds) {
                logMessage.append("\t").append(clazz.getName()).append("\n");
            }
            for (Class<?> clazz : this.annotatedClasses) {
                logMessage.append("\t").append(clazz.getName()).append("\n");
            }
            if (!logMessage.toString().equals("")) {
                LOGGER.config(logMessage.toString());
            }
        }
        if (!configurations.isEmpty()) {
            for (ServerApplicationConfig serverApplicationConfig : configurations) {
                HashSet hashSet2 = serverApplicationConfig.getEndpointConfigs(scannedProgramatics);
                hashSet2 = hashSet2 == null ? new HashSet() : hashSet2;
                this.serverEndpointConfigs.addAll(hashSet2);
                HashSet annotated = serverApplicationConfig.getAnnotatedEndpointClasses(scannedAnnotateds);
                annotated = annotated == null ? new HashSet() : annotated;
                this.annotatedClasses.addAll(annotated);
            }
        } else {
            this.annotatedClasses.addAll(scannedAnnotateds);
        }
    }

    private boolean isAbstract(Class<?> clazz, ErrorCollector errorCollector) {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            LOGGER.log(Level.WARNING, String.format("%s: Deployed class can't be abstract nor interface. The class will not be deployed.", clazz.getName()));
            return true;
        }
        return false;
    }

    @Override
    public Set<ServerEndpointConfig> getEndpointConfigs(Set<Class<? extends Endpoint>> scanned) {
        return Collections.unmodifiableSet(this.serverEndpointConfigs);
    }

    @Override
    public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
        return Collections.unmodifiableSet(this.annotatedClasses);
    }
}

