/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets.draft06;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.ProtocolError;
import org.glassfish.tyrus.websockets.StrictUtf8;
import org.glassfish.tyrus.websockets.Utf8DecodingError;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.frametypes.ClosingFrameType;

public class ClosingFrame
extends DataFrame {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int code = 1000;
    private String reason;

    public ClosingFrame() {
        super(new ClosingFrameType());
    }

    public ClosingFrame(int code, String reason) {
        super(new ClosingFrameType());
        if (code > 0) {
            this.code = code;
        }
        this.reason = reason;
    }

    public ClosingFrame(byte[] data) {
        super(new ClosingFrameType());
        this.setPayload(data);
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public void setPayload(byte[] bytes) {
        if (bytes.length == 1) {
            throw new ProtocolError("Closing frame payload, if present, must be a minimum of 2 bytes in length");
        }
        if (bytes.length > 0) {
            this.code = (int)WebSocketEngine.toLong(bytes, 0, 2);
            if (this.code < 1000 || this.code == 1004 || this.code == 1005 || this.code == 1006 || this.code > 1011 && this.code < 3000 || this.code > 4999) {
                throw new ProtocolError("Illegal status code: " + this.code);
            }
            if (bytes.length > 2) {
                this.utf8Decode(bytes);
            }
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.code == -1) {
            return EMPTY_BYTES;
        }
        byte[] bytes = WebSocketEngine.toArray(this.code);
        byte[] reasonBytes = this.reason == null ? EMPTY_BYTES : this.reason.getBytes(new StrictUtf8());
        byte[] frameBytes = new byte[2 + reasonBytes.length];
        System.arraycopy(bytes, bytes.length - 2, frameBytes, 0, 2);
        System.arraycopy(reasonBytes, 0, frameBytes, 2, reasonBytes.length);
        return frameBytes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClosingFrame");
        sb.append("{code=").append(this.code);
        sb.append(", reason=").append(this.reason == null ? null : "'" + this.reason + "'");
        sb.append('}');
        return sb.toString();
    }

    private void utf8Decode(byte[] data) {
        CharBuffer cb;
        CharsetDecoder decoder;
        block2: {
            ByteBuffer b = ByteBuffer.wrap(data, 2, data.length - 2);
            StrictUtf8 charset = new StrictUtf8();
            decoder = ((Charset)charset).newDecoder();
            int n = (int)((float)b.remaining() * decoder.averageCharsPerByte());
            cb = CharBuffer.allocate(n);
            while (true) {
                CoderResult result;
                if ((result = decoder.decode(b, cb, true)).isUnderflow()) break block2;
                if (result.isOverflow()) {
                    CharBuffer tmp = CharBuffer.allocate(2 * n + 1);
                    cb.flip();
                    tmp.put(cb);
                    cb = tmp;
                    continue;
                }
                if (result.isError() || result.isMalformed()) break;
            }
            throw new Utf8DecodingError("Illegal UTF-8 Sequence");
        }
        decoder.flush(cb);
        cb.flip();
        this.reason = cb.toString();
    }
}

