/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.websocket.DeploymentException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLConnectionContext;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.tyrus.client.SslEngineConfigurator;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientFilter;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyTransportTimeoutFilter;
import org.glassfish.tyrus.container.grizzly.client.HttpCodecFilter;
import org.glassfish.tyrus.core.TyrusFuture;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.UpgradeRequest;

public class GrizzlyClientSocket {
    public static final String PROXY_URI = "org.glassfish.tyrus.client.proxy";
    public static final String PROXY_HEADERS = "org.glassfish.tyrus.client.proxy.headers";
    public static final String WORKER_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.workerThreadPoolConfig";
    public static final String SELECTOR_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.selectorThreadPoolConfig";
    private static final Logger LOGGER = Logger.getLogger(GrizzlyClientSocket.class.getName());
    private final List<Proxy> proxies = new ArrayList<Proxy>();
    private final long timeoutMs;
    private final ThreadPoolConfig workerThreadPoolConfig;
    private final ThreadPoolConfig selectorThreadPoolConfig;
    private final ClientEngine clientEngine;
    private final boolean sharedTransport;
    private final Integer sharedTransportTimeout;
    private final Map<String, String> proxyHeaders;
    private final Map<String, Object> properties;
    private static volatile TCPNIOTransport transport;
    private static final Object TRANSPORT_LOCK;
    private final Callable<Void> grizzlyConnector;
    private volatile TCPNIOTransport privateTransport;

    GrizzlyClientSocket(long timeoutMs, ClientEngine clientEngine, Map<String, Object> properties) throws DeploymentException {
        this.timeoutMs = timeoutMs;
        this.properties = properties;
        this.proxyHeaders = this.getProxyHeaders(properties);
        try {
            String property;
            this.workerThreadPoolConfig = this.getWorkerThreadPoolConfig(properties);
            this.selectorThreadPoolConfig = Utils.getProperty(properties, SELECTOR_THREAD_POOL_CONFIG, ThreadPoolConfig.class);
            Boolean shared = Utils.getProperty(properties, "org.glassfish.tyrus.client.sharedContainer", Boolean.class);
            if ((shared == null || !shared.booleanValue()) && (property = System.getProperty("org.glassfish.tyrus.client.sharedContainer")) != null && property.equals("true")) {
                shared = true;
            }
            boolean bl = this.sharedTransport = shared == null ? false : shared;
            if (this.sharedTransport) {
                GrizzlyTransportTimeoutFilter.touch();
            }
            Integer sharedTransportTimeoutProperty = Utils.getProperty(properties, "org.glassfish.tyrus.client.sharedContainerIdleTimeout", Integer.class);
            this.sharedTransportTimeout = this.sharedTransport && sharedTransportTimeoutProperty != null ? sharedTransportTimeoutProperty : 30;
            this.clientEngine = clientEngine;
        }
        catch (RuntimeException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
        this.grizzlyConnector = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GrizzlyClientSocket.this._connect();
                return null;
            }
        };
    }

    public void connect() throws DeploymentException, IOException {
        try {
            this.grizzlyConnector.call();
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    private ThreadPoolConfig getWorkerThreadPoolConfig(Map<String, Object> properties) {
        if (properties.containsKey(WORKER_THREAD_POOL_CONFIG)) {
            return Utils.getProperty(properties, WORKER_THREAD_POOL_CONFIG, ThreadPoolConfig.class);
        }
        if (properties.containsKey("org.glassfish.tyrus.client.workerThreadPoolConfig")) {
            Object threadPoolConfig = Utils.getProperty(properties, "org.glassfish.tyrus.client.workerThreadPoolConfig", Object.class);
            if (threadPoolConfig instanceof org.glassfish.tyrus.client.ThreadPoolConfig) {
                org.glassfish.tyrus.client.ThreadPoolConfig clientThreadPoolConfig = (org.glassfish.tyrus.client.ThreadPoolConfig)threadPoolConfig;
                ThreadPoolConfig grizzlyThreadPoolConfig = ThreadPoolConfig.defaultConfig();
                grizzlyThreadPoolConfig.setMaxPoolSize(clientThreadPoolConfig.getMaxPoolSize()).setCorePoolSize(clientThreadPoolConfig.getCorePoolSize()).setPriority(clientThreadPoolConfig.getPriority()).setDaemon(clientThreadPoolConfig.isDaemon()).setKeepAliveTime(clientThreadPoolConfig.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).setInitialClassLoader(clientThreadPoolConfig.getInitialClassLoader()).setPoolName(clientThreadPoolConfig.getPoolName()).setQueue(clientThreadPoolConfig.getQueue()).setQueueLimit(clientThreadPoolConfig.getQueueLimit()).setThreadFactory(clientThreadPoolConfig.getThreadFactory());
                return grizzlyThreadPoolConfig;
            }
            if (threadPoolConfig instanceof ThreadPoolConfig) {
                return (ThreadPoolConfig)threadPoolConfig;
            }
            LOGGER.log(Level.CONFIG, String.format("Invalid type of configuration property of %s (%s), %s cannot be cast to %s or %s", "org.glassfish.tyrus.client.workerThreadPoolConfig", threadPoolConfig.toString(), threadPoolConfig.getClass().toString(), ThreadPoolConfig.class.toString(), org.glassfish.tyrus.client.ThreadPoolConfig.class.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _connect() throws IOException, DeploymentException {
        try {
            if (this.sharedTransport) {
                transport = GrizzlyClientSocket.getOrCreateSharedTransport(this.workerThreadPoolConfig, this.selectorThreadPoolConfig);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Transport failed to start.", e);
            Object object = TRANSPORT_LOCK;
            synchronized (object) {
                transport = null;
            }
            throw e;
        }
        ClientEngine.TimeoutHandler timeoutHandler = this.sharedTransport ? null : new ClientEngine.TimeoutHandler(){

            @Override
            public void handleTimeout() {
                GrizzlyClientSocket.this.closeTransport(GrizzlyClientSocket.this.privateTransport);
            }
        };
        UpgradeRequest upgradeRequest = this.clientEngine.createUpgradeRequest(timeoutHandler);
        URI requestURI = upgradeRequest.getRequestURI();
        SocketAddress socketAddress = this.processProxy(requestURI, this.properties);
        Throwable exception = null;
        for (Proxy proxy : this.proxies) {
            SocketAddress connectAddress;
            if (!this.sharedTransport) {
                this.privateTransport = GrizzlyClientSocket.createTransport(this.workerThreadPoolConfig, this.selectorThreadPoolConfig);
                this.privateTransport.start();
            }
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.sharedTransport ? transport : this.privateTransport){};
            connectorHandler.setSyncConnectTimeout(this.timeoutMs, TimeUnit.MILLISECONDS);
            switch (proxy.type()) {
                case DIRECT: {
                    try {
                        connectAddress = new InetSocketAddress(requestURI.getHost(), Utils.getWsPort(requestURI));
                    }
                    catch (IllegalArgumentException e) {
                        this.closeTransport(this.privateTransport);
                        throw new DeploymentException(e.getMessage(), e);
                    }
                    LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' (no proxy).", requestURI));
                    break;
                }
                default: {
                    InetSocketAddress inetSocketAddress;
                    LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' via proxy '%s'.", requestURI, proxy));
                    SocketAddress address = proxy.address();
                    if (address instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)address).isUnresolved()) {
                        address = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                    }
                    connectAddress = address;
                }
            }
            TyrusFuture<Void> sslHandshakeFuture = null;
            ExtendedSSLEngineConfigurator clientSSLEngineConfigurator = this.getSSLEngineConfigurator(requestURI, this.properties);
            if (clientSSLEngineConfigurator != null) {
                sslHandshakeFuture = new TyrusFuture<Void>();
            }
            connectorHandler.setProcessor(GrizzlyClientSocket.createFilterChain(this.clientEngine, null, clientSSLEngineConfigurator, proxy.type() != Proxy.Type.DIRECT, requestURI, this.sharedTransport, this.sharedTransportTimeout, this.proxyHeaders, this.grizzlyConnector, sslHandshakeFuture, upgradeRequest));
            InetAddress bindingAddress = Utils.getProperty(this.properties, "org.glassfish.tyrus.client.socketBinding", InetAddress.class);
            GrizzlyFuture connectionGrizzlyFuture = bindingAddress == null ? connectorHandler.connect(connectAddress) : connectorHandler.connect(socketAddress, (SocketAddress)new InetSocketAddress(bindingAddress, 0));
            try {
                Connection connection = (Connection)connectionGrizzlyFuture.get(this.timeoutMs, TimeUnit.MILLISECONDS);
                if (sslHandshakeFuture != null) {
                    try {
                        sslHandshakeFuture.get(this.timeoutMs, TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        this.closeTransport(this.privateTransport);
                        throw new DeploymentException("SSL handshake has failed", e.getCause());
                    }
                    catch (Exception e) {
                        this.closeTransport(this.privateTransport);
                        throw new DeploymentException(String.format("Connection to '%s' failed.", requestURI), e.getCause());
                    }
                }
                LOGGER.log(Level.CONFIG, String.format("Connected to '%s'.", connection.getPeerAddress()));
                return;
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", requestURI), interruptedException);
                exception = interruptedException;
                this.closeTransport(this.privateTransport);
            }
            catch (TimeoutException timeoutException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", requestURI), timeoutException);
                exception = timeoutException;
                this.closeTransport(this.privateTransport);
            }
            catch (ExecutionException executionException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", requestURI), executionException);
                exception = executionException.getCause();
                if (exception != null && exception instanceof IOException) {
                    IOException ioException = (IOException)exception;
                    ProxySelector.getDefault().connectFailed(requestURI, socketAddress, ioException);
                }
                this.closeTransport(this.privateTransport);
            }
        }
        throw new DeploymentException("Connection failed.", exception);
    }

    private static TCPNIOTransport createTransport(ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig) {
        return GrizzlyClientSocket.createTransport(workerThreadPoolConfig, selectorThreadPoolConfig, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static TCPNIOTransport createTransport(ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig, boolean sharedTransport) {
        TCPNIOTransportBuilder transportBuilder = TCPNIOTransportBuilder.newInstance();
        transportBuilder.setReuseAddress(false);
        if (workerThreadPoolConfig == null) {
            if (sharedTransport) {
                transportBuilder.setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig());
            } else {
                transportBuilder.setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig().setMaxPoolSize(2).setCorePoolSize(2));
            }
        } else {
            transportBuilder.setWorkerThreadPoolConfig(workerThreadPoolConfig);
        }
        if (selectorThreadPoolConfig != null) {
            transportBuilder.setSelectorThreadPoolConfig(selectorThreadPoolConfig);
            return transportBuilder.build();
        }
        if (sharedTransport) {
            transportBuilder.setSelectorThreadPoolConfig(ThreadPoolConfig.defaultConfig());
            return transportBuilder.build();
        }
        transportBuilder.setSelectorThreadPoolConfig(ThreadPoolConfig.defaultConfig().setMaxPoolSize(1).setCorePoolSize(1));
        TCPNIOTransport transport = transportBuilder.build();
        transport.setSelectorRunnersCount(1);
        return transport;
    }

    private Map<String, String> getProxyHeaders(Map<String, Object> properties) throws DeploymentException {
        HashMap<String, String> proxyHeaders = Utils.getProperty(properties, PROXY_HEADERS, Map.class);
        String wlsProxyUsername = null;
        String wlsProxyPassword = null;
        Object value = properties.get("weblogic.websocket.client.PROXY_USERNAME");
        if (value != null) {
            if (value instanceof String) {
                wlsProxyUsername = (String)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_USERNAME only accept String values.");
            }
        }
        if ((value = properties.get("weblogic.websocket.client.PROXY_PASSWORD")) != null) {
            if (value instanceof String) {
                wlsProxyPassword = (String)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_PASSWORD only accept String values.");
            }
        }
        if (proxyHeaders == null) {
            if (wlsProxyUsername != null && wlsProxyPassword != null) {
                proxyHeaders = new HashMap<String, String>();
                proxyHeaders.put("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((wlsProxyUsername + ":" + wlsProxyPassword).getBytes(Charset.forName("UTF-8"))));
            }
        } else {
            boolean proxyAuthPresent = false;
            for (Map.Entry entry : proxyHeaders.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("Proxy-Authorization")) continue;
                proxyAuthPresent = true;
            }
            if (!proxyAuthPresent && wlsProxyUsername != null && wlsProxyPassword != null) {
                proxyHeaders.put("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((wlsProxyUsername + ":" + wlsProxyPassword).getBytes(Charset.forName("UTF-8"))));
            }
        }
        return proxyHeaders;
    }

    private SocketAddress processProxy(URI uri, Map<String, Object> properties) throws DeploymentException {
        String wlsProxyHost = null;
        Integer wlsProxyPort = null;
        Object value = properties.get("weblogic.websocket.client.PROXY_HOST");
        if (value != null) {
            if (value instanceof String) {
                wlsProxyHost = (String)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_HOST only accept String values.");
            }
        }
        if ((value = properties.get("weblogic.websocket.client.PROXY_PORT")) != null) {
            if (value instanceof Integer) {
                wlsProxyPort = (Integer)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_PORT only accept Integer values.");
            }
        }
        if (wlsProxyHost != null) {
            this.proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(wlsProxyHost, wlsProxyPort == null ? 80 : wlsProxyPort)));
        } else {
            Object proxyString = properties.get(PROXY_URI);
            try {
                if (proxyString != null) {
                    URI proxyUri = new URI(proxyString.toString());
                    if (proxyUri.getHost() == null) {
                        LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString));
                    } else {
                        int proxyPort = proxyUri.getPort() == -1 ? 80 : proxyUri.getPort();
                        this.proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyPort)));
                    }
                }
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString), e);
            }
        }
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector != null) {
            this.addProxies(proxySelector, uri, "socket", this.proxies);
            this.addProxies(proxySelector, uri, "https", this.proxies);
            this.addProxies(proxySelector, uri, "http", this.proxies);
        }
        if (this.proxies.isEmpty()) {
            this.proxies.add(Proxy.NO_PROXY);
        }
        int port = Utils.getWsPort(uri);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("Not using proxy for URI '%s'.", uri));
        }
        return new InetSocketAddress(uri.getHost(), port);
    }

    private void addProxies(ProxySelector proxySelector, URI uri, String scheme, List<Proxy> proxies) {
        for (Proxy p : proxySelector.select(this.getProxyUri(uri, scheme))) {
            switch (p.type()) {
                case HTTP: {
                    LOGGER.log(Level.FINE, String.format("Found proxy: '%s'", p));
                    proxies.add(p);
                    break;
                }
                case SOCKS: {
                    LOGGER.log(Level.INFO, String.format("Socks proxy is not supported, please file new issue at https://java.net/jira/browse/TYRUS. Proxy '%s' will be ignored.", p));
                    break;
                }
            }
        }
    }

    private URI getProxyUri(URI wsUri, String scheme) {
        try {
            return new URI(scheme, wsUri.getUserInfo(), wsUri.getHost(), wsUri.getPort(), wsUri.getPath(), wsUri.getQuery(), wsUri.getFragment());
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, String.format("Exception during generating proxy URI '%s'", wsUri), e);
            return wsUri;
        }
    }

    private static Processor createFilterChain(ClientEngine engine, SSLEngineConfigurator serverSSLEngineConfigurator, final ExtendedSSLEngineConfigurator clientSSLEngineConfigurator, boolean proxy, final URI uri, boolean sharedTransport, Integer sharedTransportTimeout, Map<String, String> proxyHeaders, Callable<Void> grizzlyConnector, final TyrusFuture<Void> sslHandshakeFuture, UpgradeRequest upgradeRequest) {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        Object sslFilter = null;
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        if (serverSSLEngineConfigurator != null || clientSSLEngineConfigurator != null) {
            sslFilter = new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator){
                {
                    super(x0, x1);
                    this.addHandshakeListener(new SSLBaseFilter.HandshakeListener(){

                        public void onStart(Connection connection) {
                        }

                        public void onComplete(Connection connection) {
                            SSLConnectionContext sslCtx = this.obtainSslConnectionContext(connection);
                            SSLEngine sslEngine = sslCtx.getSslEngine();
                            HostnameVerifier customHostnameVerifier = clientSSLEngineConfigurator.hostnameVerifier;
                            if (customHostnameVerifier != null && !customHostnameVerifier.verify(uri.getHost(), sslEngine.getSession())) {
                                sslHandshakeFuture.setFailure(new SSLException("Server host name verification using " + customHostnameVerifier.getClass() + " has failed"));
                                connection.terminateSilently();
                            } else {
                                sslHandshakeFuture.setResult(null);
                            }
                        }

                        public void onFailure(Connection connection, Throwable t) {
                            sslHandshakeFuture.setFailure(t);
                            connection.terminateSilently();
                        }
                    });
                }

                protected void notifyHandshakeFailed(Connection connection, Throwable t) {
                    sslHandshakeFuture.setFailure(t);
                    connection.terminateSilently();
                }
            };
            if (proxy) {
                sslFilter = new FilterWrapper((Filter)sslFilter);
            }
            clientFilterChainBuilder.add((Filter)sslFilter);
        }
        if (sharedTransport) {
            clientFilterChainBuilder.add((Filter)new GrizzlyTransportTimeoutFilter(sharedTransportTimeout));
        }
        HttpCodecFilter httpCodecFilter = new HttpCodecFilter();
        clientFilterChainBuilder.add((Filter)httpCodecFilter);
        clientFilterChainBuilder.add((Filter)new GrizzlyClientFilter(engine, proxy, (Filter)sslFilter, httpCodecFilter, uri, sharedTransport, proxyHeaders, grizzlyConnector, upgradeRequest));
        return clientFilterChainBuilder.build();
    }

    private void closeTransport(TCPNIOTransport transport) {
        if (transport != null) {
            try {
                transport.shutdownNow();
            }
            catch (IOException e) {
                Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.INFO, "Exception thrown when closing Grizzly transport: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TCPNIOTransport getOrCreateSharedTransport(ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig) throws IOException {
        Object object = TRANSPORT_LOCK;
        synchronized (object) {
            if (transport == null) {
                Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.FINE, "Starting shared container.");
                transport = GrizzlyClientSocket.createTransport(workerThreadPoolConfig, selectorThreadPoolConfig, true);
                transport.start();
            }
        }
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeSharedTransport() {
        Object object = TRANSPORT_LOCK;
        synchronized (object) {
            if (transport != null) {
                try {
                    Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.FINE, "Stopping shared container.");
                    transport.shutdownNow();
                }
                catch (IOException e) {
                    Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.INFO, "Exception thrown when closing Grizzly transport: " + e.getMessage(), e);
                }
            }
            transport = null;
        }
    }

    private ExtendedSSLEngineConfigurator getSSLEngineConfigurator(URI uri, Map<String, Object> properties) {
        Object configuratorObject = properties.get("org.glassfish.tyrus.client.sslEngineConfigurator");
        if (configuratorObject == null) {
            if ("wss".equalsIgnoreCase(uri.getScheme())) {
                SSLContextConfigurator defaultConfig = new SSLContextConfigurator();
                defaultConfig.retrieve(System.getProperties());
                return new ExtendedSSLEngineConfigurator(defaultConfig.createSSLContext(), uri.getHost());
            }
            return null;
        }
        if (configuratorObject instanceof SSLEngineConfigurator) {
            return new ExtendedSSLEngineConfigurator((SSLEngineConfigurator)configuratorObject, uri.getHost());
        }
        if (configuratorObject instanceof SslEngineConfigurator) {
            return new ExtendedSSLEngineConfigurator((SslEngineConfigurator)configuratorObject, uri.getHost());
        }
        LOGGER.log(Level.CONFIG, String.format("Invalid type of configuration property of %s (%s), %s cannot be cast to %s or %s", "org.glassfish.tyrus.client.sslEngineConfigurator", configuratorObject.toString(), configuratorObject.getClass().toString(), SSLEngineConfigurator.class.toString(), SslEngineConfigurator.class.toString()));
        return null;
    }

    static {
        TRANSPORT_LOCK = new Object();
    }

    private static class ExtendedSSLEngineConfigurator
    extends SSLEngineConfigurator {
        private final HostnameVerifier hostnameVerifier;
        private final boolean hostVerificationEnabled;
        private final String peerHost;

        ExtendedSSLEngineConfigurator(SSLContext sslContext, String peerHost) {
            super(sslContext, true, false, false);
            this.hostnameVerifier = null;
            this.hostVerificationEnabled = true;
            this.peerHost = peerHost;
        }

        ExtendedSSLEngineConfigurator(SSLEngineConfigurator sslEngineConfigurator, String peerHost) {
            super(sslEngineConfigurator.getSslContext(), sslEngineConfigurator.isClientMode(), sslEngineConfigurator.isNeedClientAuth(), sslEngineConfigurator.isWantClientAuth());
            this.hostnameVerifier = null;
            this.hostVerificationEnabled = true;
            this.peerHost = peerHost;
        }

        ExtendedSSLEngineConfigurator(SslEngineConfigurator sslEngineConfigurator, String peerHost) {
            super(sslEngineConfigurator.getSslContext(), sslEngineConfigurator.isClientMode(), sslEngineConfigurator.isNeedClientAuth(), sslEngineConfigurator.isWantClientAuth());
            this.hostnameVerifier = sslEngineConfigurator.getHostnameVerifier();
            this.hostVerificationEnabled = sslEngineConfigurator.isHostVerificationEnabled();
            this.peerHost = peerHost;
        }

        public SSLEngine createSSLEngine(String peerHost, int peerPort) {
            SSLEngine sslEngine = super.createSSLEngine(this.peerHost, peerPort);
            if (this.hostVerificationEnabled && this.hostnameVerifier == null) {
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                sslEngine.setSSLParameters(sslParameters);
            }
            return sslEngine;
        }
    }

    static class FilterWrapper
    implements Filter {
        private final Filter filter;
        private boolean enabled;
        private volatile FilterChain filterChain;

        FilterWrapper(Filter filter) {
            this.filter = filter;
        }

        public void enable() {
            if (!this.enabled && this.filterChain != null) {
                this.filter.onAdded(this.filterChain);
            }
            this.enabled = true;
        }

        public void onAdded(FilterChain filterChain) {
            this.filterChain = filterChain;
            if (this.enabled) {
                this.filter.onAdded(filterChain);
            }
        }

        public void onRemoved(FilterChain filterChain) {
            this.filter.onRemoved(filterChain);
            if (this.enabled) {
                this.filter.onRemoved(filterChain);
            }
        }

        public void onFilterChainChanged(FilterChain filterChain) {
            this.filter.onFilterChainChanged(filterChain);
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleRead(ctx);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleWrite(ctx);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleConnect(FilterChainContext ctx) throws IOException {
            return ctx.getInvokeAction();
        }

        public NextAction handleAccept(FilterChainContext ctx) throws IOException {
            return ctx.getInvokeAction();
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            if (this.enabled) {
                return this.filter.handleEvent(ctx, event);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleClose(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleClose(ctx);
            }
            return ctx.getInvokeAction();
        }

        public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
            if (this.enabled) {
                this.filter.exceptionOccurred(ctx, error);
            } else {
                ctx.getInvokeAction();
            }
        }
    }
}

