/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.spi.ServerContainer;

public abstract class TyrusServerContainer
extends BaseContainer
implements ServerContainer {
    private final ErrorCollector collector;
    private final Set<Class<?>> dynamicallyAddedClasses;
    private final Set<ServerEndpointConfig> dynamicallyAddedEndpointConfigs;
    private final Set<Class<?>> classes;
    private final ServerApplicationConfig serverApplicationConfig;
    private boolean canDeploy = true;
    private long defaultMaxSessionIdleTimeout = 0L;
    private long defaultAsyncSendTimeout = 0L;
    private int maxTextMessageBufferSize = Integer.MAX_VALUE;
    private int maxBinaryMessageBufferSize = Integer.MAX_VALUE;
    private ClientManager clientManager = null;
    private volatile int port = -1;

    public TyrusServerContainer(Set<Class<?>> classes) {
        this.collector = new ErrorCollector();
        this.classes = classes == null ? Collections.emptySet() : new HashSet(classes);
        this.dynamicallyAddedClasses = new HashSet();
        this.dynamicallyAddedEndpointConfigs = new HashSet<ServerEndpointConfig>();
        this.serverApplicationConfig = null;
    }

    public TyrusServerContainer(ServerApplicationConfig serverApplicationConfig) {
        this.collector = new ErrorCollector();
        this.classes = new HashSet();
        this.dynamicallyAddedClasses = new HashSet();
        this.dynamicallyAddedEndpointConfigs = new HashSet<ServerEndpointConfig>();
        this.serverApplicationConfig = serverApplicationConfig;
    }

    @Override
    public void start(String rootPath, int port) throws IOException, DeploymentException {
        TyrusServerConfiguration configuration = new TyrusServerConfiguration(this.classes, this.dynamicallyAddedClasses, this.dynamicallyAddedEndpointConfigs, this.collector);
        try {
            for (Class<?> clazz : configuration.getAnnotatedEndpointClasses(null)) {
                this.register(clazz);
            }
            for (ServerEndpointConfig serverEndpointConfig : configuration.getEndpointConfigs(null)) {
                if (serverEndpointConfig == null) continue;
                this.register(serverEndpointConfig);
            }
            if (this.serverApplicationConfig != null) {
                for (Class clazz : this.serverApplicationConfig.getAnnotatedEndpointClasses(null)) {
                    this.register(clazz);
                }
                for (ServerEndpointConfig serverEndpointConfig : this.serverApplicationConfig.getEndpointConfigs(null)) {
                    if (serverEndpointConfig == null) continue;
                    this.register(serverEndpointConfig);
                }
            }
        }
        catch (DeploymentException de) {
            this.collector.addException(de);
        }
        if (!this.collector.isEmpty()) {
            this.stop();
            throw this.collector.composeComprehensiveException();
        }
        if (this.port == -1) {
            this.port = port;
        }
    }

    @Override
    public void stop() {
        this.shutdown();
    }

    public abstract void register(Class<?> var1) throws DeploymentException;

    public abstract void register(ServerEndpointConfig var1) throws DeploymentException;

    @Override
    public void addEndpoint(Class<?> endpointClass) throws DeploymentException {
        if (!this.canDeploy) {
            throw new IllegalStateException("Not in 'deploy' scope.");
        }
        this.dynamicallyAddedClasses.add(endpointClass);
    }

    @Override
    public void addEndpoint(ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
        if (!this.canDeploy) {
            throw new IllegalStateException("Not in 'deploy' scope.");
        }
        this.dynamicallyAddedEndpointConfigs.add(serverEndpointConfig);
    }

    public int getPort() {
        return this.port;
    }

    protected synchronized ClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = ClientManager.createClient(this);
        }
        return this.clientManager;
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        return this.getClientManager().connectToServer(annotatedEndpointClass, path);
    }

    @Override
    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        return this.getClientManager().connectToServer(endpointClass, cec, path);
    }

    @Override
    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        return this.getClientManager().connectToServer(annotatedEndpointInstance, path);
    }

    @Override
    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        return this.getClientManager().connectToServer(endpointInstance, cec, path);
    }

    public Future<Session> asyncConnectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException {
        return this.getClientManager().asyncConnectToServer(annotatedEndpointClass, path);
    }

    public Future<Session> asyncConnectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.getClientManager().asyncConnectToServer(endpointClass, cec, path);
    }

    public Future<Session> asyncConnectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException {
        return this.getClientManager().asyncConnectToServer(endpointInstance, cec, path);
    }

    public Future<Session> asyncConnectToServer(Object obj, URI path) throws DeploymentException {
        return this.getClientManager().asyncConnectToServer(obj, path);
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.maxBinaryMessageBufferSize = max;
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.maxTextMessageBufferSize = max;
    }

    @Override
    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    @Override
    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long defaultMaxSessionIdleTimeout) {
        this.defaultMaxSessionIdleTimeout = defaultMaxSessionIdleTimeout;
    }

    public void doneDeployment() {
        this.canDeploy = false;
    }
}

