/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.websocket.WebSocketContainer;
import org.glassfish.tyrus.websockets.ExecutorServiceProvider;

public abstract class BaseContainer
extends ExecutorServiceProvider
implements WebSocketContainer {
    private final ExecutorService executorService = BaseContainer.newExecutorService();

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private static ExecutorService newExecutorService() {
        ExecutorService es = null;
        if (es == null) {
            es = Executors.newCachedThreadPool(new DaemonThreadFactory());
        }
        return es;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix = "tyrus-" + poolNumber.getAndIncrement() + "-thread-";

        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(null, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

