/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.FramingException;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;

public class TyrusHttpUpgradeHandler
implements HttpUpgradeHandler,
ReadListener {
    private ServletInputStream is;
    private ServletOutputStream os;
    private WebConnection wc;
    private ByteBuffer buf;
    private boolean closed = false;
    private boolean initiated = false;
    private static final Logger LOGGER = Logger.getLogger(TyrusHttpUpgradeHandler.class.getName());
    private WebSocketEngine.WebSocketHolder webSocketHolder;

    public void init(WebConnection wc) {
        LOGGER.config("Servlet 3.1 Upgrade");
        try {
            this.is = wc.getInputStream();
            this.os = wc.getOutputStream();
            this.wc = wc;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        try {
            this.is.setReadListener((ReadListener)this);
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        this.initiated = true;
        if (this.webSocketHolder != null && this.webSocketHolder.webSocket != null) {
            this.webSocketHolder.webSocket.onConnect();
        }
    }

    public void onDataAvailable() {
        try {
            this.fillBuf(this.is.available());
            LOGGER.finest("Remaining Data = " + this.buf.remaining());
            if (this.buf != null && this.buf.hasRemaining()) {
                DataFrame result;
                while (this.buf.remaining() > 0 && (result = this.webSocketHolder.handler.unframe(this.buf)) != null) {
                    result.respond(this.webSocketHolder.webSocket);
                }
            }
        }
        catch (FramingException e) {
            String message = e.getMessage();
            this.webSocketHolder.webSocket.onClose(new ClosingFrame(e.getClosingCode(), message == null ? "No reason given." : message));
            try {
                if (!this.closed) {
                    this.wc.close();
                    this.closed = true;
                }
            }
            catch (Exception f) {
                LOGGER.log(Level.CONFIG, f.getMessage(), f);
            }
        }
        catch (Exception wse) {
            if (this.webSocketHolder.application.onError(this.webSocketHolder.webSocket, wse)) {
                String message = wse.getMessage();
                this.webSocketHolder.webSocket.onClose(new ClosingFrame(1011, message == null ? "No reason given." : message));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (this.is.isReady()) {
                LOGGER.log(Level.SEVERE, "This shouldn't happen. ServletInputStream.isReady() returned true after reading all available() data.");
            }
        }
    }

    private void fillBuf(int length) throws IOException {
        byte[] data = new byte[length];
        int len = this.is.read(data);
        if (len == 0) {
            throw new RuntimeException("No data available.");
        }
        if (this.buf == null) {
            LOGGER.finest("No Buffer. Allocating new one");
            this.buf = ByteBuffer.wrap(data);
            this.buf.limit(len);
        } else {
            int limit = this.buf.limit();
            int capacity = this.buf.capacity();
            int remaining = this.buf.remaining();
            if (capacity - limit >= len) {
                LOGGER.finest("Remaining data need not be moved. New data is just appended");
                this.buf.mark();
                this.buf.position(limit);
                this.buf.limit(capacity);
                this.buf.put(data, 0, len);
                this.buf.limit(limit + len);
                this.buf.reset();
            } else if (remaining + len < capacity) {
                LOGGER.finest("Remaining data is moved to left. Then new data is appended");
                this.buf.compact();
                this.buf.put(data, 0, len);
                this.buf.flip();
            } else {
                LOGGER.finest("Remaining data + new > capacity. So allocate new one");
                byte[] array = new byte[remaining + len];
                this.buf.get(array, 0, remaining);
                System.arraycopy(data, 0, array, remaining, len);
                this.buf = ByteBuffer.wrap(array);
                this.buf.limit(remaining + len);
            }
        }
    }

    public void onAllDataRead() {
        this.webSocketHolder.webSocket.onClose(new ClosingFrame(1000, null));
    }

    public void onError(Throwable t) {
        if (t instanceof EOFException) {
            return;
        }
        String message = t == null ? null : t.getMessage();
        this.webSocketHolder.webSocket.onClose(new ClosingFrame(1000, message == null ? "No reason given." : message));
        try {
            if (!this.closed) {
                this.wc.close();
                this.closed = true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
        }
    }

    public void destroy() {
    }

    public void setWebSocketHolder(WebSocketEngine.WebSocketHolder webSocketHolder) {
        this.webSocketHolder = webSocketHolder;
        if (this.initiated) {
            webSocketHolder.webSocket.onConnect();
        }
    }

    WebConnection getWebConnection() {
        if (!this.initiated) {
            throw new IllegalStateException();
        }
        return this.wc;
    }
}

