/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.gf.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.tyrus.spi.ComponentProvider;

public class CdiComponentProvider
extends ComponentProvider {
    private final BeanManager beanManager;
    private static final Logger LOGGER = Logger.getLogger(CdiComponentProvider.class.getName());
    private final boolean managerRetrieved;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdiComponentProvider() throws NamingException {
        InitialContext ic = new InitialContext();
        BeanManager manager = null;
        try {
            this.beanManager = manager = (BeanManager)ic.lookup("java:comp/BeanManager");
            this.managerRetrieved = this.beanManager != null;
        }
        catch (Exception e) {
            try {
                LOGGER.fine(e.getMessage());
                this.beanManager = manager;
                this.managerRetrieved = this.beanManager != null;
            }
            catch (Throwable throwable) {
                this.beanManager = manager;
                this.managerRetrieved = this.beanManager != null;
                throw throwable;
            }
        }
    }

    @Override
    public boolean isApplicable(Class<?> c) {
        return this.managerRetrieved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T provideInstance(Class<T> c) {
        if (this.managerRetrieved) {
            BeanManager beanManager = this.beanManager;
            synchronized (beanManager) {
                Set beans = this.beanManager.getBeans(c, new Annotation[0]);
                if (beans.size() > 0) {
                    return (T)this.beanManager.getReference((Bean)beans.iterator().next(), c, this.beanManager.createCreationalContext(null));
                }
                return null;
            }
        }
        return null;
    }
}

