/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.glassfish.pfl.test.DOMElementWriter;
import org.glassfish.pfl.test.JUnitReportWriter;
import org.glassfish.pfl.test.XMLConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLJUnitReportWriter
implements JUnitReportWriter,
XMLConstants {
    private static final String UNKNOWN = "unknown";
    private Document doc;
    private Element rootElement;
    private Map<JUnitReportWriter.TestDescription, Element> testElements = new HashMap<JUnitReportWriter.TestDescription, Element>();
    private Set<JUnitReportWriter.TestDescription> failedTests = new HashSet<JUnitReportWriter.TestDescription>();
    private Map<JUnitReportWriter.TestDescription, Long> testStarts = new HashMap<JUnitReportWriter.TestDescription, Long>();
    private OutputStream out;
    private boolean filterTrace;
    private int runCount;
    private int failureCount;
    private int errorCount;
    private long startTime;
    private static final String[] DEFAULT_TRACE_FILTERS = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "java.lang.reflect.Method.invoke(", "sun.reflect.", "org.apache.tools.ant.", "org.junit.", "junit.framework.JUnit4TestAdapter", "Caused by: java.lang.AssertionError", " more"};

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public XMLJUnitReportWriter() {
        this(true);
    }

    public XMLJUnitReportWriter(boolean filter) {
        this.filterTrace = filter;
    }

    @Override
    public void setOutput(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setSystemOutput(String out) {
        this.formatOutput("system-out", out);
    }

    @Override
    public void setSystemError(String out) {
        this.formatOutput("system-err", out);
    }

    @Override
    public void startTestSuite(String name, Properties props) {
        this.runCount = 0;
        this.failureCount = 0;
        this.errorCount = 0;
        this.startTime = System.currentTimeMillis();
        this.doc = XMLJUnitReportWriter.getDocumentBuilder().newDocument();
        this.rootElement = this.doc.createElement("testsuite");
        this.rootElement.setAttribute("name", name == null ? UNKNOWN : name);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
        sdf.setLenient(true);
        String timestamp = sdf.format(new Date());
        this.rootElement.setAttribute("timestamp", timestamp);
        this.rootElement.setAttribute("hostname", this.getHostname());
        Element propsElement = this.doc.createElement("properties");
        this.rootElement.appendChild(propsElement);
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String str = (String)e.nextElement();
                Element propElement = this.doc.createElement("property");
                propElement.setAttribute("name", str);
                propElement.setAttribute("value", props.getProperty(str));
                propsElement.appendChild(propElement);
            }
        }
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    @Override
    public JUnitReportWriter.TestCounts endTestSuite() {
        long runTime = System.currentTimeMillis() - this.startTime;
        this.rootElement.setAttribute("tests", "" + this.runCount);
        this.rootElement.setAttribute("failures", "" + this.failureCount);
        this.rootElement.setAttribute("errors", "" + this.errorCount);
        this.rootElement.setAttribute("time", "" + (double)runTime / 1000.0);
        if (this.out == null) {
            throw new RuntimeException("Error: output file is null!");
        }
        BufferedWriter wri = null;
        try {
            wri = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
            wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            new DOMElementWriter().write(this.rootElement, wri, 0, "  ");
            ((Writer)wri).flush();
        }
        catch (IOException exc) {
            throw new RuntimeException("Unable to write log file", exc);
        }
        finally {
            if (this.out != System.out && this.out != System.err && wri != null) {
                try {
                    ((Writer)wri).close();
                }
                catch (IOException iOException) {}
            }
        }
        int pass = this.runCount - this.failureCount - this.errorCount;
        return new JUnitReportWriter.TestCounts(pass, this.failureCount, this.errorCount);
    }

    @Override
    public void startTest(JUnitReportWriter.TestDescription t) {
        this.testStarts.put(t, System.currentTimeMillis());
    }

    @Override
    public void endTest(JUnitReportWriter.TestDescription test, long duration) {
        Element elem = this.endTestHelper(test);
        elem.setAttribute("time", "" + duration);
    }

    @Override
    public void endTest(JUnitReportWriter.TestDescription test) {
        this.endTestHelper(test);
    }

    public Element endTestHelper(JUnitReportWriter.TestDescription test) {
        ++this.runCount;
        if (!this.testStarts.containsKey((Object)test)) {
            this.startTest(test);
        }
        Element currentTest = null;
        if (!this.failedTests.contains((Object)test)) {
            currentTest = this.doc.createElement("testcase");
            String n = test.getName();
            currentTest.setAttribute("name", n == null ? UNKNOWN : n);
            currentTest.setAttribute("classname", test.getClassName());
            this.rootElement.appendChild(currentTest);
            this.testElements.put(test, currentTest);
        } else {
            currentTest = this.testElements.get((Object)test);
        }
        long l = this.testStarts.get((Object)test);
        currentTest.setAttribute("time", "" + (double)(System.currentTimeMillis() - l) / 1000.0);
        return currentTest;
    }

    @Override
    public void addFailure(JUnitReportWriter.TestDescription test, Throwable t) {
        ++this.failureCount;
        this.formatError("failure", test, t);
    }

    @Override
    public void addError(JUnitReportWriter.TestDescription test, Throwable t) {
        ++this.errorCount;
        this.formatError("error", test, t);
    }

    private void formatError(String type, JUnitReportWriter.TestDescription test, Throwable t) {
        if (test != null) {
            this.endTest(test);
            this.failedTests.add(test);
        }
        Element nested = this.doc.createElement(type);
        Element currentTest = null;
        currentTest = test != null ? this.testElements.get((Object)test) : this.rootElement;
        currentTest.appendChild(nested);
        String message = t.getMessage();
        if (message != null && message.length() > 0) {
            nested.setAttribute("message", t.getMessage());
        }
        nested.setAttribute("type", t.getClass().getName());
        String strace = this.getFilteredTrace(t);
        Text trace = this.doc.createTextNode(strace);
        nested.appendChild(trace);
    }

    private void formatOutput(String type, String output) {
        Element nested = this.doc.createElement(type);
        this.rootElement.appendChild(nested);
        nested.appendChild(this.doc.createCDATASection(output));
    }

    private String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }

    private String getFilteredTrace(Throwable t) {
        String trace = this.getStackTrace(t);
        return this.filterStack(trace);
    }

    private String filterStack(String stack) {
        if (!this.filterTrace) {
            return stack;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (this.filterLine(line)) continue;
                pw.println(line);
            }
        }
        catch (Exception e) {
            return stack;
        }
        return sw.toString();
    }

    private boolean filterLine(String line) {
        for (int i = 0; i < DEFAULT_TRACE_FILTERS.length; ++i) {
            if (line.indexOf(DEFAULT_TRACE_FILTERS[i]) == -1) continue;
            return true;
        }
        return false;
    }
}

