/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.test;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.glassfish.pfl.test.TimedTest;

public class TestCaseTools {
    public static void reportTiming(int repCount, PrintStream out, List<TimedTest> timedTests) {
        for (TimedTest test : timedTests) {
            long duration = test.getDuration() / 1000L;
            double perTest = duration / (long)repCount;
            out.println((Object)test);
            out.println("\texecuted " + repCount + " times in " + duration + " microseconds (per test time is " + perTest + " microseconds)");
        }
    }

    private static String getSuffix(char ch, String str) {
        int index = str.lastIndexOf(ch);
        if (index == -1) {
            return null;
        }
        return str.substring(index + 1);
    }

    private static String makeTestSuiteName(Class cls) {
        String str = cls.getName();
        String result = TestCaseTools.getSuffix('$', str);
        if (result == null) {
            result = TestCaseTools.getSuffix('.', str);
        }
        if (result == null) {
            result = str;
        }
        return result;
    }

    public static TestSuite makeTestSuite(Class cls) {
        return TestCaseTools.makeTestSuite(cls, TestSuiteType.STANDARD);
    }

    public static TestSuite makeTestSuite(Class cls, TestSuiteType type) {
        Object result = type == TestSuiteType.STANDARD ? new TestSuite(cls) : new SingleInstanceTestSuite(cls);
        result.setName(TestCaseTools.makeTestSuiteName(cls));
        Class current = cls;
        while (Test.class.isAssignableFrom(current)) {
            Class<?>[] classes = current.getClasses();
            for (int i = 0; i < classes.length; ++i) {
                Class<?> next = classes[i];
                if (!next.getName().endsWith("TestSuite")) continue;
                result.addTest((Test)TestCaseTools.makeTestSuite(next, type));
            }
            current = current.getSuperclass();
        }
        return result;
    }

    public static enum TestSuiteType {
        STANDARD,
        SINGLE;

    }

    public static class SingleInstanceTestSuite
    extends TestSuite {
        private Test test = null;
        private Method setUpMethod = null;
        private Method tearDownMethod = null;
        private Method postMethod = null;

        public SingleInstanceTestSuite(Class theClass) {
            super(theClass.getName());
            if (!Modifier.isPublic(theClass.getModifiers())) {
                this.addTest(SingleInstanceTestSuite.warning((String)("Class " + theClass.getName() + " is not public")));
                return;
            }
            try {
                try {
                    Constructor constructor = theClass.getConstructor(String.class);
                    this.test = (Test)Test.class.cast(constructor.newInstance(""));
                }
                catch (NoSuchMethodException e) {
                    try {
                        Constructor constructor = theClass.getConstructor(new Class[0]);
                        this.test = (Test)Test.class.cast(constructor.newInstance(new Object[0]));
                    }
                    catch (NoSuchMethodException ex) {
                        this.addTest(SingleInstanceTestSuite.warning((String)("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()")));
                        e.printStackTrace();
                        return;
                    }
                }
            }
            catch (InstantiationException e) {
                this.addTest(SingleInstanceTestSuite.warning((String)("Cannot instantiate test case: " + this.getName() + " (" + this.exceptionToString(e) + ")")));
                e.printStackTrace();
                return;
            }
            catch (InvocationTargetException e) {
                this.addTest(SingleInstanceTestSuite.warning((String)("Exception in constructor: " + this.getName() + " (" + this.exceptionToString(e.getTargetException()) + ")")));
                e.printStackTrace();
                return;
            }
            catch (IllegalAccessException e) {
                this.addTest(SingleInstanceTestSuite.warning((String)("Cannot access test case: " + this.getName() + " (" + this.exceptionToString(e) + ")")));
                e.printStackTrace();
                return;
            }
            this.setUpMethod = this.getMethod(theClass, "setUp");
            this.tearDownMethod = this.getMethod(theClass, "tearDown");
            this.postMethod = this.getMethod(theClass, "post");
            Class superClass = theClass;
            Vector names = new Vector();
            while (Test.class.isAssignableFrom(superClass)) {
                Method[] methods = superClass.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    this.addTestMethod(methods[i], names, this.test);
                }
                superClass = superClass.getSuperclass();
            }
        }

        private Method getMethod(Class theClass, String name) {
            try {
                return theClass.getMethod(name, new Class[0]);
            }
            catch (Exception exc) {
                return null;
            }
        }

        private void addTestMethod(Method m, Vector names, Test test) {
            String name = m.getName();
            if (names.contains(name)) {
                return;
            }
            if (!this.isPublicTestMethod(m)) {
                if (this.isTestMethod(m)) {
                    this.addTest(SingleInstanceTestSuite.warning((String)("Test method isn't public: " + m.getName())));
                }
                return;
            }
            names.addElement(name);
            this.addTest((Test)new SingleInstanceTestCase(m));
        }

        private boolean isPublicTestMethod(Method m) {
            return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
        }

        private boolean isTestMethod(Method m) {
            String name = m.getName();
            Class<?>[] parameters = m.getParameterTypes();
            Class<?> returnType = m.getReturnType();
            return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
        }

        private String exceptionToString(Throwable t) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            t.printStackTrace(writer);
            return stringWriter.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TestResult result) {
            try {
                Enumeration e = this.tests();
                while (e.hasMoreElements()) {
                    if (result.shouldStop()) {
                        break;
                    }
                    Test test = (Test)e.nextElement();
                    this.runTest(test, result);
                }
            }
            finally {
                if (this.postMethod != null) {
                    try {
                        this.postMethod.invoke((Object)this.test, new Object[0]);
                    }
                    catch (Exception exc) {
                        this.runTest(this.doWarning("postMethod threw exception " + exc), result);
                    }
                }
            }
        }

        public void runTest(Test test, TestResult result) {
            test.run(result);
        }

        private Test doWarning(final String message) {
            return new TestCase("warning"){

                protected void runTest() {
                    1.fail((String)message);
                }
            };
        }

        private class SingleInstanceTestCase
        extends TestCase {
            private Method runMethod;

            public SingleInstanceTestCase(Method runMethod) {
                super(runMethod.getName());
                this.runMethod = runMethod;
                SingleInstanceTestCase.assertNotNull((Object)this.getName());
                if (!Modifier.isPublic(runMethod.getModifiers())) {
                    SingleInstanceTestCase.fail((String)("Method \"" + this.getName() + "\" should be public"));
                }
            }

            protected void setUp() {
                if (SingleInstanceTestSuite.this.setUpMethod != null) {
                    try {
                        SingleInstanceTestSuite.this.setUpMethod.invoke((Object)SingleInstanceTestSuite.this.test, new Object[0]);
                    }
                    catch (Exception exc) {
                        SingleInstanceTestCase.fail((String)("setUp method threw exception " + exc));
                        exc.printStackTrace();
                    }
                }
            }

            protected void tearDown() {
                if (SingleInstanceTestSuite.this.tearDownMethod != null) {
                    try {
                        SingleInstanceTestSuite.this.tearDownMethod.invoke((Object)SingleInstanceTestSuite.this.test, new Object[0]);
                    }
                    catch (Exception exc) {
                        SingleInstanceTestCase.fail((String)("tearDown method threw exception " + exc));
                        exc.printStackTrace();
                    }
                }
            }

            protected void runTest() throws Throwable {
                try {
                    this.runMethod.invoke((Object)SingleInstanceTestSuite.this.test, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    System.out.println("Error in invoking the method " + this.runMethod);
                    e.printStackTrace();
                    throw e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    throw e;
                }
            }
        }
    }
}

