/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.pfl.basic.tools.argparser.ArgParser;
import org.glassfish.pfl.basic.tools.argparser.DefaultValue;
import org.glassfish.pfl.basic.tools.argparser.Help;
import org.glassfish.pfl.basic.tools.argparser.Separator;
import org.glassfish.pfl.test.JUnitReportHelper;
import org.glassfish.pfl.test.Post;
import org.glassfish.pfl.test.Pre;
import org.glassfish.pfl.test.TestCase;

public class TestBase {
    private final List<Method> testMethods;
    private final List<String> currentResults;
    private final Arguments argvals;
    private final Set<String> includes;
    private final Set<String> excludes;
    private final List<Method> preMethods;
    private final List<Method> postMethods;
    private String current;
    private Set<String> pass = new HashSet<String>();
    private Set<String> fail = new HashSet<String>();
    private Set<String> skip = new HashSet<String>();
    private final Object testObject;
    JUnitReportHelper reportHelper = new JUnitReportHelper(this.getClass().getName());

    private void execute(Collection<Method> methods) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method m : methods) {
            m.invoke((Object)this, new Object[0]);
        }
    }

    public TestBase(String[] args) {
        this(args, null);
    }

    public TestBase(String[] args, Class<?> parserInterface) {
        this(args, parserInterface, null);
    }

    public TestBase(String[] args, Class<?> parserInterface, Object testObject) {
        Class[] classArray;
        this.testMethods = new ArrayList<Method>();
        this.preMethods = new ArrayList<Method>();
        this.postMethods = new ArrayList<Method>();
        this.testObject = testObject == null ? this : testObject;
        Class<?> cls = testObject == null ? this.getClass() : testObject.getClass();
        for (Method m : cls.getMethods()) {
            Post post;
            Pre pre;
            if (m.getDeclaringClass().equals(TestBase.class) && !this.getClass().equals(TestBase.class)) continue;
            TestCase anno = m.getAnnotation(TestCase.class);
            if (anno != null) {
                if (m.getParameterTypes().length == 0) {
                    if (m.getReturnType().equals(Void.TYPE)) {
                        this.testMethods.add(m);
                    } else {
                        this.msg("Method " + m + " is annotated @Test, but has a non-void return type").nl();
                    }
                } else {
                    this.msg("Method " + m + " is annotated @Test, but has parameters").nl();
                }
            }
            if ((pre = m.getAnnotation(Pre.class)) != null) {
                this.preMethods.add(m);
            }
            if ((post = m.getAnnotation(Post.class)) == null) continue;
            this.postMethods.add(m);
        }
        if (parserInterface == null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Arguments.class;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = Arguments.class;
            classArray = classArray3;
            classArray3[1] = parserInterface;
        }
        Class[] interfaces = classArray;
        ArgParser parser = new ArgParser(Arrays.asList(interfaces));
        this.argvals = (Arguments)parser.parse(args);
        if (this.argvals.debug()) {
            this.msg("Arguments are:\n" + this.argvals).nl();
        }
        if (this.argvals.include().isEmpty()) {
            this.includes = new HashSet<String>();
            for (Method m : this.testMethods) {
                this.includes.add(this.getTestId(m));
            }
        } else {
            List<String> incs = this.argvals.include();
            this.includes = new HashSet<String>(incs);
        }
        this.excludes = new HashSet<String>(this.argvals.exclude());
        if (this.argvals.cases()) {
            this.msg("Valid test case identifiers are:").nl();
            for (Method m : this.testMethods) {
                this.msg("    " + this.getTestId(m)).nl();
            }
        }
        this.currentResults = new ArrayList<String>();
    }

    public <T> T getArguments(Class<T> cls) {
        return cls.cast(this.argvals);
    }

    private TestBase msg(String str) {
        System.out.print(str);
        return this;
    }

    private TestBase nl() {
        System.out.println();
        return this;
    }

    private String getTestId(Method m) {
        TestCase anno = m.getAnnotation(TestCase.class);
        if (!anno.value().equals("")) {
            return anno.value();
        }
        String mname = m.getName();
        if (mname.startsWith("test")) {
            return mname.substring(4);
        }
        return mname;
    }

    private void display(String title, List<String> strs) {
        if (!strs.isEmpty()) {
            this.msg(title + ":").nl();
            for (String str : strs) {
                this.msg("\t" + str).nl();
            }
        }
    }

    private String getMessage(List<String> strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append(str);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        for (Method m : this.testMethods) {
            this.currentResults.clear();
            this.current = this.getTestId(m);
            if (this.includes.contains(this.current) && !this.excludes.contains(this.current)) {
                this.reportHelper.start(this.current);
                this.msg("Test " + this.current + ": ").nl();
                this.msg("    Notes:").nl();
                long start = System.currentTimeMillis();
                long duration = 0L;
                try {
                    this.execute(this.preMethods);
                    m.invoke(this.testObject, new Object[0]);
                }
                catch (Exception exc) {
                    this.fail("Caught exception : " + exc);
                    exc.printStackTrace();
                }
                finally {
                    try {
                        this.execute(this.postMethods);
                    }
                    catch (Exception exc) {
                        this.fail("Exception in post methods : " + exc);
                        exc.printStackTrace();
                    }
                    duration = System.currentTimeMillis() - start;
                }
                if (this.currentResults.isEmpty()) {
                    this.reportHelper.pass(duration);
                    this.pass.add(this.current);
                    this.msg("Test " + this.current + " PASSED.").nl();
                } else {
                    this.reportHelper.fail(this.getMessage(this.currentResults), duration);
                    this.fail.add(this.current);
                    this.msg("Test " + this.current + " FAILED.").nl();
                }
                this.reportHelper.done();
                this.display("    Results", this.currentResults);
                continue;
            }
            this.msg("Test " + this.current + " SKIPPED").nl();
            this.skip.add(this.current);
        }
        this.msg("-------------------------------------------------").nl();
        this.msg("Results:").nl();
        this.msg("-------------------------------------------------").nl();
        this.msg("\tFAILED:").nl();
        this.displaySet(this.fail);
        this.msg("\tSKIPPED:").nl();
        this.displaySet(this.skip);
        this.msg("\tPASSED:").nl();
        this.displaySet(this.pass);
        this.nl();
        this.msg(this.pass.size() + " test(s) passed; " + this.fail.size() + " test(s) failed; " + this.skip.size() + " test(s) skipped.").nl();
        this.msg("-------------------------------------------------").nl();
        return this.fail.size();
    }

    private void displaySet(Set<String> set) {
        for (String str : set) {
            this.msg("\t\t").msg(str).nl();
        }
    }

    public void fail(String failMessage) {
        this.check(false, failMessage);
    }

    public void check(boolean result, String failMessage) {
        if (!result) {
            this.currentResults.add(failMessage);
        }
    }

    public void note(String msg) {
        this.msg("\t" + msg).nl();
    }

    @TestCase
    public void testSimple() {
    }

    @TestCase
    public void testGood() {
        this.note("this is a good test");
        this.note("A second note");
    }

    @TestCase(value="Bad")
    public void badTest() {
        this.note("this is a bad test");
        this.fail("this test failed once");
        this.fail("this test failed twice");
    }

    @TestCase
    public void exception() {
        throw new RuntimeException("This test throws an exception");
    }

    @TestCase
    public boolean badReturnType() {
        return true;
    }

    @TestCase
    public void hasParameters(String name) {
    }

    public static void main(String[] args) {
        TestBase base = new TestBase(args);
        base.run();
    }

    private static interface Arguments {
        @DefaultValue(value="false")
        @Help(value="Control debugging mode")
        public boolean debug();

        @DefaultValue(value="false")
        @Help(value="Displays the valid test case identifiers")
        public boolean cases();

        @DefaultValue(value="")
        @Help(value="A list of test cases to include: includes everything if empty")
        @Separator(value=",")
        public List<String> include();

        @DefaultValue(value="")
        @Help(value="A list of test cases to excelude: include everything if empty")
        @Separator(value=",")
        public List<String> exclude();

        @DefaultValue(value="true")
        @Help(value="If true, generate a JUnit report for the tests")
        public boolean generateJunitReport();
    }
}

