/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common.client;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.tx.coord.common.EndpointReferenceBuilder;
import com.sun.xml.ws.tx.coord.common.PendingRequestManager;
import com.sun.xml.ws.tx.coord.common.RegistrationIF;
import com.sun.xml.ws.tx.coord.common.WSCUtil;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterResponseType;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;

public abstract class RegistrationProxyBuilder {
    protected List<WebServiceFeature> features;
    protected EndpointReference to;
    protected String txId;
    protected long timeout;
    protected String callbackAddress;

    public RegistrationProxyBuilder feature(WebServiceFeature feature) {
        if (feature == null) {
            return this;
        }
        if (this.features == null) {
            this.features = new ArrayList<WebServiceFeature>();
        }
        this.features.add(feature);
        return this;
    }

    public RegistrationProxyBuilder txIdForReference(String txId) {
        this.txId = txId;
        return this;
    }

    public RegistrationProxyBuilder to(EndpointReference endpointReference) {
        this.to = endpointReference;
        return this;
    }

    public RegistrationProxyBuilder timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public RegistrationProxyBuilder callback(String callbackAddress) {
        this.callbackAddress = callbackAddress;
        return this;
    }

    protected abstract String getDefaultCallbackAddress();

    protected abstract EndpointReferenceBuilder getEndpointReferenceBuilder();

    protected WebServiceFeature[] getEnabledFeatures() {
        return this.features.toArray(new WebServiceFeature[0]);
    }

    public RegistrationIF build() {
        if (this.callbackAddress == null) {
            this.callbackAddress = this.getDefaultCallbackAddress();
        }
        Object epr = this.getEndpointReferenceBuilder().address(this.callbackAddress).referenceParameter(WSCUtil.referenceElementTxId(this.txId), WSCUtil.referenceElementRoutingInfo()).build();
        WSEndpointReference wsepr = WSEndpointReference.create(epr);
        OneWayFeature oneway = new OneWayFeature(true, wsepr);
        this.feature((WebServiceFeature)oneway);
        return null;
    }

    public abstract class RegistrationProxyF<T extends EndpointReference, K, P, D>
    implements RegistrationIF<T, K, P> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BaseRegisterResponseType<T, P> registerOperation(BaseRegisterType<T, K> parameters) {
            try {
                PendingRequestManager.ResponseBox box = PendingRequestManager.reqisterRequest(RegistrationProxyBuilder.this.txId);
                this.asyncRegister(parameters.getDelegate());
                BaseRegisterResponseType baseRegisterResponseType = box.getResponse(RegistrationProxyBuilder.this.timeout);
                return baseRegisterResponseType;
            }
            finally {
                PendingRequestManager.removeRequest(RegistrationProxyBuilder.this.txId);
            }
        }

        public abstract D getDelegate();

        public abstract void asyncRegister(K var1);

        public abstract AddressingVersion getAddressingVersion();
    }
}

