/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.at.WSATConstants;
import com.sun.xml.ws.tx.at.WSATHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.EndpointReference;

public class WSATXAResource
implements WSATConstants,
XAResource,
Serializable {
    static final long serialVersionUID = -5827137400010343968L;
    private Xid m_xid;
    static final String ACTIVE = "ACTIVE";
    private volatile String m_status = "ACTIVE";
    private Transactional.Version m_version;
    private boolean m_isRemovedFromMap = false;
    private transient EndpointReference m_epr;

    public WSATXAResource(EndpointReference epr, Xid xid) {
        this(Transactional.Version.WSAT10, epr, xid, false);
    }

    public WSATXAResource(Transactional.Version version, EndpointReference epr, Xid xid) {
        this(version, epr, xid, false);
    }

    public WSATXAResource(Transactional.Version version, EndpointReference epr, Xid xid, boolean isRecovery) {
        this.m_version = version;
        if (epr == null) {
            throw new IllegalArgumentException("endpoint reference can't be null");
        }
        this.m_epr = epr;
        this.m_xid = xid;
        if (isRecovery) {
            this.m_status = "Prepared";
        }
    }

    WSATHelper getWSATHelper() {
        return WSATHelper.getInstance(this.m_version);
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        WSATHelper.getInstance().debug("prepare xid:" + xid);
        this.getWSATHelper().prepare(this.m_epr, this.m_xid, this);
        try {
            WSATXAResource wSATXAResource = this;
            synchronized (wSATXAResource) {
                if (this.m_status.equals("ReadOnly")) {
                    return 3;
                }
                if (this.m_status.equals("Prepared")) {
                    return 0;
                }
                if (this.m_status.equals("Aborted")) {
                    throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("prepare", 100);
                }
                this.wait(this.getWaitForReplyTimeout());
            }
            if (this.m_status.equals("ReadOnly")) {
                this.logSuccess("preparereadonly");
                return 3;
            }
            if (this.m_status.equals("Prepared")) {
                this.logSuccess("prepareprepared");
                return 0;
            }
            if (this.m_status.equals("Aborted")) {
                throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("prepare", 100);
            }
            throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("prepare", -7);
        }
        catch (InterruptedException e) {
            XAException xaException = new XAException("InterruptedException during WS-AT XAResource prepare");
            xaException.errorCode = -7;
            xaException.initCause(e);
            throw xaException;
        }
    }

    private XAException newFailedStateXAExceptionForMethodNameAndErrorcode(String method, int errorcode) {
        XAException xaException = new XAException("Failed state during " + method + " of WS-AT XAResource:" + this);
        xaException.errorCode = errorcode;
        return xaException;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.m_isRemovedFromMap) {
            this.getWSATHelper().removeDurableParticipant(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block13: {
            WSATHelper.getInstance().debug("commit xid:" + xid + " onePhase:" + onePhase);
            this.getWSATHelper().commit(this.m_epr, this.m_xid, this);
            try {
                XAException xaException;
                WSATXAResource wSATXAResource = this;
                synchronized (wSATXAResource) {
                    block12: {
                        if (!this.m_status.equals("Committed")) break block12;
                        this.getWSATHelper().removeDurableParticipant(this);
                        this.m_isRemovedFromMap = true;
                        return;
                    }
                    this.wait(this.getWaitForReplyTimeout());
                }
                if (this.m_status.equals("Committed")) {
                    this.logSuccess("preparecommitted");
                    this.getWSATHelper().removeDurableParticipant(this);
                    this.m_isRemovedFromMap = true;
                    break block13;
                }
                if (this.m_status.equals("Prepared")) {
                    xaException = this.newFailedStateXAExceptionForMethodNameAndErrorcode("commit", -7);
                    this.log("Failed state during WS-AT XAResource commit:" + this.m_status);
                    throw xaException;
                }
                xaException = this.newFailedStateXAExceptionForMethodNameAndErrorcode("commit", -6);
                this.log("Failed state during WS-AT XAResource commit:" + this.m_status);
                throw xaException;
            }
            catch (InterruptedException e) {
                XAException xaException = new XAException("InterruptedException during WS-AT XAResource commit:" + e);
                xaException.errorCode = -7;
                xaException.initCause(e);
                throw xaException;
            }
            finally {
                this.getWSATHelper().removeDurableParticipant(this);
            }
        }
    }

    int getWaitForReplyTimeout() {
        return this.getWSATHelper().getWaitForReplyTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        block13: {
            WSATHelper.getInstance().debug("rollback xid:" + xid);
            this.getWSATHelper().rollback(this.m_epr, this.m_xid, this);
            try {
                WSATXAResource wSATXAResource = this;
                synchronized (wSATXAResource) {
                    block12: {
                        if (!this.m_status.equals("Aborted")) break block12;
                        this.getWSATHelper().removeDurableParticipant(this);
                        this.m_isRemovedFromMap = true;
                        return;
                    }
                    this.wait(this.getWaitForReplyTimeout());
                }
                if (this.m_status.equals("Aborted")) {
                    this.logSuccess("rollbackaborted");
                    this.getWSATHelper().removeDurableParticipant(this);
                    this.m_isRemovedFromMap = true;
                    break block13;
                }
                if (this.m_status.equals("Prepared")) {
                    throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("rollback", -7);
                }
                throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("rollback", -7);
            }
            catch (InterruptedException e) {
                XAException xaException = new XAException("InterruptedException during WS-AT XAResource rollback");
                xaException.errorCode = -7;
                xaException.initCause(e);
                throw xaException;
            }
            finally {
                this.getWSATHelper().removeDurableParticipant(this);
            }
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        return true;
    }

    public void start(Xid xid, int i) throws XAException {
    }

    public void end(Xid xid, int i) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return Integer.MAX_VALUE;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return false;
    }

    public Xid[] recover(int i) throws XAException {
        return new Xid[0];
    }

    public Xid getXid() {
        return this.m_xid;
    }

    public void setBranchQualifier(byte[] bqual) {
    }

    public void setXid(Xid xid) {
        this.m_xid = xid;
    }

    public boolean equals(Object obj) {
        return obj instanceof WSATXAResource && ((WSATXAResource)obj).getXid().equals(this.m_xid) && ((WSATXAResource)obj).m_epr.toString().equals(this.m_epr.toString());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.m_epr.writeTo((Result)new StreamResult(bos));
        byte[] eprBytes = bos.toByteArray();
        oos.writeInt(eprBytes.length);
        oos.write(eprBytes);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        int len = ois.readInt();
        byte[] eprBytes = new byte[len];
        ois.readFully(eprBytes);
        this.m_epr = EndpointReference.readFrom((Source)new StreamSource(new ByteArrayInputStream(eprBytes)));
    }

    private void log(String message) {
        WSATHelper.getInstance().debug("WSATXAResource:" + message);
    }

    private void logSuccess(String method) {
        WSATHelper.getInstance().debug("success state during " + method + " of WS-AT XAResource:" + this);
    }

    public String toString() {
        return "WSATXAResource: xid" + this.m_xid + " status:" + this.m_status + " epr:" + this.m_epr + " isRemovedFromMap:" + this.m_isRemovedFromMap;
    }
}

