/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.dsig;

import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.crypto.dsig.Signature;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBSignContext;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.dsig.DSigResolver;
import com.sun.xml.ws.security.opt.impl.dsig.JAXBSignatureHeaderElement;
import com.sun.xml.ws.security.opt.impl.dsig.SignatureElementFactory;
import com.sun.xml.ws.security.opt.impl.dsig.TokenProcessor;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.util.NamespaceAndPrefixMapper;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.security.Key;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;

public class SignatureProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");

    public static int sign(JAXBFilterProcessingContext context) throws XWSSecurityException {
        try {
            SignaturePolicy signaturePolicy = (SignaturePolicy)context.getSecurityPolicy();
            ((NamespaceContextEx)context.getNamespaceContext()).addSignatureNS();
            WSSPolicy keyBinding = (WSSPolicy)signaturePolicy.getKeyBinding();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "KeyBinding is " + String.valueOf(keyBinding));
            }
            Key signingKey = null;
            SignatureElementFactory signFactory = new SignatureElementFactory();
            KeyInfo keyInfo = null;
            SecurityHeader securityHeader = context.getSecurityHeader();
            TokenProcessor tokenProcessor = new TokenProcessor(signaturePolicy, context);
            BuilderResult builderResult = tokenProcessor.process();
            signingKey = builderResult.getDataProtectionKey();
            keyInfo = builderResult.getKeyInfo();
            if (keyInfo != null || !keyBinding.isOptional()) {
                SignedInfo signedInfo = signFactory.constructSignedInfo(context);
                JAXBSignContext signContext = new JAXBSignContext(signingKey);
                signContext.setURIDereferencer(DSigResolver.getInstance());
                XMLSignature signature = signFactory.constructSignature(signedInfo, keyInfo, signaturePolicy.getUUID());
                signContext.put("http://wss.sun.com#processingContext", context);
                NamespaceAndPrefixMapper npMapper = new NamespaceAndPrefixMapper(context.getNamespaceContext(), context.getDisableIncPrefix());
                signContext.put("NS_And_Prefix_Mapper", npMapper);
                signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
                signature.sign(signContext);
                JAXBSignatureHeaderElement jaxBSign = new JAXBSignatureHeaderElement((Signature)signature, context.getSOAPVersion());
                securityHeader.add(jaxBSign);
                ArrayList scList = (ArrayList)context.getExtraneousProperty("SignatureConfirmation");
                if (scList != null) {
                    scList.add(Base64.encode(signature.getSignatureValue().getValue()));
                }
            }
        }
        catch (XWSSecurityException xe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1701_SIGN_FAILED(), xe);
            throw xe;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1701_SIGN_FAILED(), ex);
            throw new XWSSecurityException((Throwable)ex);
        }
        return 0;
    }
}

