/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.EncryptedTypeHeaderBlock;
import com.sun.xml.wss.core.ReferenceListHeaderBlock;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Document;

public class EncryptedKeyHeaderBlock
extends EncryptedTypeHeaderBlock {
    ReferenceListHeaderBlock referenceList;
    SOAPElement carriedKeyName;

    public EncryptedKeyHeaderBlock() throws XWSSecurityException {
        try {
            this.setSOAPElement(EncryptedKeyHeaderBlock.getSoapFactory().createElement("EncryptedKey", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
            this.addNamespaceDeclaration("xenc", "http://www.w3.org/2001/04/xmlenc#");
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0348.error.creating.ekhb", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public EncryptedKeyHeaderBlock(Document doc) throws XWSSecurityException {
        try {
            this.setSOAPElement((SOAPElement)doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedKey"));
            this.addNamespaceDeclaration("xenc", "http://www.w3.org/2001/04/xmlenc#");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0348.error.creating.ekhb", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public EncryptedKeyHeaderBlock(SOAPElement element) throws XWSSecurityException {
        try {
            Iterator<Node> carriedKeyNames;
            this.setSOAPElement(element);
            if (!element.getLocalName().equals("EncryptedKey") || !XMLUtil.inEncryptionNS(element)) {
                log.log(Level.SEVERE, "WSS0349.error.creating.ekhb", element.getTagName());
                throw new XWSSecurityException("Invalid EncryptedKey passed");
            }
            this.initializeEncryptedType(element);
            Iterator<Node> referenceLists = this.getChildElements(EncryptedKeyHeaderBlock.getSoapFactory().createName("ReferenceList", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
            if (referenceLists.hasNext()) {
                this.referenceList = new ReferenceListHeaderBlock((SOAPElement)referenceLists.next());
            }
            if ((carriedKeyNames = this.getChildElements(EncryptedKeyHeaderBlock.getSoapFactory().createName("CarriedKeyName", "xenc", "http://www.w3.org/2001/04/xmlenc#"))).hasNext()) {
                this.carriedKeyName = (SOAPElement)carriedKeyNames.next();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0348.error.creating.ekhb", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public void setCipherData(SOAPElement cipherData) {
        this.cipherData = cipherData;
        this.updateRequired = true;
    }

    public void setCipherValue(String cipherValue) throws XWSSecurityException {
        try {
            this.cipherData = EncryptedKeyHeaderBlock.getSoapFactory().createElement("CipherData", "xenc", "http://www.w3.org/2001/04/xmlenc#");
            this.cipherData.addNamespaceDeclaration("xenc", "http://www.w3.org/2001/04/xmlenc#");
            this.cipherData.addTextNode("\n    ");
            SOAPElement cipherValueElement = this.cipherData.addChildElement("CipherValue", "xenc");
            this.cipherData.addTextNode("\n    ");
            cipherValueElement.addTextNode(cipherValue);
            this.cipherData.removeNamespaceDeclaration("xenc");
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0350.error.setting.ciphervalue", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
        this.updateRequired = true;
    }

    public ReferenceListHeaderBlock getReferenceList() {
        return this.referenceList;
    }

    public void setReferenceList(ReferenceListHeaderBlock referenceList) {
        this.referenceList = referenceList;
        this.updateRequired = true;
    }

    public String getRecipient() {
        String recipient = this.getAttribute("Recipient");
        if (recipient.equals("")) {
            return null;
        }
        return recipient;
    }

    public void setRecipient(String recipient) {
        this.setAttribute("Recipient", recipient);
    }

    public SOAPElement getCarriedKeyName() {
        return this.carriedKeyName;
    }

    public void setCarriedKeyName(SOAPElement carriedKeyName) {
        this.carriedKeyName = carriedKeyName;
        this.updateRequired = true;
    }

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, EncryptedKeyHeaderBlock.class);
    }

    @Override
    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        if (this.updateRequired) {
            this.removeContents();
            try {
                this.addTextNode("\n    ");
                if (this.encryptionMethod != null) {
                    this.addChildElement(this.encryptionMethod);
                    this.addTextNode("\n    ");
                }
                if (this.keyInfo != null) {
                    this.addChildElement(this.keyInfo.getAsSoapElement());
                    this.addTextNode("\n    ");
                }
                if (this.cipherData == null) {
                    log.log(Level.SEVERE, "WSS0347.missing.cipher.data");
                    throw new XWSSecurityException("CipherData is not present inside EncryptedType");
                }
                this.addChildElement(this.cipherData);
                this.addTextNode("\n    ");
                if (this.encryptionProperties != null) {
                    this.addChildElement(this.encryptionProperties);
                    this.addTextNode("\n    ");
                }
                if (this.referenceList != null) {
                    this.addChildElement(this.referenceList.getAsSoapElement());
                    this.addTextNode("\n    ");
                }
                if (this.carriedKeyName != null) {
                    this.addChildElement(this.carriedKeyName);
                    this.addTextNode("\n    ");
                }
            }
            catch (SOAPException e) {
                log.log(Level.SEVERE, "WSS0348.error.creating.ekhb", e.getMessage());
                throw new XWSSecurityException((Throwable)e);
            }
        }
        return super.getAsSoapElement();
    }
}

