/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.runtime.dev.Session;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Trust10;
import com.sun.xml.ws.security.impl.policy.Trust13;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.secconv.WSSCElementFactory13;
import com.sun.xml.ws.security.secconv.WSSCVersion;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secconv.impl.SecurityContextTokenInfoImpl;
import com.sun.xml.ws.security.secconv.impl.wssx.WSSCVersion13;
import com.sun.xml.ws.security.secconv.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.RenewTarget;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.Reference;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.saml.util.SAMLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;

public class WSSCContract {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.secconv", "com.sun.xml.ws.security.secconv.logging.LogStrings");
    private long currentTime;
    private SymmetricBinding symBinding = null;
    private boolean reqServerEntr = true;
    private boolean reqClientEntr = false;
    private WSSCVersion wsscVer = WSSCVersion.WSSC_10;
    private WSTrustVersion wsTrustVer = WSTrustVersion.WS_TRUST_10;
    private WSTrustElementFactory wsscEleFac = WSTrustElementFactory.newInstance((WSSCVersion)WSSCVersion.WSSC_10);
    private static final int DEFAULT_KEY_SIZE = 128;
    public static final String LIFETIME = "LifeTime";
    public static final String SC_CONFIGURATION = "SCConfiguration";
    private long TIMEOUT = 36000000L;
    private static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.getDefault());

    public WSSCContract() {
    }

    public WSSCContract(WSSCVersion wsscVer) {
        this.init(wsscVer);
    }

    public final void init(WSSCVersion wsscVer) {
        if (wsscVer instanceof WSSCVersion13) {
            this.wsscVer = wsscVer;
            this.wsTrustVer = WSTrustVersion.WS_TRUST_13;
            this.wsscEleFac = WSTrustElementFactory.newInstance((WSSCVersion)WSSCVersion.WSSC_13);
        }
    }

    public BaseSTSResponse issue(BaseSTSRequest request, IssuedTokenContext context, SecureConversationToken scToken) throws WSSecureConversationException {
        URI tokenType = URI.create(this.wsscVer.getSCTTokenTypeURI());
        URI con = null;
        URI computeKeyAlgo = URI.create(this.wsTrustVer.getCKPSHA1algorithmURI());
        String conStr = ((RequestSecurityToken)request).getContext();
        if (conStr != null) {
            try {
                con = new URI(conStr);
            }
            catch (URISyntaxException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0008_URISYNTAX_EXCEPTION(((RequestSecurityToken)request).getContext()), ex);
                throw new WSSecureConversationException(LogStringsMessages.WSSC_0008_URISYNTAX_EXCEPTION(((RequestSecurityToken)request).getContext()), (Throwable)ex);
            }
        }
        AppliesTo scopes = ((RequestSecurityToken)request).getAppliesTo();
        RequestedProofToken proofToken = this.wsscEleFac.createRequestedProofToken();
        byte[] clientEntr = null;
        Entropy clientEntropy = ((RequestSecurityToken)request).getEntropy();
        if (clientEntropy != null) {
            BinarySecret clientBS = clientEntropy.getBinarySecret();
            if (clientBS == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, LogStringsMessages.WSSC_0009_CLIENT_ENTROPY_VALUE("null"));
                }
            } else {
                clientEntr = clientBS.getRawValue();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, LogStringsMessages.WSSC_0009_CLIENT_ENTROPY_VALUE(clientEntropy.toString()));
                }
            }
        }
        BaseSTSResponse response = this.createRSTR(computeKeyAlgo, scToken, request, scopes, clientEntr, proofToken, tokenType, clientEntropy, context, con);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0014_RSTR_RESPONSE(WSTrustUtil.elemToString(response, this.wsTrustVer)));
        }
        this.updateSubject(context);
        return response;
    }

    private void parseAssertion(SecureConversationToken scToken, Entropy clientEntropy) throws WSSecureConversationException {
        Set trustReqdProps;
        Trust10 trust10 = null;
        Trust13 trust13 = null;
        NestedPolicy wsPolicy = scToken.getBootstrapPolicy();
        AssertionSet assertionSet = wsPolicy.getAssertionSet();
        for (PolicyAssertion policyAssertion : assertionSet) {
            SecurityPolicyVersion spVersion;
            if (PolicyUtil.isTrust13(policyAssertion, spVersion = this.getSPVersion(policyAssertion))) {
                trust13 = (Trust13)policyAssertion;
                continue;
            }
            if (PolicyUtil.isTrust10(policyAssertion, spVersion)) {
                trust10 = (Trust10)policyAssertion;
                continue;
            }
            if (!PolicyUtil.isSymmetricBinding(policyAssertion, spVersion)) continue;
            this.symBinding = (SymmetricBinding)policyAssertion;
        }
        if (trust10 != null) {
            trustReqdProps = trust10.getRequiredProperties();
            this.reqServerEntr = trustReqdProps.contains("RequireServerEntropy");
            this.reqClientEntr = trustReqdProps.contains("RequireClientEntropy");
        }
        if (trust13 != null) {
            trustReqdProps = trust13.getRequiredProperties();
            this.reqServerEntr = trustReqdProps.contains("RequireServerEntropy");
            this.reqClientEntr = trustReqdProps.contains("RequireClientEntropy");
        }
        if (clientEntropy == null) {
            if (this.reqClientEntr) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0010_CLIENT_ENTROPY_CANNOT_NULL());
                throw new WSSecureConversationException(LogStringsMessages.WSSC_0010_CLIENT_ENTROPY_CANNOT_NULL());
            }
            this.reqServerEntr = true;
        }
    }

    private BaseSTSResponse createRSTR(URI computeKeyAlgo, SecureConversationToken scToken, BaseSTSRequest request, AppliesTo scopes, byte[] clientEntr, RequestedProofToken proofToken, URI tokenType, Entropy clientEntropy, IssuedTokenContext context, URI con) throws WSSecureConversationException {
        long timeout;
        this.parseAssertion(scToken, clientEntropy);
        int keySize = (int)((RequestSecurityToken)request).getKeySize();
        if (keySize < 1 && this.symBinding != null) {
            AlgorithmSuite algoSuite = this.symBinding.getAlgorithmSuite();
            keySize = algoSuite.getMinSKLAlgorithm();
        }
        if (keySize < 1) {
            keySize = 128;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0011_KEY_SIZE_VALUE(keySize, 128));
        }
        byte[] secret = WSTrustUtil.generateRandomSecret(keySize / 8);
        String proofTokenType = clientEntr == null || clientEntr.length == 0 ? this.wsTrustVer.getSymmetricKeyTypeURI() : this.wsTrustVer.getNonceBinarySecretTypeURI();
        Entropy serverEntropy = null;
        if (this.reqServerEntr) {
            BinarySecret serverBS = this.wsscEleFac.createBinarySecret(secret, proofTokenType);
            if (proofTokenType.equals(this.wsTrustVer.getNonceBinarySecretTypeURI())) {
                serverEntropy = this.wsscEleFac.createEntropy(serverBS);
                proofToken.setProofTokenType("ComputedKey");
                proofToken.setComputedKey(computeKeyAlgo);
                try {
                    secret = SecurityUtil.P_SHA1(clientEntr, secret, keySize / 8);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WSSC_0012_COMPUTE_SECKEY(), ex);
                    throw new WSSecureConversationException(LogStringsMessages.WSSC_0012_COMPUTE_SECKEY(), (Throwable)ex);
                }
            } else {
                proofToken.setProofTokenType("BinarySecret");
                proofToken.setBinarySecret(serverBS);
            }
        } else if (clientEntropy != null) {
            secret = clientEntr;
            proofToken.setProofTokenType("BinarySecret");
            proofToken.setBinarySecret(clientEntropy.getBinarySecret());
        }
        Lifetime lifetime = ((RequestSecurityToken)request).getLifetime();
        if (lifetime != null && (timeout = WSTrustUtil.getLifeSpan(lifetime)) > 0L) {
            this.setSCTokenTimeout(timeout);
        }
        return this.createResponse(serverEntropy, con, scopes, secret, proofToken, context, tokenType);
    }

    private BaseSTSResponse createResponse(Entropy serverEntropy, URI con, AppliesTo scopes, byte[] secret, RequestedProofToken proofToken, IssuedTokenContext context, URI tokenType) throws WSSecureConversationException {
        SecurityContextToken token = WSTrustUtil.createSecurityContextToken(this.wsscEleFac);
        RequestedSecurityToken rst = this.wsscEleFac.createRequestedSecurityToken((Token)token);
        SecurityTokenReference attachedReference = this.createSecurityTokenReference(token.getWsuId(), false);
        RequestedAttachedReference rar = this.wsscEleFac.createRequestedAttachedReference(attachedReference);
        SecurityTokenReference unattachedRef = this.createSecurityTokenReference(token.getIdentifier().toString(), true);
        RequestedUnattachedReference rur = this.wsscEleFac.createRequestedUnattachedReference(unattachedRef);
        long now = WSTrustUtil.getCurrentTimeWithOffset();
        Lifetime lifetime = WSTrustUtil.createLifetime(now, this.getSCTokenTimeout(), this.wsTrustVer);
        Object response = null;
        response = this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI()) ? this.wsscEleFac.createRSTRCollectionForIssue(tokenType, con, rst, scopes, rar, rur, proofToken, serverEntropy, lifetime) : this.wsscEleFac.createRSTRForIssue(tokenType, con, rst, scopes, rar, rur, proofToken, serverEntropy, lifetime);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1010_CREATING_SESSION(token.getIdentifier()));
        }
        this.populateITC(now, secret, token, attachedReference, context, unattachedRef);
        return response;
    }

    private void populateITC(long currentTime, byte[] secret, SecurityContextToken token, SecurityTokenReference attachedReference, IssuedTokenContext context, SecurityTokenReference unattachedRef) {
        context.setSecurityToken((Token)token);
        context.setAttachedSecurityTokenReference((Token)attachedReference);
        context.setUnAttachedSecurityTokenReference((Token)unattachedRef);
        context.setProofKey(secret);
        context.setCreationTime(new Date(currentTime));
        context.setExpirationTime(new Date(currentTime + this.getSCTokenTimeout()));
        SecurityContextTokenInfoImpl sctinfo = new SecurityContextTokenInfoImpl();
        sctinfo.setIdentifier(token.getIdentifier().toString());
        sctinfo.setExternalId(token.getWsuId());
        sctinfo.addInstance(null, secret);
        sctinfo.setCreationTime(new Date(currentTime));
        sctinfo.setExpirationTime(new Date(currentTime + this.getSCTokenTimeout()));
        SessionManager sm = (SessionManager)context.getOtherProperties().get("SessionManager");
        sm.createSession(token.getIdentifier().toString(), (SecurityContextTokenInfo)sctinfo);
        context.setSecurityContextTokenInfo((SecurityContextTokenInfo)sctinfo);
        sm.addSecurityContext(token.getIdentifier().toString(), context);
    }

    private void populateRenewedITC(Session session, byte[] secret, SecurityContextToken token, IssuedTokenContext context, SecurityTokenReference attachedReference) {
        context.setSecurityToken((Token)token);
        context.setAttachedSecurityTokenReference((Token)attachedReference);
        context.setCreationTime(new Date(this.currentTime));
        context.setExpirationTime(new Date(this.currentTime + this.getSCTokenTimeout()));
        SecurityContextTokenInfo sctInfoForSession = session.getSecurityInfo();
        sctInfoForSession.setExternalId(token.getWsuId());
        sctInfoForSession.setExternalId(token.getInstance());
        sctInfoForSession.setCreationTime(new Date(this.currentTime));
        sctInfoForSession.setExpirationTime(new Date(this.currentTime + this.getSCTokenTimeout()));
        session.setSecurityInfo(sctInfoForSession);
        SecurityContextTokenInfoImpl sctInfoForItc = new SecurityContextTokenInfoImpl();
        sctInfoForItc.setIdentifier(token.getIdentifier().toString());
        sctInfoForItc.setInstance(token.getInstance());
        sctInfoForItc.setExternalId(token.getWsuId());
        sctInfoForItc.addInstance(token.getInstance(), secret);
        context.setSecurityContextTokenInfo((SecurityContextTokenInfo)sctInfoForItc);
    }

    public RequestSecurityTokenResponseCollection issueMultiple(RequestSecurityToken request, IssuedTokenContext context) {
        return null;
    }

    public BaseSTSResponse renew(BaseSTSRequest request, IssuedTokenContext context, SecureConversationToken scToken) throws WSSecureConversationException {
        long timeout;
        if (scToken.isMustNotSendRenew()) {
            throw new WSSecureConversationException("Service doesn't support Token Renewal, as MustNotSendRenew is enabled in the service policy");
        }
        URI tokenType = URI.create(this.wsscVer.getSCTTokenTypeURI());
        URI con = null;
        URI computeKeyAlgo = URI.create(this.wsTrustVer.getCKPSHA1algorithmURI());
        RenewTarget renewTgt = ((RequestSecurityToken)request).getRenewTarget();
        String conStr = ((RequestSecurityToken)request).getContext();
        if (conStr != null) {
            try {
                con = new URI(conStr);
            }
            catch (URISyntaxException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0008_URISYNTAX_EXCEPTION(((RequestSecurityToken)request).getContext()), ex);
                throw new WSSecureConversationException(LogStringsMessages.WSSC_0008_URISYNTAX_EXCEPTION(((RequestSecurityToken)request).getContext()), (Throwable)ex);
            }
        }
        RequestedProofToken proofToken = this.wsscEleFac.createRequestedProofToken();
        byte[] clientEntr = null;
        Entropy clientEntropy = ((RequestSecurityToken)request).getEntropy();
        if (clientEntropy != null) {
            BinarySecret clientBS = clientEntropy.getBinarySecret();
            if (clientBS == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, LogStringsMessages.WSSC_0009_CLIENT_ENTROPY_VALUE("null"));
                }
            } else {
                clientEntr = clientBS.getRawValue();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, LogStringsMessages.WSSC_0009_CLIENT_ENTROPY_VALUE(clientEntropy.toString()));
                }
            }
        }
        this.parseAssertion(scToken, clientEntropy);
        int keySize = (int)((RequestSecurityToken)request).getKeySize();
        if (keySize < 1 && this.symBinding != null) {
            AlgorithmSuite algoSuite = this.symBinding.getAlgorithmSuite();
            keySize = algoSuite.getMinSKLAlgorithm();
        }
        if (keySize < 1) {
            keySize = 128;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0011_KEY_SIZE_VALUE(keySize, 128));
        }
        byte[] secret = WSTrustUtil.generateRandomSecret(keySize / 8);
        String proofTokenType = clientEntr == null || clientEntr.length == 0 ? this.wsTrustVer.getSymmetricKeyTypeURI() : this.wsTrustVer.getNonceBinarySecretTypeURI();
        Entropy serverEntropy = null;
        if (this.reqServerEntr) {
            BinarySecret serverBS = this.wsscEleFac.createBinarySecret(secret, proofTokenType);
            if (proofTokenType.equals(this.wsTrustVer.getNonceBinarySecretTypeURI())) {
                serverEntropy = this.wsscEleFac.createEntropy(serverBS);
                proofToken.setProofTokenType("ComputedKey");
                proofToken.setComputedKey(computeKeyAlgo);
                try {
                    secret = SecurityUtil.P_SHA1(clientEntr, secret, keySize / 8);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WSSC_0012_COMPUTE_SECKEY(), ex);
                    throw new WSSecureConversationException(LogStringsMessages.WSSC_0012_COMPUTE_SECKEY(), (Throwable)ex);
                }
            } else {
                proofToken.setProofTokenType("BinarySecret");
                proofToken.setBinarySecret(serverBS);
            }
        } else if (clientEntropy != null) {
            secret = clientEntr;
            proofToken.setProofTokenType("BinarySecret");
            proofToken.setBinarySecret(clientEntropy.getBinarySecret());
        }
        Lifetime lifetime = ((RequestSecurityToken)request).getLifetime();
        if (lifetime != null && (timeout = WSTrustUtil.getLifeSpan(lifetime)) > 0L) {
            this.setSCTokenTimeout(timeout);
        }
        BaseSTSResponse rstr = this.createRenewResponse(renewTgt, serverEntropy, con, secret, proofToken, context, tokenType);
        return rstr;
    }

    private BaseSTSResponse createRenewResponse(RenewTarget renewTgt, Entropy serverEntropy, URI con, byte[] secret, RequestedProofToken proofToken, IssuedTokenContext context, URI tokenType) throws WSSecureConversationException {
        RequestSecurityTokenResponse rstr;
        SecurityTokenReference str = renewTgt.getSecurityTokenReference();
        SessionManager sm = (SessionManager)context.getOtherProperties().get("SessionManager");
        String id = null;
        Reference ref = str.getReference();
        if (ref.getType().equals("Reference")) {
            id = ((DirectReference)ref).getURIAttr().toString();
        }
        SecurityContextToken token = WSTrustUtil.createSecurityContextToken(this.wsscEleFac, id);
        RequestedSecurityToken rst = this.wsscEleFac.createRequestedSecurityToken((Token)token);
        SecurityTokenReference attachedReference = this.createSecurityTokenReferenceForRenew(token.getWsuId(), false, token.getInstance());
        RequestedAttachedReference rar = this.wsscEleFac.createRequestedAttachedReference(attachedReference);
        IssuedTokenContext ctx = sm.getSecurityContext(id, false);
        if (ctx == null || ctx.getSecurityToken() == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0015_UNKNOWN_CONTEXT(id));
            throw new WSSecureConversationException(LogStringsMessages.WSSC_0015_UNKNOWN_CONTEXT(id));
        }
        Lifetime lifetime = this.createLifetime();
        if (this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI())) {
            RequestSecurityTokenResponse resp = this.wsscEleFac.createRSTRForRenew(tokenType, con, rst, rar, null, proofToken, serverEntropy, lifetime);
            ArrayList<RequestSecurityTokenResponse> list = new ArrayList<RequestSecurityTokenResponse>();
            list.add(resp);
            rstr = ((WSSCElementFactory13)this.wsscEleFac).createRSTRCollectionForIssue(list);
        } else {
            rstr = this.wsscEleFac.createRSTRForRenew(tokenType, con, rst, rar, null, proofToken, serverEntropy, lifetime);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0014_RSTR_RESPONSE(WSTrustUtil.elemToString((BaseSTSResponse)rstr, this.wsTrustVer)));
        }
        Session session = sm.getSession(token.getIdentifier().toString());
        this.populateRenewedITC(session, secret, token, ctx, attachedReference);
        sm.addSecurityContext(token.getIdentifier().toString(), ctx);
        return rstr;
    }

    public BaseSTSResponse cancel(BaseSTSRequest request, IssuedTokenContext context) throws WSSecureConversationException {
        RequestSecurityTokenResponse rstr;
        IssuedTokenContext cxt;
        CancelTarget cancelTgt = ((RequestSecurityToken)request).getCancelTarget();
        SecurityTokenReference str = cancelTgt.getSecurityTokenReference();
        String id = null;
        Reference ref = str.getReference();
        if (ref.getType().equals("Reference")) {
            id = ((DirectReference)ref).getURIAttr().toString();
        }
        if ((cxt = ((SessionManager)context.getOtherProperties().get("SessionManager")).getSecurityContext(id, true)) == null || cxt.getSecurityContextTokenInfo() == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0015_UNKNOWN_CONTEXT(id));
            throw new WSSecureConversationException(LogStringsMessages.WSSC_0015_UNKNOWN_CONTEXT(id));
        }
        if (this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI())) {
            RequestSecurityTokenResponse resp = this.wsscEleFac.createRSTRForCancel();
            ArrayList<RequestSecurityTokenResponse> list = new ArrayList<RequestSecurityTokenResponse>();
            list.add(resp);
            rstr = ((WSSCElementFactory13)this.wsscEleFac).createRSTRCollectionForIssue(list);
        } else {
            rstr = this.wsscEleFac.createRSTRForCancel();
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0014_RSTR_RESPONSE(WSTrustUtil.elemToString((BaseSTSResponse)rstr, this.wsTrustVer)));
        }
        return rstr;
    }

    public RequestSecurityTokenResponse validate(RequestSecurityToken request, IssuedTokenContext context) {
        return null;
    }

    public void handleUnsolicited(RequestSecurityTokenResponse rstr, IssuedTokenContext context) {
        RequestedSecurityToken rqSecToken = rstr.getRequestedSecurityToken();
        Token token = rqSecToken.getToken();
        RequestedProofToken rqProofToken = rstr.getRequestedProofToken();
        String proofTokenType = rqProofToken.getProofTokenType();
        if (proofTokenType.equals("BinarySecret")) {
            BinarySecret binarySecret = rqProofToken.getBinarySecret();
            if (binarySecret.getType().equals(this.wsTrustVer.getSymmetricKeyTypeURI())) {
                byte[] secret = binarySecret.getRawValue();
                context.setProofKey(secret);
            }
        } else if (proofTokenType.equals("EncryptedKey")) {
            // empty if block
        }
        context.setSecurityToken(token);
        long curTime = System.currentTimeMillis();
        Date creationTime = new Date(curTime);
        Date expirationTime = new Date(curTime + this.getSCTokenTimeout());
        context.setCreationTime(creationTime);
        context.setExpirationTime(expirationTime);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, LogStringsMessages.WSSC_1003_SETTING_TIMES(creationTime.toString(), expirationTime.toString()));
        }
    }

    private SecurityTokenReference createSecurityTokenReference(String id, boolean unattached) {
        Object uri = unattached ? id : "#" + id;
        DirectReference ref = this.wsscEleFac.createDirectReference(this.wsscVer.getSCTTokenTypeURI(), (String)uri);
        return this.wsscEleFac.createSecurityTokenReference((Reference)ref);
    }

    private SecurityTokenReference createSecurityTokenReferenceForRenew(String id, boolean unattached, String instanceId) {
        Object uri = unattached ? id : "#" + id;
        DirectReference ref = this.wsscEleFac.createDirectReference(this.wsscVer.getSCTTokenTypeURI(), (String)uri);
        return this.wsscEleFac.createSecurityTokenReference((Reference)ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lifetime createLifetime() {
        GregorianCalendar cal = new GregorianCalendar();
        int offset = cal.get(15);
        if (((Calendar)cal).getTimeZone().inDaylightTime(cal.getTime())) {
            offset += ((Calendar)cal).getTimeZone().getDSTSavings();
        }
        SimpleDateFormat simpleDateFormat = calendarFormatter;
        synchronized (simpleDateFormat) {
            calendarFormatter.setTimeZone(((Calendar)cal).getTimeZone());
            long beforeTime = cal.getTimeInMillis();
            this.currentTime = beforeTime - (long)offset;
            cal.setTimeInMillis(this.currentTime);
            AttributedDateTime created = new AttributedDateTime();
            created.setValue(calendarFormatter.format(cal.getTime()));
            AttributedDateTime expires = new AttributedDateTime();
            cal.setTimeInMillis(this.currentTime + this.getSCTokenTimeout());
            expires.setValue(calendarFormatter.format(cal.getTime()));
            Lifetime lifetime = this.wsscEleFac.createLifetime(created, expires);
            return lifetime;
        }
    }

    private SecurityPolicyVersion getSPVersion(PolicyAssertion pa) {
        String nsUri = pa.getName().getNamespaceURI();
        SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
        if (SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(nsUri)) {
            spVersion = SecurityPolicyVersion.SECURITYPOLICY12NS;
        }
        return spVersion;
    }

    public void setWSSCServerConfig(Iterator wsscConfigIterator) {
        if (wsscConfigIterator != null) {
            block0: while (wsscConfigIterator.hasNext()) {
                PolicyAssertion assertion = (PolicyAssertion)wsscConfigIterator.next();
                if (!SC_CONFIGURATION.equals(assertion.getName().getLocalPart())) continue;
                Iterator wsscConfig = assertion.getNestedAssertionsIterator();
                while (wsscConfig.hasNext()) {
                    PolicyAssertion serviceSCPolicy = (PolicyAssertion)wsscConfig.next();
                    if (!LIFETIME.equals(serviceSCPolicy.getName().getLocalPart())) continue;
                    this.setSCTokenTimeout(Integer.parseInt(serviceSCPolicy.getValue()));
                    continue block0;
                }
            }
        }
    }

    private void setSCTokenTimeout(long scTokenTimeout) {
        this.TIMEOUT = scTokenTimeout;
    }

    private long getSCTokenTimeout() {
        return this.TIMEOUT;
    }

    private void updateSubject(IssuedTokenContext context) throws WSSecureConversationException {
        Subject subj = context.getRequestorSubject();
        try {
            if (subj != null) {
                Set<Object> set = subj.getPublicCredentials();
                XMLStreamReader samlReader = null;
                Element samlAssertion = null;
                for (Object obj : set) {
                    if (!(obj instanceof XMLStreamReader)) continue;
                    samlReader = (XMLStreamReader)obj;
                    samlAssertion = SAMLUtil.createSAMLAssertion(samlReader);
                }
                if (samlReader != null && samlAssertion != null) {
                    set.remove(samlReader);
                    set.add(samlAssertion);
                }
            }
        }
        catch (XWSSecurityException | XMLStreamException ex) {
            throw new WSSecureConversationException(ex.getMessage(), ex);
        }
    }
}

