/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.ws.security.Token;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.core.Timestamp;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurityTokenException;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class UsernameToken
extends SecurityHeaderBlockImpl
implements SecurityToken,
Token {
    public static final long MAX_NONCE_AGE = 900000L;
    private String username;
    private String password;
    private String passwordType;
    private String passwordDigest;
    private byte[] decodedNonce;
    private String nonce;
    private String nonceEncodingType;
    private String created;
    private boolean bsp;
    private Document soapDoc;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, UsernameToken.class);
    }

    public UsernameToken(Document document, String username) throws SecurityTokenException {
        this.password = null;
        this.passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
        this.passwordDigest = null;
        this.decodedNonce = null;
        this.nonce = null;
        this.nonceEncodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
        this.created = null;
        this.bsp = false;
        this.soapDoc = document;
        this.username = username;
        this.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
    }

    public UsernameToken(Document document, String username, String password, boolean digestPassword) throws SecurityTokenException {
        this(document, username);
        this.password = password;
        if (digestPassword) {
            this.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
        }
    }

    public UsernameToken(Document document, String username, String password) throws SecurityTokenException {
        this(document, username, password, false);
    }

    public UsernameToken(Document document, String username, String password, boolean setNonce, boolean digestPassword) throws SecurityTokenException {
        this(document, username, password, digestPassword);
        if (setNonce) {
            this.createNonce();
        }
    }

    public UsernameToken(Document document, String username, String password, boolean setNonce, boolean setCreatedTimestamp, boolean digestPassword) throws SecurityTokenException {
        this(document, username, password, setNonce, digestPassword);
        if (setCreatedTimestamp) {
            try {
                this.created = this.getCreatedFromTimestamp();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0280.failed.create.UsernameToken", e);
                throw new SecurityTokenException(e);
            }
        }
    }

    public UsernameToken(SOAPElement usernameTokenSoapElement, boolean bspFlag) throws XWSSecurityException {
        this(usernameTokenSoapElement);
        this.isBSP(bspFlag);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UsernameToken(SOAPElement usernameTokenSoapElement) throws XWSSecurityException {
        SOAPElement element;
        Node object;
        Iterator children;
        boolean invalidToken;
        block17: {
            this.password = null;
            this.passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
            this.passwordDigest = null;
            this.decodedNonce = null;
            this.nonce = null;
            this.nonceEncodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
            this.created = null;
            this.bsp = false;
            this.setSOAPElement(usernameTokenSoapElement);
            this.soapDoc = this.getOwnerDocument();
            if (!"UsernameToken".equals(this.getLocalName()) || !XMLUtil.inWsseNS(this)) {
                log.log(Level.SEVERE, "WSS0329.usernametoken.expected", new Object[]{this.getLocalName()});
                throw new SecurityTokenException("Expected UsernameToken Element, but Found " + this.getLocalName());
            }
            invalidToken = false;
            children = this.getChildElements();
            object = null;
            while (children.hasNext() && !(object instanceof SOAPElement)) {
                object = (Node)children.next();
            }
            if (object != null && object.getNodeType() == 1) {
                element = (SOAPElement)object;
                if ("Username".equals(element.getLocalName()) && XMLUtil.inWsseNS(element)) {
                    this.username = element.getValue();
                    break block17;
                } else {
                    log.log(Level.SEVERE, "WSS0330.usernametoken.firstchild.mustbe.username");
                    throw new SecurityTokenException("The first child of a UsernameToken Element, should be a Username ");
                }
            }
            invalidToken = true;
        }
        while (children.hasNext()) {
            object = (Node)children.next();
            if (object.getNodeType() != 1) continue;
            element = (SOAPElement)object;
            if ("Password".equals(element.getLocalName()) && XMLUtil.inWsseNS(element)) {
                String passwordType = element.getAttribute("Type");
                if (this.isBSP() && passwordType.length() < 1) {
                    log.log(Level.SEVERE, "BSP4201.PasswordType.Username");
                    throw new XWSSecurityException(" A wsse:UsernameToken/wsse:Password element in a SECURITY_HEADER MUST specify a Type attribute.");
                }
                if (!"".equals(passwordType)) {
                    this.setPasswordType(passwordType);
                }
                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" == this.passwordType) {
                    this.password = element.getValue();
                    continue;
                }
                this.passwordDigest = element.getValue();
                continue;
            }
            if ("Nonce".equals(element.getLocalName()) && XMLUtil.inWsseNS(element)) {
                this.nonce = element.getValue();
                String encodingType = element.getAttribute("EncodingType");
                if (!"".equals(encodingType)) {
                    this.setNonceEncodingType(encodingType);
                }
                try {
                    this.decodedNonce = Base64.decode(this.nonce);
                    continue;
                }
                catch (Base64DecodingException bde) {
                    log.log(Level.SEVERE, "WSS0309.couldnot.decode.base64.nonce", bde);
                    throw new XWSSecurityException((Throwable)bde);
                }
            }
            if ("Created".equals(element.getLocalName()) && XMLUtil.inWsuNS(element)) {
                this.created = element.getValue();
                continue;
            }
            invalidToken = true;
        }
        if (invalidToken) {
            log.log(Level.SEVERE, "WSS0331.invalid.usernametoken");
            throw new SecurityTokenException("Element passed was not a SOAPElement or is not a proper UsernameToken");
        }
        if (null == this.username) {
            log.log(Level.SEVERE, "WSS0332.usernametoken.null.username");
            throw new SecurityTokenException("Username token does not contain the username");
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    private void setPasswordType(String passwordType) throws SecurityTokenException {
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(passwordType)) {
            this.passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
        } else if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(passwordType)) {
            this.passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
        } else {
            log.log(Level.SEVERE, "WSS0306.invalid.passwd.type", new Object[]{"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest"});
            throw new SecurityTokenException("Invalid password type. Must be one of   http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText or http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
        }
    }

    public String getNonceEncodingType() {
        return this.nonceEncodingType;
    }

    private void setNonceEncodingType(String nonceEncodingType) {
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(nonceEncodingType)) {
            log.log(Level.SEVERE, "WSS0307.nonce.enctype.invalid");
            throw new RuntimeException("Nonce encoding type invalid");
        }
        this.nonceEncodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getCreated() {
        return this.created;
    }

    public String getPasswordDigest() {
        return this.passwordDigest;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public void setNonce(String nonceValue) {
        if (nonceValue == null || "".equals(nonceValue)) {
            this.createNonce();
        } else {
            this.nonce = nonceValue;
        }
    }

    public void setCreationTime(String time) throws XWSSecurityException {
        this.created = time == null || "".equals(time) ? this.getCreatedFromTimestamp() : time;
    }

    public void setDigestOn() throws SecurityTokenException {
        this.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
    }

    @Override
    public SOAPElement getAsSoapElement() throws SecurityTokenException {
        if (null != this.delegateElement) {
            return this.delegateElement;
        }
        try {
            this.setSOAPElement((SOAPElement)this.soapDoc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:UsernameToken"));
            this.addNamespaceDeclaration("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            if (null == this.username || MessageConstants._EMPTY.equals(this.username)) {
                log.log(Level.SEVERE, "WSS0387.error.creating.usernametoken");
                throw new SecurityTokenException("username was not set");
            }
            this.addChildElement("Username", "wsse").addTextNode(this.username);
            if (this.password != null && !MessageConstants._EMPTY.equals(this.password)) {
                SOAPElement wssePassword = this.addChildElement("Password", "wsse");
                if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest" == this.passwordType) {
                    this.createDigest();
                    wssePassword.addTextNode(this.passwordDigest);
                } else {
                    wssePassword.addTextNode(this.password);
                }
                wssePassword.setAttribute("Type", this.passwordType);
            }
            if (this.nonce != null) {
                SOAPElement wsseNonce = this.addChildElement("Nonce", "wsse");
                wsseNonce.addTextNode(this.nonce);
                if (this.nonceEncodingType != null) {
                    wsseNonce.setAttribute("EncodingType", this.nonceEncodingType);
                }
            }
            if (this.created != null) {
                SOAPElement wsuCreated = this.addChildElement("Created", "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                wsuCreated.addTextNode(this.created);
            }
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, "WSS0388.error.creating.usernametoken", se.getMessage());
            throw new SecurityTokenException("There was an error creating Username Token " + se.getMessage());
        }
        return this.delegateElement;
    }

    private void createNonce() {
        this.decodedNonce = new byte[18];
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(this.decodedNonce);
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.SEVERE, "WSS0310.no.such.algorithm", new Object[]{e.getMessage()});
            throw new RuntimeException("No such algorithm found" + e.getMessage());
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary" != this.nonceEncodingType) {
            log.log(Level.SEVERE, "WSS0389.unrecognized.nonce.encoding", this.nonceEncodingType);
            throw new RuntimeException("Unrecognized encoding: " + this.nonceEncodingType);
        }
        this.nonce = Base64.encode(this.decodedNonce);
    }

    private void createDigest() throws SecurityTokenException {
        byte[] hash;
        byte[] bytesToHash;
        Object utf8String = "";
        if (this.created != null) {
            utf8String = (String)utf8String + this.created;
        }
        if (this.password != null) {
            utf8String = (String)utf8String + this.password;
        }
        byte[] utf8Bytes = ((String)utf8String).getBytes(StandardCharsets.UTF_8);
        if (this.decodedNonce != null) {
            int i;
            bytesToHash = new byte[utf8Bytes.length + 18];
            for (i = 0; i < 18; ++i) {
                bytesToHash[i] = this.decodedNonce[i];
            }
            for (i = 18; i < utf8Bytes.length + 18; ++i) {
                bytesToHash[i] = utf8Bytes[i - 18];
            }
        } else {
            bytesToHash = utf8Bytes;
        }
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            hash = sha.digest(bytesToHash);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0311.passwd.digest.couldnot.be.created", new Object[]{e.getMessage()});
            throw new SecurityTokenException("Password Digest could not be created. " + e.getMessage());
        }
        this.passwordDigest = Base64.encode(hash);
    }

    private String getCreatedFromTimestamp() throws XWSSecurityException {
        Timestamp ts = new Timestamp();
        ts.createDateTime();
        return ts.getCreated();
    }

    @Override
    public void isBSP(boolean flag) {
        this.bsp = flag;
    }

    @Override
    public boolean isBSP() {
        return this.bsp;
    }

    public String getType() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0";
    }

    public Object getTokenValue() {
        log.log(Level.SEVERE, "WSS0281.unsupported.operation");
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

