/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.elements;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.EncryptedKey;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.impl.bindings.BinarySecretType;
import com.sun.xml.ws.security.trust.impl.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.elements.BinarySecretImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntropyImpl
extends EntropyType
implements Entropy {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private String entropyType;
    private static final QName _EntropyType_QNAME = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Type");
    private BinarySecret binarySecret = null;
    private EncryptedKey encryptedKey = null;

    public EntropyImpl() {
    }

    public EntropyImpl(BinarySecret binarySecret) {
        this.setEntropyType("BinarySecret");
        this.setBinarySecret(binarySecret);
    }

    public EntropyImpl(EncryptedKey encryptedKey) {
        this.setEntropyType("EncryptedKey");
        this.setEncryptedKey(encryptedKey);
    }

    public EntropyImpl(@NotNull EntropyType etype) {
        this.entropyType = etype.getOtherAttributes().get(_EntropyType_QNAME);
        List<Object> list = etype.getAny();
        for (int i = 0; i < list.size(); ++i) {
            JAXBElement obj = (JAXBElement)list.get(i);
            String local = obj.getName().getLocalPart();
            if (!local.equalsIgnoreCase("BinarySecret")) continue;
            BinarySecretType bst = (BinarySecretType)obj.getValue();
            this.setBinarySecret(new BinarySecretImpl(bst));
        }
    }

    public static EntropyType fromElement(Element element) throws WSTrustException {
        try {
            Unmarshaller unmarshaller = WSTrustElementFactory.getContext().createUnmarshaller();
            return (EntropyType)unmarshaller.unmarshal((Node)element);
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0021_ERROR_UNMARSHAL_DOM_ELEMENT(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0021_ERROR_UNMARSHAL_DOM_ELEMENT(), (Throwable)ex);
        }
    }

    public String getEntropyType() {
        return this.entropyType;
    }

    public final void setEntropyType(@NotNull String type) {
        if (!type.equalsIgnoreCase("BinarySecret")) {
            if (!type.equalsIgnoreCase("Custom")) {
                if (!type.equalsIgnoreCase("EncryptedKey")) {
                    log.log(Level.SEVERE, LogStringsMessages.WST_0022_INVALID_ENTROPY(type));
                    throw new RuntimeException(LogStringsMessages.WST_0022_INVALID_ENTROPY(type));
                }
            }
        }
        this.entropyType = type;
        this.getOtherAttributes().put(_EntropyType_QNAME, type);
    }

    public BinarySecret getBinarySecret() {
        return this.binarySecret;
    }

    public final void setBinarySecret(BinarySecret binarySecret) {
        if (binarySecret != null) {
            this.binarySecret = binarySecret;
            JAXBElement<BinarySecretType> bsElement = new ObjectFactory().createBinarySecret((BinarySecretType)binarySecret);
            this.getAny().add(bsElement);
        }
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    public final void setEncryptedKey(EncryptedKey encryptedKey) {
        if (encryptedKey != null) {
            this.encryptedKey = encryptedKey;
            this.getAny().add(encryptedKey);
        }
    }
}

