/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.message;

import com.sun.istack.NotNull;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.AddressingUtils;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.impl.message.HeaderWrapper;
import com.sun.xml.ws.security.opt.impl.message.SecuredMessage;
import com.sun.xml.ws.spi.db.XMLBridge;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.glassfish.jaxb.runtime.api.Bridge;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;

public class MessageWrapper
extends Message {
    private boolean isOneWay = false;
    private SecuredMessage sm;
    private List headers;
    private MessageHeaders hl = new HeaderList();
    private MutableXMLStreamBuffer bufferedMsg = null;

    public MessageWrapper(SecuredMessage sm, boolean oneWay) {
        this.sm = sm;
        this.isOneWay = oneWay;
        this.headers = sm.getHeaders();
        for (int i = 0; i < this.headers.size(); ++i) {
            Object obj = this.headers.get(i);
            if (obj instanceof Header) {
                this.hl.add((Header)obj);
                continue;
            }
            this.hl.add((Header)new HeaderWrapper((SecurityElement)obj));
        }
    }

    public MessageWrapper(MutableXMLStreamBuffer msg, boolean oneWay, MessageHeaders hdrs, SecuredMessage sm) {
        this.bufferedMsg = msg;
        this.sm = sm;
        this.hl = hdrs;
        this.isOneWay = oneWay;
    }

    public boolean hasHeaders() {
        return ((HeaderList)this.hl).size() > 0;
    }

    public HeaderList getHeaders() {
        return (HeaderList)this.hl;
    }

    public AttachmentSet getAttachments() {
        return this.sm.getAttachments();
    }

    protected boolean hasAttachments() {
        return this.sm.getAttachments() != null;
    }

    public boolean isOneWay(@NotNull WSDLPort port) {
        return this.isOneWay;
    }

    public String getPayloadLocalPart() {
        return this.sm.getPayloadLocalPart();
    }

    public boolean isFault() {
        String localPart = this.getPayloadLocalPart();
        String action = null;
        if ("EncryptedData".equals(localPart)) {
            if (this.hl != null) {
                try {
                    action = AddressingUtils.getAction((MessageHeaders)this.hl, (AddressingVersion)AddressingVersion.W3C, (SOAPVersion)this.sm.getSOAPVersion());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (action != null && action.endsWith("addressing/fault")) {
                localPart = "Fault";
            }
        }
        if (localPart == null || !localPart.equals("Fault")) {
            return false;
        }
        String nsUri = this.getPayloadNamespaceURI();
        return nsUri.equals(SOAPVersion.SOAP_11.nsUri) || nsUri.equals(SOAPVersion.SOAP_12.nsUri);
    }

    public String getPayloadNamespaceURI() {
        return this.sm.getPayloadNamespaceURI();
    }

    public boolean hasPayload() {
        return true;
    }

    public Source readEnvelopeAsSource() {
        throw new UnsupportedOperationException();
    }

    public Source readPayloadAsSource() {
        throw new UnsupportedOperationException();
    }

    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) {
        throw new UnsupportedOperationException();
    }

    public <T> T readPayloadAsJAXB(Bridge<T> bridge) {
        throw new UnsupportedOperationException();
    }

    public XMLStreamReader readPayload() throws XMLStreamException {
        this._check();
        return this.sm.readPayload();
    }

    public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        this._check();
        this.sm.writePayloadTo(sw);
    }

    public void writeTo(XMLStreamWriter sw) throws XMLStreamException {
        if (this.bufferedMsg != null) {
            this.bufferedMsg.writeToXMLStreamWriter(sw);
            return;
        }
        this.sm.writeTo(sw);
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) {
        throw new UnsupportedOperationException();
    }

    public MessageWrapper copy() {
        return this;
    }

    private void _check() {
        if (this.bufferedMsg != null) {
            throw new UnsupportedOperationException("Message is buffered , only writeTo method is supported");
        }
    }

    public <T> T readPayloadAsJAXB(XMLBridge<T> arg0) {
        throw new UnsupportedOperationException();
    }
}

