/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSProcessor;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.SecurityRecipient;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.config.SecurityConfigurationXmlReader;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import jakarta.xml.soap.SOAPMessage;
import java.io.InputStream;
import javax.security.auth.callback.CallbackHandler;

public class XWSSProcessor2_0Impl
implements XWSSProcessor {
    private DeclarativeSecurityConfiguration declSecConfig = null;
    private CallbackHandler handler = null;
    private SecurityEnvironment secEnv = null;

    protected XWSSProcessor2_0Impl(InputStream securityConfig, CallbackHandler handler) throws XWSSecurityException {
        try {
            this.declSecConfig = SecurityConfigurationXmlReader.createDeclarativeConfiguration(securityConfig);
            this.handler = handler;
            this.secEnv = new DefaultSecurityEnvironmentImpl(this.handler);
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    protected XWSSProcessor2_0Impl(InputStream securityConfig) throws XWSSecurityException {
        throw new UnsupportedOperationException("Operation Not Supported");
    }

    @Override
    public SOAPMessage secureOutboundMessage(ProcessingContext context) throws XWSSecurityException {
        MessagePolicy resolvedPolicy = null;
        if (this.declSecConfig == null) {
            throw new XWSSecurityException("Security Policy Unknown");
        }
        resolvedPolicy = this.declSecConfig.senderSettings();
        if (resolvedPolicy == null) {
            return context.getSOAPMessage();
        }
        if (context.getHandler() == null && context.getSecurityEnvironment() == null) {
            context.setSecurityEnvironment(this.secEnv);
        }
        context.setSecurityPolicy(resolvedPolicy);
        try {
            SecurityAnnotator.secureMessage(context);
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
        try {
            SOAPMessage msg = context.getSOAPMessage();
            return msg;
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    @Override
    public SOAPMessage verifyInboundMessage(ProcessingContext context) throws XWSSecurityException {
        MessagePolicy resolvedPolicy = null;
        if (this.declSecConfig == null) {
            throw new XWSSecurityException("Security Policy Unknown");
        }
        resolvedPolicy = this.declSecConfig.receiverSettings();
        if (context.getHandler() == null && context.getSecurityEnvironment() == null) {
            context.setSecurityEnvironment(this.secEnv);
        }
        if (this.declSecConfig.retainSecurityHeader()) {
            context.retainSecurityHeader(true);
        }
        if (this.declSecConfig.resetMustUnderstand()) {
            context.resetMustUnderstand(true);
        }
        context.setSecurityPolicy(resolvedPolicy);
        try {
            SecurityRecipient.validateMessage(context);
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
        try {
            SOAPMessage msg = context.getSOAPMessage();
            return msg;
        }
        catch (Exception e) {
            throw new XWSSecurityException((Throwable)e);
        }
    }

    @Override
    public ProcessingContext createProcessingContext(SOAPMessage msg) throws XWSSecurityException {
        ProcessingContext cntxt = new ProcessingContext();
        cntxt.setSOAPMessage(msg);
        return cntxt;
    }
}

