/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core.reference;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.impl.XMLUtil;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmbeddedReference
extends ReferenceElement {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private SOAPElement embeddedElement;

    public EmbeddedReference() throws XWSSecurityException {
        try {
            this.setSOAPElement(soapFactory.createElement("Embedded", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"));
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0750.soap.exception", new Object[]{"wsse:Embedded", e.getMessage()});
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public EmbeddedReference(SOAPElement element) throws XWSSecurityException {
        this.setSOAPElement(element);
        if (!element.getLocalName().equals("Embedded") || !XMLUtil.inWsseNS(element)) {
            log.log(Level.SEVERE, "WSS0752.invalid.embedded.reference");
            throw new XWSSecurityException("Invalid EmbeddedReference passed");
        }
        Iterator eachChild = this.getChildElements();
        Node node = null;
        while (!(node instanceof SOAPElement) && eachChild.hasNext()) {
            node = (Node)eachChild.next();
        }
        if (node == null || node.getNodeType() != 1) {
            log.log(Level.SEVERE, "WSS0753.missing.embedded.token");
            throw new XWSSecurityException("Passed EmbeddedReference does not contain an embedded element");
        }
        this.embeddedElement = (SOAPElement)node;
    }

    public SOAPElement getEmbeddedSoapElement() {
        return this.embeddedElement;
    }

    public void setEmbeddedSoapElement(SOAPElement element) throws XWSSecurityException {
        if (this.embeddedElement != null) {
            log.log(Level.SEVERE, "WSS0754.token.already.set");
            throw new XWSSecurityException("Embedded element is already present");
        }
        this.embeddedElement = element;
        try {
            this.addChildElement(this.embeddedElement);
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0755.soap.exception", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public String getWsuId() {
        String wsuId = this.getAttribute("wsu:Id");
        if (wsuId.equals("")) {
            return null;
        }
        return wsuId;
    }

    public void setWsuId(String wsuId) {
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        this.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", wsuId);
    }
}

