/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.EncryptedElements;
import com.sun.xml.ws.security.impl.policy.EncryptedParts;
import com.sun.xml.ws.security.impl.policy.LogStringsMessages;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.SignedElements;
import com.sun.xml.ws.security.impl.policy.SignedParts;
import com.sun.xml.ws.security.impl.policy.UnsupportedPolicyAssertion;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class SupportingTokens
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.SupportingTokens {
    private AlgorithmSuite algSuite;
    private List<com.sun.xml.ws.security.policy.SignedParts> spList = new ArrayList<com.sun.xml.ws.security.policy.SignedParts>(1);
    private List<com.sun.xml.ws.security.policy.EncryptedParts> epList = new ArrayList<com.sun.xml.ws.security.policy.EncryptedParts>(1);
    private List<com.sun.xml.ws.security.policy.SignedElements> seList = new ArrayList<com.sun.xml.ws.security.policy.SignedElements>(1);
    private List<com.sun.xml.ws.security.policy.EncryptedElements> eeList = new ArrayList<com.sun.xml.ws.security.policy.EncryptedElements>(1);
    private boolean isServer = false;
    private List<Token> _tokenList;
    private boolean populated;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;

    public SupportingTokens() {
    }

    public SupportingTokens(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    public void setAlgorithmSuite(AlgorithmSuite algSuite) {
        this.algSuite = algSuite;
    }

    @Override
    public AlgorithmSuite getAlgorithmSuite() {
        this.populate();
        return this.algSuite;
    }

    public void addToken(Token token) {
        if (this._tokenList == null) {
            this._tokenList = new ArrayList<Token>();
        }
        this._tokenList.add(token);
    }

    @Override
    public Iterator getTokens() {
        this.populate();
        if (this._tokenList != null) {
            return this._tokenList.iterator();
        }
        return Collections.emptyList().iterator();
    }

    private synchronized void populate() {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            if (policy == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isAlgorithmAssertion(assertion, this.spVersion)) {
                    this.algSuite = (AlgorithmSuite)assertion;
                    String sigAlgo = assertion.getAttributeValue(new QName("signatureAlgorithm"));
                    this.algSuite.setSignatureAlgorithm(sigAlgo);
                    continue;
                }
                if (PolicyUtil.isToken(assertion, this.spVersion)) {
                    this.addToken((Token)assertion);
                    continue;
                }
                if (PolicyUtil.isSignedParts(assertion, this.spVersion)) {
                    this.spList.add((SignedParts)assertion);
                    continue;
                }
                if (PolicyUtil.isSignedElements(assertion, this.spVersion)) {
                    this.seList.add((SignedElements)assertion);
                    continue;
                }
                if (PolicyUtil.isEncryptParts(assertion, this.spVersion)) {
                    this.epList.add((EncryptedParts)assertion);
                    continue;
                }
                if (PolicyUtil.isEncryptedElements(assertion, this.spVersion)) {
                    this.eeList.add((EncryptedElements)assertion);
                    continue;
                }
                if (assertion.isOptional()) continue;
                if (Constants.logger.getLevel() == Level.SEVERE) {
                    Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0100_INVALID_SECURITY_ASSERTION(assertion, "SecurityContextToken"));
                }
                if (!this.isServer) continue;
                throw new UnsupportedPolicyAssertion("Policy assertion " + assertion + " is not supported under SupportingTokens assertion");
            }
            Iterator parameterAssertion = this.getParametersIterator();
            while (parameterAssertion.hasNext()) {
                PolicyAssertion assertion = (PolicyAssertion)parameterAssertion.next();
                if (PolicyUtil.isSignedParts(assertion, this.spVersion)) {
                    this.spList.add((SignedParts)assertion);
                    continue;
                }
                if (PolicyUtil.isSignedElements(assertion, this.spVersion)) {
                    this.seList.add((SignedElements)assertion);
                    continue;
                }
                if (PolicyUtil.isEncryptParts(assertion, this.spVersion)) {
                    this.epList.add((EncryptedParts)assertion);
                    continue;
                }
                if (PolicyUtil.isEncryptedElements(assertion, this.spVersion)) {
                    this.eeList.add((EncryptedElements)assertion);
                    continue;
                }
                if (assertion.isOptional()) continue;
                if (Constants.logger.getLevel() == Level.SEVERE) {
                    Constants.logger.log(Level.SEVERE, LogStringsMessages.SP_0100_INVALID_SECURITY_ASSERTION(assertion, "SecurityContextToken"));
                }
                if (!this.isServer) continue;
                throw new UnsupportedPolicyAssertion("Policy assertion " + assertion + " is not supported under SupportingTokens assertion");
            }
            this.populated = true;
        }
    }

    public String getIncludeToken() {
        return "";
    }

    public void setIncludeToken(String type) {
    }

    public String getTokenId() {
        return "";
    }

    @Override
    public Iterator<com.sun.xml.ws.security.policy.SignedParts> getSignedParts() {
        this.populate();
        return this.spList.iterator();
    }

    @Override
    public Iterator<com.sun.xml.ws.security.policy.SignedElements> getSignedElements() {
        this.populate();
        return this.seList.iterator();
    }

    @Override
    public Iterator<com.sun.xml.ws.security.policy.EncryptedParts> getEncryptedParts() {
        this.populate();
        return this.epList.iterator();
    }

    @Override
    public Iterator<com.sun.xml.ws.security.policy.EncryptedElements> getEncryptedElements() {
        this.populate();
        return this.eeList.iterator();
    }

    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

