/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.AddressingUtils;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.security.secconv.client.SCTokenConfiguration;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenManager;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.developer.WSBindingProvider;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.message.stream.LazyStreamBasedMessage;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityRecipient;
import com.sun.xml.ws.security.opt.impl.util.CertificateRetriever;
import com.sun.xml.ws.security.policy.IssuedToken;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secconv.impl.client.DefaultSCTokenConfiguration;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.STSIssuedTokenFeature;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.client.DefaultSTSIssuedTokenConfiguration;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.NewSecurityRecipient;
import com.sun.xml.wss.impl.PolicyResolver;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.WSITProviderSecurityEnvironment;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.jaxws.impl.Constants;
import com.sun.xml.wss.provider.wsit.PolicyAlternativeHolder;
import com.sun.xml.wss.provider.wsit.PolicyResolverFactory;
import com.sun.xml.wss.provider.wsit.WSITAuthContextBase;
import com.sun.xml.wss.provider.wsit.WSITClientAuthConfig;
import com.sun.xml.wss.provider.wsit.WSITClientAuthModule;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

public class WSITClientAuthContext
extends WSITAuthContextBase
implements ClientAuthContext {
    private IssuedTokenManager itm;
    private Set trustConfig = null;
    private Set wsscConfig = null;
    private CallbackHandler handler = null;
    WSITClientAuthModule authModule = null;
    private Hashtable<String, String> scPolicyIDtoSctIdMap = new Hashtable();
    protected WeakReference<WSITClientAuthConfig> authConfig;
    protected int tubeOrPipeHashCode;

    public WSITClientAuthContext(String operation, Subject subject, Map<Object, Object> map, CallbackHandler callbackHandler) {
        super(map);
        String jmacHandler;
        this.authConfig = new WeakReference<WSITClientAuthConfig>((WSITClientAuthConfig)map.get("AUTH_CONFIG"));
        this.tubeOrPipeHashCode = map.get("SECURITY_PIPE").hashCode();
        WSDLPortImpl wpi = (WSDLPortImpl)map.get("WSDL_MODEL");
        ClientTubeAssemblerContext context = (ClientTubeAssemblerContext)map.get("WRAPPED_CONTEXT");
        this.itm = IssuedTokenManager.getInstance();
        Set<PolicyAssertion> configAssertions = null;
        for (PolicyAlternativeHolder p : this.policyAlternatives) {
            for (SecurityPolicyHolder holder : p.getOutMessagePolicyMap().values()) {
                if (configAssertions != null) {
                    configAssertions.addAll(holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/client"));
                } else {
                    configAssertions = holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/client");
                }
                if (this.trustConfig != null) {
                    this.trustConfig.addAll(holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/client"));
                } else {
                    this.trustConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/client");
                }
                if (this.wsscConfig != null) {
                    this.wsscConfig.addAll(holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/sc/client"));
                    continue;
                }
                this.wsscConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/sc/client");
            }
        }
        Properties props = new Properties();
        if (callbackHandler != null) {
            this.populateConfigProperties(configAssertions, props);
            try {
                jmacHandler = props.getProperty("jmac.callbackhandler");
                this.handler = jmacHandler != null ? this.loadGFHandler(true, jmacHandler) : callbackHandler;
                this.secEnv = new WSITProviderSecurityEnvironment(this.handler, map, props);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0027_ERROR_POPULATING_CLIENT_CONFIG_PROP(), ex);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0027_ERROR_POPULATING_CLIENT_CONFIG_PROP(), (Throwable)ex);
            }
        } else {
            this.handler = this.configureClientHandler(configAssertions, props);
            jmacHandler = props.getProperty("jmac.callbackhandler");
            if (jmacHandler != null) {
                try {
                    this.handler = this.loadGFHandler(true, jmacHandler);
                    this.secEnv = new WSITProviderSecurityEnvironment(this.handler, map, props);
                }
                catch (XWSSecurityException ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0027_ERROR_POPULATING_CLIENT_CONFIG_PROP(), ex);
                    throw new WebServiceException(LogStringsMessages.WSITPVD_0027_ERROR_POPULATING_CLIENT_CONFIG_PROP(), (Throwable)ex);
                }
            } else {
                this.secEnv = new DefaultSecurityEnvironmentImpl(this.handler, props);
            }
        }
        X509Certificate cert = this.getCertificateFromEPR(context, wpi);
        if (cert != null) {
            props.put("SERVER_CERT", cert);
            this.serverCert = cert;
        }
        this.authModule = new WSITClientAuthModule();
        try {
            this.authModule.initialize(null, null, null, map);
        }
        catch (AuthException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0028_ERROR_INIT_AUTH_MODULE(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0028_ERROR_INIT_AUTH_MODULE(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
        try {
            try {
                Packet packet = this.getRequestPacket(messageInfo);
                HaContext.initFrom((Packet)packet);
                boolean isTrustMsg = false;
                if ("true".equals(packet.invocationProperties.get("isTrustMessage"))) {
                    isTrustMsg = true;
                    String action = (String)packet.invocationProperties.get("trustAction");
                    MessageHeaders headers = packet.getMessage().getHeaders();
                    AddressingUtils.fillRequestAddressingHeaders((MessageHeaders)headers, (Packet)packet, (AddressingVersion)this.addVer, (SOAPVersion)this.soapVersion, (boolean)false, (String)action);
                }
                Map msgInfoMap = messageInfo.getMap();
                msgInfoMap.put("IS_TRUST_MSG", isTrustMsg);
                this.invokeSCPlugin(packet);
                Packet ret = this.secureRequest(packet, clientSubject, false);
                this.setRequestPacket(messageInfo, ret);
            }
            catch (XWSSecurityException e) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0050_ERROR_SECURE_REQUEST(), e);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0050_ERROR_SECURE_REQUEST(), (Throwable)this.getSOAPFaultException(e));
            }
            AuthStatus authStatus = AuthStatus.SEND_SUCCESS;
            return authStatus;
        }
        finally {
            HaContext.clear();
        }
    }

    public Packet secureRequest(Packet packet, Subject clientSubject, boolean isSCMessage) throws XWSSecurityException {
        Message msg = packet.getInternalMessage();
        this.invokeTrustPlugin(packet, isSCMessage);
        ProcessingContext ctx = this.initializeOutgoingProcessingContext(packet, isSCMessage);
        ((ProcessingContextImpl)ctx).setIssuedTokenContextMap(this.issuedTokenContextMap);
        ((ProcessingContextImpl)ctx).setSCPolicyIDtoSctIdMap(this.scPolicyIDtoSctIdMap);
        ctx.isClient(true);
        if (this.hasKerberosTokenPolicy()) {
            this.populateKerberosContext(packet, (ProcessingContextImpl)ctx, isSCMessage);
        }
        if (this.isSCRenew(packet)) {
            DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(this.wsscVer.getNamespaceURI());
            config.getOtherOptions().put("MessagePolicy", (MessagePolicy)ctx.getSecurityPolicy());
            IssuedTokenContext itc = this.itm.createIssuedTokenContext((IssuedTokenConfiguration)config, packet.endpointAddress.toString());
            try {
                this.itm.renewIssuedToken(itc);
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), (Throwable)se);
            }
        }
        try {
            if (!this.optimized) {
                if (!isSCMessage) {
                    this.cacheOperation(msg, packet);
                }
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.secureOutboundMessage(soapMessage, ctx);
                msg = Messages.create((SOAPMessage)soapMessage);
            } else {
                msg = this.secureOutboundMessage(msg, ctx);
            }
        }
        catch (WssSoapFaultException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), ex);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)this.getSOAPFaultException(ex));
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)se);
        }
        packet.setMessage(msg);
        if (isSCMessage) {
            if (this.isSCRenew(packet)) {
                Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
                DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(this.wsscVer.getNamespaceURI(), false);
                config.getOtherOptions().put("MessagePolicy", this.getOutgoingXWSBootstrapPolicy(scToken));
                IssuedTokenContext itc = this.itm.createIssuedTokenContext((IssuedTokenConfiguration)config, packet.endpointAddress.toString());
                try {
                    this.itm.renewIssuedToken(itc);
                }
                catch (WSTrustException se) {
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), se);
                    throw new WebServiceException(LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), (Throwable)se);
                }
            }
            Packet responsePacket = null;
            if (this.nextPipe != null) {
                responsePacket = this.nextPipe.process(packet);
            } else if (this.nextTube != null) {
                responsePacket = Fiber.current().owner.createFiber().runSync(this.nextTube, packet);
            }
            packet = this.validateResponse(responsePacket, null, null);
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        try {
            try {
                boolean isTrustMsg;
                Packet ret = this.getResponsePacket(messageInfo);
                HaContext.initFrom((Packet)ret);
                ret = this.validateResponse(ret, clientSubject, serviceSubject);
                this.resetCachedOperation(ret);
                Boolean trustMsgProp = (Boolean)messageInfo.getMap().get("IS_TRUST_MSG");
                boolean bl = isTrustMsg = trustMsgProp != null ? trustMsgProp : false;
                if (isTrustMsg) {
                    this.getAction(ret);
                }
                this.setResponsePacket(messageInfo, ret);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0033_ERROR_VALIDATE_RESPONSE(), ex);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0033_ERROR_VALIDATE_RESPONSE(), (Throwable)this.getSOAPFaultException(ex));
            }
            AuthStatus authStatus = AuthStatus.SUCCESS;
            return authStatus;
        }
        finally {
            HaContext.clear();
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.cancelSecurityContextToken();
        ((WSITClientAuthConfig)this.authConfig.get()).cleanupAuthContext(this.tubeOrPipeHashCode);
        this.authConfig.clear();
        this.nextPipe = null;
        this.nextTube = null;
    }

    public Packet validateResponse(Packet req, Subject clientSubject, Subject serviceSubject) throws XWSSecurityException {
        ProcessingContext ctx = this.initializeInboundProcessingContext(req);
        ctx.isClient(true);
        ((ProcessingContextImpl)ctx).setIssuedTokenContextMap(this.issuedTokenContextMap);
        ((ProcessingContextImpl)ctx).setSCPolicyIDtoSctIdMap(this.scPolicyIDtoSctIdMap);
        PolicyResolver pr = PolicyResolverFactory.createPolicyResolver(this.policyAlternatives, this.cachedOperation(req), this.pipeConfig, this.addVer, true, this.rmVer, this.mcVer);
        ctx.setExtraneousProperty("OperationResolver", pr);
        Message msg = req.getInternalMessage();
        try {
            if (!this.optimized) {
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.verifyInboundMessage(soapMessage, ctx);
                if (msg.isFault()) {
                    if (debug) {
                        DumpFilter.process(ctx);
                    }
                    SOAPFault fault = soapMessage.getSOAPBody().getFault();
                    throw new SOAPFaultException(fault);
                }
                msg = Messages.create((SOAPMessage)soapMessage);
            } else {
                msg = this.verifyInboundMessage(msg, ctx);
            }
        }
        catch (XWSSecurityException xwse) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), xwse);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), (Throwable)this.getSOAPFaultException(xwse));
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), (Throwable)se);
        }
        req.setMessage(msg);
        return req;
    }

    @Override
    protected SOAPMessage secureOutboundMessage(SOAPMessage message, ProcessingContext ctx) {
        try {
            ctx.setSOAPMessage(message);
            SecurityAnnotator.secureMessage(ctx);
            return ctx.getSOAPMessage();
        }
        catch (WssSoapFaultException soapFaultException) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), soapFaultException);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)this.getSOAPFaultException(soapFaultException));
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), wsfe);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)this.getSOAPFaultException(wsfe));
        }
    }

    @Override
    protected Message secureOutboundMessage(Message message, ProcessingContext ctx) {
        try {
            JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)ctx;
            context.setSOAPVersion(this.soapVersion);
            context.setAllowMissingTimestamp(this.allowMissingTimestamp);
            context.setMustUnderstandValue(this.securityMUValue);
            context.setJAXWSMessage(message, this.soapVersion);
            context.isOneWayMessage(message.isOneWay(this.pipeConfig.getWSDLPort()));
            context.setDisableIncPrefix(this.disableIncPrefix);
            context.setEncHeaderContent(this.encHeaderContent);
            SecurityAnnotator.secureMessage(context);
            return context.getJAXWSMessage();
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), wsfe);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)this.getSOAPFaultException(wsfe));
        }
    }

    protected SOAPMessage verifyInboundMessage(SOAPMessage message, ProcessingContext ctx) throws WssSoapFaultException, XWSSecurityException {
        try {
            ctx.setSOAPMessage(message);
            if (debug) {
                DumpFilter.process(ctx);
            }
            NewSecurityRecipient.validateMessage(ctx);
            return ctx.getSOAPMessage();
        }
        catch (WssSoapFaultException soapFaultException) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), soapFaultException);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), (Throwable)this.getSOAPFaultException(soapFaultException));
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), wsfe);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), (Throwable)this.getSOAPFaultException(wsfe));
        }
    }

    protected Message verifyInboundMessage(Message message, ProcessingContext ctx) throws XWSSecurityException {
        JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)ctx;
        if (debug) {
            try {
                ((LazyStreamBasedMessage)message).print();
            }
            catch (XMLStreamException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0003_PROBLEM_PRINTING_MSG(), ex);
                throw new XWSSecurityException(LogStringsMessages.WSITPVD_0003_PROBLEM_PRINTING_MSG(), (Throwable)ex);
            }
        }
        LazyStreamBasedMessage lazyStreamMessage = (LazyStreamBasedMessage)message;
        AttachmentSet attachSet = lazyStreamMessage.getAttachments();
        SecurityRecipient recipient = null;
        recipient = attachSet == null || attachSet.isEmpty() ? new SecurityRecipient(lazyStreamMessage.readMessage(), this.soapVersion) : new SecurityRecipient(lazyStreamMessage.readMessage(), this.soapVersion, attachSet);
        return recipient.validateMessage(context);
    }

    @Override
    protected SecurityPolicyHolder addOutgoingMP(WSDLBoundOperation operation, Policy policy, PolicyAlternativeHolder ph) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, false, false);
        ph.getOutMessagePolicyMap().put(operation, sph);
        return sph;
    }

    @Override
    protected SecurityPolicyHolder addIncomingMP(WSDLBoundOperation operation, Policy policy, PolicyAlternativeHolder ph) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, false, true);
        ph.getInMessagePolicyMap().put(operation, sph);
        return sph;
    }

    @Override
    protected void addIncomingProtocolPolicy(Policy effectivePolicy, String protocol, PolicyAlternativeHolder ph) throws PolicyException {
        ph.getInProtocolPM().put(protocol, this.constructPolicyHolder(effectivePolicy, false, true, true));
    }

    @Override
    protected void addOutgoingProtocolPolicy(Policy effectivePolicy, String protocol, PolicyAlternativeHolder ph) throws PolicyException {
        ph.getOutProtocolPM().put(protocol, this.constructPolicyHolder(effectivePolicy, false, false, false));
    }

    @Override
    protected void addIncomingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, false, true);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected void addOutgoingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, false, false);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected String getAction(WSDLOperation operation, boolean inComming) {
        if (!inComming) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    JAXBElement startSecureConversation(Packet packet) throws WSSecureConversationException {
        List<PolicyAssertion> toks = this.getOutBoundSCP(packet.getMessage());
        if (toks.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WSITPVD_0030_NO_POLICY_FOUND_FOR_SC());
            }
            return null;
        }
        Token tok = (Token)toks.get(0);
        IssuedTokenContext ctx = (IssuedTokenContext)this.issuedTokenContextMap.get(tok.getTokenId());
        PolicyAssertion scClientAssertion = null;
        if (this.wsscConfig != null) {
            Iterator it = this.wsscConfig.iterator();
            while (it != null && it.hasNext()) {
                scClientAssertion = (PolicyAssertion)it.next();
            }
        }
        if (ctx == null) {
            try {
                DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(this.wsscVer.getNamespaceURI(), (SecureConversationToken)tok, this.pipeConfig.getWSDLPort(), this.pipeConfig.getBinding(), packet, this.addVer, scClientAssertion);
                config.getOtherOptions().put("WSITClientAuthContext", this);
                ctx = this.itm.createIssuedTokenContext((IssuedTokenConfiguration)config, packet.endpointAddress.toString());
                this.itm.getIssuedToken(ctx);
                this.issuedTokenContextMap.put(tok.getTokenId(), ctx);
                SCTokenConfiguration sctConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
                this.scPolicyIDtoSctIdMap.put(tok.getTokenId(), sctConfig.getTokenId());
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), (Throwable)se);
            }
        }
        SecurityTokenReference str = (SecurityTokenReference)ctx.getUnAttachedSecurityTokenReference();
        return WSTrustElementFactory.newInstance().toJAXBElement(str);
    }

    private CallbackHandler configureClientHandler(Set configAssertions, Properties props) {
        String ret = this.populateConfigProperties(configAssertions, props);
        try {
            if (ret != null) {
                Class handlerClass = this.loadClass(ret);
                Object obj = handlerClass.newInstance();
                if (!(obj instanceof CallbackHandler)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0031_INVALID_CALLBACK_HANDLER_CLASS(ret));
                    throw new RuntimeException(LogStringsMessages.WSITPVD_0031_INVALID_CALLBACK_HANDLER_CLASS(ret));
                }
                return (CallbackHandler)obj;
            }
            return new DefaultCallbackHandler("client", props);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0032_ERROR_CONFIGURE_CLIENT_HANDLER(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0032_ERROR_CONFIGURE_CLIENT_HANDLER(), e);
        }
    }

    private X509Certificate getCertificateFromEPR(ClientTubeAssemblerContext context, WSDLPortImpl wpi) {
        WSBindingProvider bpr;
        X509Certificate x509Cert = null;
        if (context != null && (x509Cert = (X509Certificate)(bpr = context.getBindingProvider()).getRequestContext().get("server-certificate")) != null) {
            return x509Cert;
        }
        if (wpi != null) {
            WSEndpointReference epr = wpi.getEPR();
            if (epr != null) {
                WSEndpointReference.EPRExtension idExtn = null;
                XMLStreamReader xmlReader = null;
                try {
                    QName ID_QNAME = new QName("http://schemas.xmlsoap.org/ws/2006/02/addressingidentity", "Identity");
                    idExtn = epr.getEPRExtension(ID_QNAME);
                    if (idExtn != null) {
                        xmlReader = idExtn.readAsXMLStreamReader();
                        CertificateRetriever cr = new CertificateRetriever();
                        byte[] bstValue = cr.getBSTFromIdentityExtension(xmlReader);
                        X509Certificate certificate = null;
                        if (bstValue != null) {
                            certificate = cr.constructCertificate(bstValue);
                        }
                        return certificate;
                    }
                }
                catch (XMLStreamException ex) {
                    log.log(Level.WARNING, ex.getMessage());
                }
            }
            return null;
        }
        return null;
    }

    private void invokeSCPlugin(Packet packet) {
        List<PolicyAssertion> policies = this.getOutBoundSCP(packet.getMessage());
        PolicyAssertion scClientAssertion = null;
        if (this.wsscConfig != null) {
            Iterator it = this.wsscConfig.iterator();
            while (it != null && it.hasNext()) {
                scClientAssertion = (PolicyAssertion)it.next();
            }
        }
        for (PolicyAssertion scAssertion : policies) {
            Token scToken = (Token)scAssertion;
            if (this.issuedTokenContextMap.get(scToken.getTokenId()) != null) continue;
            try {
                DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(this.wsscVer.getNamespaceURI(), (SecureConversationToken)scToken, this.pipeConfig.getWSDLPort(), this.pipeConfig.getBinding(), packet, this.addVer, scClientAssertion);
                config.getOtherOptions().put("WSITClientAuthContext", this);
                IssuedTokenContext ctx = this.itm.createIssuedTokenContext((IssuedTokenConfiguration)config, packet.endpointAddress.toString());
                this.itm.getIssuedToken(ctx);
                this.issuedTokenContextMap.put(scToken.getTokenId(), ctx);
                SCTokenConfiguration sctConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
                this.scPolicyIDtoSctIdMap.put(scToken.getTokenId(), sctConfig.getTokenId());
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), (Throwable)se);
            }
        }
    }

    private void cancelSecurityContextToken() {
        Enumeration keys = this.issuedTokenContextMap.keys();
        while (keys.hasMoreElements()) {
            String id = (String)keys.nextElement();
            IssuedTokenContext ctx = (IssuedTokenContext)this.issuedTokenContextMap.get(id);
            if (!(ctx.getSecurityToken() instanceof SecurityContextToken)) continue;
            try {
                this.itm.cancelIssuedToken(ctx);
                this.issuedTokenContextMap.remove(id);
                this.scPolicyIDtoSctIdMap.remove(id);
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), (Throwable)se);
            }
        }
    }

    private void invokeTrustPlugin(Packet packet, boolean isSCMessage) {
        List<PolicyAssertion> policies = null;
        if (isSCMessage) {
            Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
            policies = this.getIssuedTokenPoliciesFromBootstrapPolicy(scToken);
        } else {
            policies = this.getIssuedTokenPolicies(packet, Constants.OPERATION_SCOPE);
        }
        PolicyAssertion preSetSTSAssertion = null;
        if (this.trustConfig != null) {
            Iterator it = this.trustConfig.iterator();
            while (it != null && it.hasNext()) {
                preSetSTSAssertion = (PolicyAssertion)it.next();
            }
        }
        for (PolicyAssertion issuedTokenAssertion : policies) {
            STSIssuedTokenConfiguration rtConfig = null;
            STSIssuedTokenFeature stsFeature = (STSIssuedTokenFeature)this.pipeConfig.getBinding().getFeature(STSIssuedTokenFeature.class);
            if (stsFeature != null) {
                rtConfig = stsFeature.getSTSIssuedTokenConfiguration();
            }
            DefaultSTSIssuedTokenConfiguration config = null;
            if (this.issuedTokenContextMap.get(((Token)issuedTokenAssertion).getTokenId()) != null && rtConfig == null) continue;
            try {
                String stsEndpoint = (String)packet.invocationProperties.get("sts-endpoint");
                if (stsEndpoint != null) {
                    String stsMEXAddress = (String)packet.invocationProperties.get("sts-mex-address");
                    if (stsMEXAddress == null) {
                        String stsNamespace = (String)packet.invocationProperties.get("sts-namespace");
                        String stsWSDLLocation = (String)packet.invocationProperties.get("sts-wsdlLocation");
                        String stsServiceName = (String)packet.invocationProperties.get("sts-service-name");
                        String stsPortName = (String)packet.invocationProperties.get("sts-port-name");
                        config = new DefaultSTSIssuedTokenConfiguration(this.wsTrustVer.getNamespaceURI(), stsEndpoint, stsWSDLLocation, stsServiceName, stsPortName, stsNamespace);
                    } else {
                        config = new DefaultSTSIssuedTokenConfiguration(this.wsTrustVer.getNamespaceURI(), stsEndpoint, stsMEXAddress);
                    }
                }
                if (config == null) {
                    config = new DefaultSTSIssuedTokenConfiguration(this.wsTrustVer.getNamespaceURI(), (IssuedToken)issuedTokenAssertion, preSetSTSAssertion);
                }
                config.getOtherOptions().putAll(packet.invocationProperties);
                if (this.serverCert != null) {
                    if (!this.isCertValidityVerified) {
                        CertificateRetriever cr = new CertificateRetriever();
                        this.isCertValid = cr.setServerCertInTheSTSConfig(config, this.secEnv, this.serverCert);
                        cr = null;
                        this.isCertValidityVerified = true;
                    } else if (this.isCertValid) {
                        config.getOtherOptions().put("Identity", this.serverCert);
                    }
                }
                if (rtConfig != null) {
                    rtConfig.getOtherOptions().put("IssuedToken", config);
                    rtConfig.getOtherOptions().put("AppliesTo", packet.endpointAddress.toString());
                    config.copy(rtConfig);
                }
                IssuedTokenContext ctx = this.itm.createIssuedTokenContext((IssuedTokenConfiguration)config, packet.endpointAddress.toString());
                this.itm.getIssuedToken(ctx);
                this.issuedTokenContextMap.put(((Token)issuedTokenAssertion).getTokenId(), ctx);
                this.updateMPForIssuedTokenAsEncryptedSupportingToken(packet, ctx, ((Token)issuedTokenAssertion).getTokenId());
            }
            catch (WSTrustException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), se);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), (Throwable)se);
            }
        }
    }

    protected List<PolicyAssertion> getIssuedTokenPolicies(Packet packet, String scope) {
        ArrayList<PolicyAssertion> ret = new ArrayList<PolicyAssertion>();
        for (PolicyAlternativeHolder p : this.policyAlternatives) {
            WSDLBoundOperation operation = null;
            operation = this.isTrustMessage(packet) ? this.getWSDLOpFromAction(packet, false) : this.getOperation(packet.getMessage(), packet);
            SecurityPolicyHolder sph = p.getOutMessagePolicyMap().get(operation);
            if (sph == null) continue;
            ret.addAll(sph.getIssuedTokens());
        }
        return ret;
    }

    protected void populateKerberosContext(Packet packet, ProcessingContextImpl ctx, boolean isSCMessage) throws XWSSecurityException {
        List<PolicyAssertion> toks = this.getOutBoundKTP(packet, isSCMessage);
        if (toks.isEmpty()) {
            return;
        }
        KerberosContext krbContext = ctx.getSecurityEnvironment().doKerberosLogin();
        try {
            byte[] krbSha1 = MessageDigest.getInstance("SHA-1").digest(krbContext.getKerberosToken());
            String encKrbSha1 = Base64.encode(krbSha1);
            ctx.setExtraneousProperty("KerbSHA1Value", encKrbSha1);
            ctx.setKerberosContext(krbContext);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XWSSecurityException((Throwable)nsae);
        }
    }

    private void updateMPForIssuedTokenAsEncryptedSupportingToken(Packet packet, IssuedTokenContext ctx, String issuedTokenPolicyId) {
        Message message = packet.getMessage();
        block0: for (PolicyAlternativeHolder p : this.policyAlternatives) {
            WSDLBoundOperation operation = message.getOperation(this.pipeConfig.getWSDLPort());
            SecurityPolicyHolder sph = p.getOutMessagePolicyMap().get(operation);
            if (sph == null || !sph.isIssuedTokenAsEncryptedSupportingToken()) continue;
            MessagePolicy policy = sph.getMessagePolicy();
            ArrayList list = policy.getPrimaryPolicies();
            Iterator i = list.iterator();
            boolean breakOuterLoop = false;
            while (i.hasNext()) {
                SecurityPolicy primaryPolicy = (SecurityPolicy)i.next();
                if (!PolicyTypeUtil.encryptionPolicy(primaryPolicy)) continue;
                EncryptionPolicy encPolicy = (EncryptionPolicy)primaryPolicy;
                EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)encPolicy.getFeatureBinding();
                ArrayList targetList = featureBinding.getTargetBindings();
                ListIterator iterator = targetList.listIterator();
                while (iterator.hasNext()) {
                    EncryptionTarget encryptionTarget = (EncryptionTarget)iterator.next();
                    String targetURI = encryptionTarget.getValue();
                    if (!targetURI.equals(issuedTokenPolicyId) || ctx == null) continue;
                    GenericToken issuedToken = (GenericToken)ctx.getSecurityToken();
                    encryptionTarget.setValue(issuedToken.getId());
                    sph.setMessagePolicy(policy);
                    p.getOutMessagePolicyMap().put(operation, sph);
                    breakOuterLoop = true;
                    break;
                }
                if (!breakOuterLoop) continue;
                continue block0;
            }
        }
    }

    private void copyStandardSecurityProperties(Packet packet, Packet requestPacket) {
        String password;
        String username = (String)packet.invocationProperties.get("username");
        if (username != null) {
            requestPacket.invocationProperties.put("username", username);
        }
        if ((password = (String)packet.invocationProperties.get("password")) != null) {
            requestPacket.invocationProperties.put("password", password);
        }
    }

    private void renewSCT(ProcessingContext ctx, Packet ret) {
        DefaultSCTokenConfiguration config = new DefaultSCTokenConfiguration(this.wsscVer.getNamespaceURI());
        config.getOtherOptions().put("MessagePolicy", (MessagePolicy)ctx.getSecurityPolicy());
        IssuedTokenContext itc = this.itm.createIssuedTokenContext((IssuedTokenConfiguration)config, ret.endpointAddress.toString());
        try {
            this.itm.renewIssuedToken(itc);
        }
        catch (WSTrustException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0052_ERROR_ISSUEDTOKEN_CREATION(), se);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0027_ERROR_POPULATING_CLIENT_CONFIG_PROP(), (Throwable)se);
        }
    }
}

