/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.elements;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.secconv.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.secconv.impl.bindings.SecurityContextTokenType;
import com.sun.xml.ws.security.secconv.impl.elements.SecurityContextTokenImpl;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.impl.WSTrustElementFactoryImpl;
import com.sun.xml.ws.security.trust.impl.bindings.RequestedSecurityTokenType;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestedSecurityTokenImpl
extends RequestedSecurityTokenType
implements RequestedSecurityToken {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    Token containedToken = null;
    private static final QName SCT_QNAME = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "SecurityContextToken");

    public RequestedSecurityTokenImpl() {
    }

    public RequestedSecurityTokenImpl(@NotNull RequestedSecurityTokenType rdstType) {
        Object rdst = rdstType.getAny();
        if (rdst instanceof JAXBElement) {
            JAXBElement rdstEle = (JAXBElement)rdst;
            QName name = rdstEle.getName();
            if (SCT_QNAME.equals(name)) {
                SecurityContextTokenType sctType = (SecurityContextTokenType)rdstEle.getValue();
                this.setToken((Token)new SecurityContextTokenImpl(sctType));
            } else {
                this.setAny(rdstEle);
                Element token = new WSTrustElementFactoryImpl().toElement(rdstEle);
                this.containedToken = new GenericToken(token);
            }
        } else {
            this.setToken(new GenericToken((Element)rdst));
        }
    }

    public RequestedSecurityTokenImpl(Token token) {
        this.setToken(token);
    }

    public static RequestedSecurityTokenType fromElement(@NotNull Element element) throws WSTrustException {
        try {
            JAXBContext context = WSTrustElementFactory.getContext();
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (RequestedSecurityTokenType)unmarshaller.unmarshal((Node)element, RequestedSecurityTokenType.class).getValue();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0021_ERROR_UNMARSHAL_DOM_ELEMENT(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0021_ERROR_UNMARSHAL_DOM_ELEMENT(), (Throwable)ex);
        }
    }

    public Token getToken() {
        return this.containedToken;
    }

    public final void setToken(Token token) {
        if (token != null) {
            String tokenType = token.getType();
            if ("SecurityContextToken".equals(tokenType)) {
                JAXBElement<SecurityContextTokenType> sctElement = new ObjectFactory().createSecurityContextToken((SecurityContextTokenType)token);
                this.setAny(sctElement);
            } else {
                Element element = (Element)token.getTokenValue();
                this.setAny(element);
            }
        }
        this.containedToken = token;
    }
}

