/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.jaxws.impl;

import com.sun.xml.ws.api.policy.ModelTranslator;
import com.sun.xml.ws.api.policy.ModelUnmarshaller;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.rx.mc.api.McProtocolVersion;
import com.sun.xml.ws.rx.rm.api.RmProtocolVersion;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class RMPolicyResolver {
    SecurityPolicyVersion spVersion;
    RmProtocolVersion rmVersion;
    McProtocolVersion mcVersion;
    boolean encrypt = false;

    public RMPolicyResolver() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
        this.rmVersion = RmProtocolVersion.WSRM200502;
        this.mcVersion = McProtocolVersion.WSMC200702;
    }

    public RMPolicyResolver(SecurityPolicyVersion spVersion, RmProtocolVersion rmVersion) {
        this.spVersion = spVersion;
        this.rmVersion = rmVersion;
        this.mcVersion = McProtocolVersion.WSMC200702;
    }

    public RMPolicyResolver(SecurityPolicyVersion spVersion, RmProtocolVersion rmVersion, McProtocolVersion mcVersion, boolean encrypt) {
        this.spVersion = spVersion;
        this.rmVersion = rmVersion;
        this.mcVersion = mcVersion;
        this.encrypt = encrypt;
    }

    public Policy getOperationLevelPolicy() throws PolicyException {
        PolicySourceModel model;
        try {
            String rmMessagePolicy;
            String string = rmMessagePolicy = this.encrypt ? "rm-msglevel-policy-encrypt.xml" : "rm-msglevel-policy.xml";
            if (SecurityPolicyVersion.SECURITYPOLICY12NS == this.spVersion && RmProtocolVersion.WSRM200502 == this.rmVersion) {
                rmMessagePolicy = "rm-msglevel-policy-sp12.xml";
            } else if (SecurityPolicyVersion.SECURITYPOLICY12NS == this.spVersion && RmProtocolVersion.WSRM200702 == this.rmVersion) {
                rmMessagePolicy = this.encrypt ? "rm-msglevel-policy-sx-encrypt.xml" : "rm-msglevel-policy-sx.xml";
            } else if (SecurityPolicyVersion.SECURITYPOLICY200507 == this.spVersion && RmProtocolVersion.WSRM200702 == this.rmVersion) {
                rmMessagePolicy = "rm-msglevel-policy-sx-sp10.xml";
            }
            model = this.unmarshalPolicy("com/sun/xml/ws/security/impl/policyconv/" + rmMessagePolicy);
        }
        catch (IOException ex) {
            throw new PolicyException((Throwable)ex);
        }
        Policy mbp = ModelTranslator.getTranslator().translate(model);
        return mbp;
    }

    private PolicySourceModel unmarshalPolicy(String resource) throws PolicyException, IOException {
        Reader reader = this.getResourceReader(resource);
        PolicySourceModel model = ModelUnmarshaller.getUnmarshaller().unmarshalModel((Object)reader);
        reader.close();
        return model;
    }

    private Reader getResourceReader(String resourceName) {
        return new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName));
    }
}

