/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.Token,
SecurityAssertionValidator {
    private String _id;
    private boolean populated = false;
    private com.sun.xml.ws.security.policy.Token _token;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private final QName itQname;
    private String _includeToken;

    public Token() {
        this._id = PolicyUtil.randomUUID();
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this._includeToken = this.spVersion.includeTokenAlways;
    }

    public Token(QName name) {
        this._id = PolicyUtil.randomUUID();
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this._includeToken = this.spVersion.includeTokenAlways;
    }

    public Token(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this._includeToken = this.spVersion.includeTokenAlways;
        this._id = PolicyUtil.randomUUID();
    }

    public com.sun.xml.ws.security.policy.Token getToken() {
        this.populate();
        return this._token;
    }

    public String getIncludeToken() {
        this.populate();
        return this._includeToken;
    }

    public void setIncludeToken(String type) {
    }

    public void setToken(com.sun.xml.ws.security.policy.Token token) {
    }

    public String getTokenId() {
        return this._id;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            String tValue = this.getAttributeValue(this.itQname);
            if (tValue != null) {
                this._includeToken = tValue;
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isToken(assertion, this.spVersion)) {
                    this._token = (com.sun.xml.ws.security.policy.Token)assertion;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "Token");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

